/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypesKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelTypeAliasChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTopLevelTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirTopLevelTypeAliasChecker INSTANCE = new FirTopLevelTypeAliasChecker();

    private FirTopLevelTypeAliasChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirTypeRef expandedTypeRef;
        ConeKotlinType fullyExpandedType2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!FirHelpersKt.isTopLevel(context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getTOPLEVEL_TYPEALIASES_ONLY(), (DiagnosticContext)context2, null, 8, null);
        }
        if (FirTopLevelTypeAliasChecker.check$containsTypeParameter(context2, fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(expandedTypeRef = declaration2.getExpandedTypeRef()), context2.getSession(), null, 2, null)) || fullyExpandedType2 instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), (Object)FirTypeUtilsKt.getConeType(expandedTypeRef), (DiagnosticContext)context2, null, 16, null);
        }
        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(expandedTypeRef, context2, reporter);
    }

    private static final boolean check$containsTypeParameter(CheckerContext $context, ConeKotlinType type2) {
        ConeSimpleKotlinType unwrapped = ConeTypesKt.unwrapToSimpleTypeUsingLowerBound(type2);
        if (unwrapped instanceof ConeTypeParameterType) {
            return true;
        }
        if (unwrapped instanceof ConeClassLikeType && ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)unwrapped).getLookupTag(), $context.getSession()) instanceof FirTypeAliasSymbol) {
            for (ConeTypeProjection typeArgument : unwrapped.getTypeArguments()) {
                ConeKotlinType typeArgumentType;
                ConeKotlinType coneKotlinType = typeArgument instanceof ConeKotlinType ? (ConeKotlinType)typeArgument : null;
                if (coneKotlinType == null) {
                    ConeKotlinTypeProjection coneKotlinTypeProjection = typeArgument instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)typeArgument : null;
                    coneKotlinType = coneKotlinTypeProjection != null ? coneKotlinTypeProjection.getType() : null;
                }
                if ((typeArgumentType = coneKotlinType) == null || !FirTopLevelTypeAliasChecker.check$containsTypeParameter($context, typeArgumentType)) continue;
                return true;
            }
        }
        return false;
    }
}

