/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.extensions;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.core.CoreApplicationEnvironment;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.extensions.ExtensionsArea;
import ksp.com.intellij.openapi.project.Project;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/extensions/ProjectExtensionDescriptor;", "T", "", "name", "", "extensionClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lksp/com/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "registerExtensionPoint", "", "project", "Lksp/com/intellij/openapi/project/Project;", "registerExtension", "extension", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "getInstances", "", "util"})
public class ProjectExtensionDescriptor<T> {
    @NotNull
    private final Class<T> extensionClass;
    @NotNull
    private final ExtensionPointName<T> extensionPointName;

    public ProjectExtensionDescriptor(@NotNull String name2, @NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        this.extensionClass = extensionClass;
        this.extensionPointName = ExtensionPointName.Companion.create(name2);
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CoreApplicationEnvironment.registerExtensionPoint(project.getExtensionArea(), this.extensionPointName.getName(), this.extensionClass);
    }

    public final void registerExtension(@NotNull Project project, @NotNull T extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        project.getExtensionArea().getExtensionPoint(this.extensionPointName).registerExtension(extension, project);
    }

    @NotNull
    public final List<T> getInstances(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExtensionsArea extensionsArea = project.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getExtensionArea(...)");
        ExtensionsArea projectArea = extensionsArea;
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = projectArea.getExtensionPoint(this.extensionPointName).getExtensions();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getExtensions(...)");
        return ArraysKt.toList((Object[])objectArray);
    }
}

