/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.util;

import ksp.com.intellij.codeInsight.runner.JavaMainMethodProvider;
import ksp.com.intellij.openapi.util.Condition;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypes;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.Nullable;

public final class PsiMethodUtil {
    public static final Condition<PsiClass> MAIN_CLASS = psiClass -> {
        if (PsiUtil.isLocalOrAnonymousClass(psiClass)) {
            return false;
        }
        if (psiClass.isAnnotationType()) {
            return false;
        }
        if (psiClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher(psiClass)) {
            return false;
        }
        return psiClass.getContainingClass() == null || psiClass.hasModifierProperty("static");
    };

    private PsiMethodUtil() {
    }

    @Nullable
    public static PsiMethod findMainMethod(PsiClass aClass) {
        for (JavaMainMethodProvider provider2 : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isApplicable(aClass)) continue;
            return provider2.findMainInClass(aClass);
        }
        PsiMethod[] mainMethods = aClass.findMethodsByName("main", true);
        return PsiMethodUtil.findMainMethod(mainMethods, aClass);
    }

    @Nullable
    private static PsiMethod findMainMethod(PsiMethod[] mainMethods, PsiClass aClass) {
        for (PsiMethod mainMethod : mainMethods) {
            PsiClass containingClass = mainMethod.getContainingClass();
            if (containingClass != null && containingClass != aClass && containingClass.isInterface() && PsiUtil.getLanguageLevel(containingClass).isLessThan(LanguageLevel.JDK_21_PREVIEW) || !PsiMethodUtil.isMainMethod(mainMethod)) continue;
            return mainMethod;
        }
        return null;
    }

    public static boolean isMainMethod(PsiMethod method) {
        if (method == null || method.getContainingClass() == null) {
            return false;
        }
        if (!PsiTypes.voidType().equals(method.getReturnType())) {
            return false;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (PsiUtil.getLanguageLevel(method).isAtLeast(LanguageLevel.JDK_21_PREVIEW)) {
            if (!(method.hasModifierProperty("public") || method.hasModifierProperty("packageLocal") || method.hasModifierProperty("protected"))) {
                return false;
            }
            PsiMethod[] constructors2 = method.getContainingClass().getConstructors();
            if (constructors2.length != 0 && !ContainerUtil.exists(constructors2, method1 -> method1.getParameterList().isEmpty())) {
                return false;
            }
            if (parameters2.length == 1) {
                return PsiMethodUtil.isJavaLangStringArray(parameters2[0]);
            }
            return parameters2.length == 0;
        }
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        if (!method.hasModifierProperty("public")) {
            return false;
        }
        if (parameters2.length != 1) {
            return false;
        }
        return PsiMethodUtil.isJavaLangStringArray(parameters2[0]);
    }

    private static boolean isJavaLangStringArray(PsiParameter parameter2) {
        PsiType type2 = parameter2.getType();
        if (!(type2 instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)type2).getComponentType();
        return componentType.equalsToText("java.lang.String");
    }

    public static boolean hasMainMethod(PsiClass psiClass) {
        for (JavaMainMethodProvider provider2 : JavaMainMethodProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isApplicable(psiClass)) continue;
            return provider2.hasMainMethod(psiClass);
        }
        return PsiMethodUtil.findMainMethod(psiClass.findMethodsByName("main", true), psiClass) != null;
    }

    @Nullable
    public static PsiMethod findMainInClass(PsiClass aClass) {
        if (!MAIN_CLASS.value(aClass)) {
            return null;
        }
        PsiMethod method = PsiMethodUtil.findMainMethod(aClass);
        if (method != null && !method.hasModifierProperty("static") && aClass.isInterface()) {
            return null;
        }
        return method;
    }
}

