/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiJavaToken;
import ksp.com.intellij.psi.PsiPolyadicExpression;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.PatternResolveState;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.util.PsiScopesUtil;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.Function;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiPolyadicExpressionImpl
extends ExpressionPsiElement
implements PsiPolyadicExpression {
    private static final Logger LOG = Logger.getInstance(PsiPolyadicExpressionImpl.class);
    private static final Function<PsiPolyadicExpressionImpl, PsiType> MY_TYPE_EVALUATOR = expression2 -> PsiPolyadicExpressionImpl.doGetType(expression2);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create(JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private volatile PsiExpression[] cachedOperands;

    public PsiPolyadicExpressionImpl() {
        super(JavaElementType.POLYADIC_EXPRESSION);
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = ((PsiJavaToken)this.findChildByRoleAsPsiElement(63)).getTokenType();
        if (iElementType == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(1);
        }
        for (PsiElement element2 = operand; element2 != null; element2 = element2.getPrevSibling()) {
            if (this.getChildRole(element2.getNode()) != 63) continue;
            return (PsiJavaToken)element2;
        }
        return null;
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Nullable
    private static PsiType doGetType(PsiPolyadicExpressionImpl param) {
        PsiExpression[] operands = param.getOperands();
        PsiType lType = null;
        IElementType sign = param.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiType rType = operands[i].getType();
            PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression(null, rType, sign, false);
            if (type2 != TypeConversionUtil.NULL_TYPE) {
                return type2;
            }
            if (lType == null) {
                lType = operands[0].getType();
            }
            lType = TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, sign, true);
        }
        return lType;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        if (role == 63) {
            return this.findChildByType(OUR_OPERATIONS_BIT_SET);
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPolyadicExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiExpression @NotNull [] getOperands() {
        PsiExpression[] operands = this.cachedOperands;
        if (operands == null) {
            operands = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
            this.cachedOperands = operands;
        }
        if (operands == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(4);
        }
        return operands;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(7);
        }
        return PsiPolyadicExpressionImpl.processDeclarations(this, processor, state, lastParent, place);
    }

    static boolean processDeclarations(@NotNull PsiPolyadicExpression expression2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (expression2 == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(9);
        }
        if (state == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(10);
        }
        if (place == null) {
            PsiPolyadicExpressionImpl.$$$reportNull$$$0(11);
        }
        IElementType tokenType = expression2.getOperationTokenType();
        boolean and2 = tokenType.equals(JavaTokenType.ANDAND);
        boolean or2 = tokenType.equals(JavaTokenType.OROR);
        if (!and2 && !or2) {
            return true;
        }
        ElementClassHint elementClassHint = processor.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        PatternResolveState wantedHint = PatternResolveState.fromBoolean(and2);
        if (state.get(PatternResolveState.KEY) == wantedHint.invert()) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes(expression2, processor, wantedHint.putInto(state), lastParent, place);
    }

    @Override
    public void clearCaches() {
        this.cachedOperands = null;
        super.clearCaches();
    }

    @Override
    public String toString() {
        return "PsiPolyadicExpression: " + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationTokenType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiPolyadicExpressionImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTokenBeforeOperand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

