/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.fileEditor.impl;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.editor.event.DocumentListener;
import ksp.com.intellij.openapi.editor.ex.DocumentEx;
import ksp.com.intellij.openapi.editor.impl.FrozenDocument;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import ksp.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.io.FileUtilRt;
import ksp.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.encoding.EncodingManager;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.testFramework.LightVirtualFile;
import ksp.com.intellij.util.FileContentUtilCore;
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManagerBase
extends FileDocumentManager {
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create("HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Boolean> TRACK_NON_PHYSICAL = Key.create("TRACK_NON_PHYSICAL");
    private static final Key<VirtualFile> FILE_KEY = Key.create("FILE_KEY");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create("BIG_FILE_PREVIEW");
    private static final Object lock = new Object();
    private final Map<VirtualFile, Document> myDocumentCache = CollectionFactory.createConcurrentWeakValueMap();

    @ApiStatus.Experimental
    public static boolean isTrackable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(0);
        }
        return !(file2.getFileSystem() instanceof NonPhysicalFileSystem) || Boolean.TRUE.equals(file2.getUserData(TRACK_NON_PHYSICAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresReadLock
    @Nullable
    public final Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file2);
        if (document != null) {
            return document;
        }
        if (!file2.isValid() || file2.isDirectory() || FileDocumentManagerBase.isBinaryWithoutDecompiler(file2)) {
            return null;
        }
        boolean tooLarge = FileUtilRt.isTooLarge(file2.getLength());
        if (file2.getFileType().isBinary() && tooLarge) {
            return null;
        }
        CharSequence text = this.loadText(file2, tooLarge);
        Object object = lock;
        synchronized (object) {
            document = (DocumentEx)this.getCachedDocument(file2);
            if (document != null) {
                return document;
            }
            document = this.createDocument(text, file2);
            document.setModificationStamp(file2.getModificationStamp());
            FileDocumentManagerBase.setDocumentTooLarge(document, tooLarge);
            FileType fileType = file2.getFileType();
            document.setReadOnly(tooLarge || !file2.isWritable() || fileType.isBinary());
            if (FileDocumentManagerBase.isTrackable(file2)) {
                document.addDocumentListener(this.getDocumentListener());
            }
            if (file2 instanceof LightVirtualFile) {
                FileDocumentManagerBase.registerDocument(document, file2);
            } else {
                document.putUserData(FILE_KEY, file2);
                this.cacheDocument(file2, document);
            }
        }
        this.fileContentLoaded(file2, document);
        return document;
    }

    protected static void setDocumentTooLarge(Document document, boolean tooLarge) {
        document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
    }

    @NotNull
    private CharSequence loadText(@NotNull VirtualFile file2, boolean tooLarge) {
        FileViewProvider vp;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(2);
        }
        if (file2 instanceof LightVirtualFile && (vp = this.findCachedPsiInAnyProject(file2)) != null) {
            String string2 = vp.getPsi(vp.getBaseLanguage()).getText();
            if (string2 == null) {
                FileDocumentManagerBase.$$$reportNull$$$0(3);
            }
            return string2;
        }
        CharSequence charSequence = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerBase.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
        if (charSequence == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @NotNull
    protected abstract DocumentEx createDocument(@NotNull CharSequence var1, @NotNull VirtualFile var2);

    @Override
    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        Document hard;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(5);
        }
        return (hard = file2.getUserData(HARD_REF_TO_DOCUMENT_KEY)) != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(7);
        }
        if (!(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem)) {
            throw new IllegalArgumentException("Hard-coding file<->document association is permitted for non-physical files only (see FileViewProvider.isPhysical()) to avoid memory leaks. virtualFile=" + virtualFile);
        }
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, document);
        }
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(8);
        }
        return document instanceof FrozenDocument ? null : document.getUserData(FILE_KEY);
    }

    @Override
    public void reloadBinaryFiles() {
        List<VirtualFile> binaries = ContainerUtil.filter(this.myDocumentCache.keySet(), file2 -> file2.getFileType().isBinary());
        FileContentUtilCore.reparseFiles(binaries);
    }

    @Override
    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(9);
        }
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(10);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(11);
        }
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    protected static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType type2;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(12);
        }
        return (type2 = file2.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(type2) == null;
    }

    protected static int getPreviewCharCount(@NotNull VirtualFile file2) {
        Charset charset;
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(13);
        }
        float bytesPerChar = (charset = EncodingManager.getInstance().getEncoding(file2, false)) == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(14);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(15);
        }
        this.myDocumentCache.put(file2, document);
    }

    private void removeDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(16);
        }
        this.myDocumentCache.remove(file2);
    }

    private Document getDocumentFromCache(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(17);
        }
        return this.myDocumentCache.get(file2);
    }

    @ApiStatus.Internal
    protected void clearDocumentCache() {
        this.myDocumentCache.clear();
    }

    protected abstract void fileContentLoaded(@NotNull VirtualFile var1, @NotNull Document var2);

    @NotNull
    protected abstract DocumentListener getDocumentListener();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTrackable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentFromCache";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

