/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.initializer;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import ksp.org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import ksp.org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    @Override
    protected Void emptyResult(@NotNull TranslationContext context2) {
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Override
    public final Void visitProperty(@NotNull KtProperty property, @NotNull TranslationContext context2) {
        if (property == null) {
            InitializerVisitor.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(2);
        }
        PropertyDescriptor descriptor2 = BindingUtils.getPropertyDescriptor(context2.bindingContext(), property);
        JsExpression value2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context2, property);
        JsStatement statement = null;
        KtExpression initializer = property.getInitializer();
        KtExpression delegate = property.getDelegateExpression();
        if (initializer != null) {
            assert (value2 != null);
            KotlinType type2 = TranslationUtils.isReferenceToSyntheticBackingField(descriptor2) ? descriptor2.getType() : TranslationUtils.getReturnTypeForCoercion(descriptor2);
            value2 = TranslationUtils.coerce(context2, value2, type2);
            statement = InitializerUtils.generateInitializerForProperty(context2, descriptor2, value2);
        } else if (delegate != null) {
            assert (value2 != null);
            statement = InitializerUtils.generateInitializerForDelegate(context2, descriptor2, value2);
        } else if (Boolean.TRUE.equals(context2.bindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context2, descriptor2);
            JsExpression defaultValue = InitializerVisitor.generateDefaultValue(descriptor2, backingFieldReference);
            statement = TranslationUtils.assignmentToBackingField(context2, descriptor2, defaultValue).source(property).makeStmt();
        } else if (JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsNameRef propRef = new JsNameRef(context2.getNameForDescriptor(descriptor2), (JsExpression)new JsThisRef());
            JsExpression defaultValue = InitializerVisitor.generateDefaultValue(descriptor2, propRef);
            statement = JsAstUtils.assignment(propRef, defaultValue).source(property).makeStmt();
        }
        if (statement != null && !JsAstUtils.isEmptyStatement(statement)) {
            context2.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(statement));
        }
        return null;
    }

    @NotNull
    private static JsExpression generateDefaultValue(@NotNull PropertyDescriptor property, @NotNull JsExpression lateInitDefault) {
        if (property == null) {
            InitializerVisitor.$$$reportNull$$$0(3);
        }
        if (lateInitDefault == null) {
            InitializerVisitor.$$$reportNull$$$0(4);
        }
        if (property.isLateInit()) {
            JsExpression jsExpression = lateInitDefault.deepCopy();
            if (jsExpression == null) {
                InitializerVisitor.$$$reportNull$$$0(5);
            }
            return jsExpression;
        }
        KotlinType type2 = property.getType();
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2) || KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isShort(type2)) {
            return new JsIntLiteral(0);
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return new JsBooleanLiteral(false);
        }
        return new JsNullLiteral();
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer, @NotNull TranslationContext context2) {
        KtExpression initializerBody;
        if (initializer == null) {
            InitializerVisitor.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(7);
        }
        if ((initializerBody = initializer.getBody()) != null) {
            context2.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(Translation.translateAsStatementAndMergeInBlockIfNeeded(initializerBody, context2)));
        }
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull KtDeclaration expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            InitializerVisitor.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            InitializerVisitor.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, TranslationContext data) {
        if (constructor == null) {
            InitializerVisitor.$$$reportNull$$$0(10);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lateInitDefault";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "emptyResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDefaultValue";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitAnonymousInitializer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitSecondaryConstructor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

