/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.js.naming.JsNameSuggestion;
import ksp.org.jetbrains.kotlin.js.naming.SuggestedName;
import ksp.org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import ksp.org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "nameSuggestion", "Lksp/org/jetbrains/kotlin/js/naming/JsNameSuggestion;", "<init>", "(Lorg/jetbrains/kotlin/js/naming/JsNameSuggestion;)V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Companion", "js.frontend"})
public final class JsBuiltinNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsNameSuggestion nameSuggestion;
    @JvmField
    @NotNull
    public static final Set<String> PROHIBITED_STATIC_NAMES;
    @JvmField
    @NotNull
    public static final Set<String> PROHIBITED_MEMBER_NAMES;

    public JsBuiltinNameClashChecker(@NotNull JsNameSuggestion nameSuggestion) {
        Intrinsics.checkNotNullParameter((Object)nameSuggestion, (String)"nameSuggestion");
        this.nameSuggestion = nameSuggestion;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return;
        }
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        SuggestedName suggestedName = this.nameSuggestion.suggest(descriptor2, bindingContext);
        Intrinsics.checkNotNull((Object)suggestedName);
        SuggestedName suggestedName2 = suggestedName;
        if (!suggestedName2.getStable()) {
            return;
        }
        String simpleName2 = (String)CollectionsKt.single(suggestedName2.getNames());
        if (descriptor2 instanceof ClassDescriptor) {
            if (PROHIBITED_STATIC_NAMES.contains(simpleName2)) {
                context2.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration2), "Function." + simpleName2));
            }
        } else if (descriptor2 instanceof CallableMemberDescriptor && PROHIBITED_MEMBER_NAMES.contains(simpleName2)) {
            context2.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration2), "Object.prototype." + simpleName2));
        }
    }

    static {
        Object[] objectArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf((Object[])objectArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf((Object)"constructor");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker$Companion;", "", "<init>", "()V", "PROHIBITED_STATIC_NAMES", "", "", "PROHIBITED_MEMBER_NAMES", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

