/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.JvmTarget;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.java.FirJvmTargetProvider;
import ksp.org.jetbrains.kotlin.fir.java.FirJvmTargetProviderKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import ksp.org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import ksp.org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInlineTargetQualifiedAccessChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInlineTargetVersion", "callableSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInlineTargetQualifiedAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInlineTargetQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInlineTargetQualifiedAccessChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,86:1\n28#2:87\n28#2:88\n*S KotlinDebug\n*F\n+ 1 FirJvmInlineTargetQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInlineTargetQualifiedAccessChecker\n*L\n39#1:87\n42#1:88\n*E\n"})
public final class FirJvmInlineTargetQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJvmInlineTargetQualifiedAccessChecker INSTANCE = new FirJvmInlineTargetQualifiedAccessChecker();

    private FirJvmInlineTargetQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        if (callableSymbol.getOrigin().getFromSource()) {
            return;
        }
        FirCallableSymbol firCallableSymbol2 = callableSymbol;
        if (firCallableSymbol2 instanceof FirFunctionSymbol) {
            FirCallableSymbol $this$isInline$iv = callableSymbol;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getRawStatus().isInline();
        } else {
            if (!(firCallableSymbol2 instanceof FirPropertySymbol)) return;
            FirPropertyAccessorSymbol accessor = FirHelpersKt.isLhsOfAssignment(expression2, context2) ? ((FirPropertySymbol)callableSymbol).getSetterSymbol() : ((FirPropertySymbol)callableSymbol).getGetterSymbol();
            if (accessor == null) return;
            FirCallableSymbol $this$isInline$iv = accessor;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getRawStatus().isInline()) return;
            bl = true;
        }
        boolean isInline = bl;
        if (!isInline) return;
        this.checkInlineTargetVersion(callableSymbol, context2, reporter, expression2);
    }

    private final void checkInlineTargetVersion(FirCallableSymbol<?> callableSymbol, CheckerContext context2, DiagnosticReporter reporter, FirElement element2) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass;
        Object object = FirJvmTargetProviderKt.getJvmTargetProvider(context2.getSession());
        if (object == null || (object = ((FirJvmTargetProvider)object).getJvmTarget()) == null) {
            return;
        }
        Object currentJvmTarget = object;
        ConeClassLikeLookupTag containingClass = ClassMembersKt.containingClassLookupTag(callableSymbol);
        if (containingClass != null) {
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(containingClass, context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            SourceElement sourceElement = DeclarationAttributesKt.getSourceElement((FirClassLikeDeclaration)containingClassSymbol.getFir());
            KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
            if (kotlinJvmBinarySourceElement == null) {
                return;
            }
            KotlinJvmBinarySourceElement sourceElement2 = kotlinJvmBinarySourceElement;
            kotlinJvmBinaryClass = sourceElement2.getBinaryClass();
        } else {
            DeserializedContainerSource deserializedContainerSource = callableSymbol.getContainerSource();
            JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
            if (jvmPackagePartSource == null) {
                return;
            }
            JvmPackagePartSource containerSource = jvmPackagePartSource;
            kotlinJvmBinaryClass = containerSource.getKnownJvmBinaryClass();
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass;
        FileBasedKotlinClass fileBasedKotlinClass = binaryClass instanceof FileBasedKotlinClass ? (FileBasedKotlinClass)binaryClass : null;
        if (fileBasedKotlinClass == null) {
            return;
        }
        int inlinedVersion = fileBasedKotlinClass.getClassVersion();
        int currentVersion = ((JvmTarget)currentJvmTarget).getMajorVersion();
        if (currentVersion < inlinedVersion) {
            Object object2 = ReferenceUtilsKt.toReference(element2, context2.getSession());
            if (object2 == null || (object2 = ((FirReference)object2).getSource()) == null) {
                object2 = element2.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)object2, FirJvmErrors.INSTANCE.getINLINE_FROM_HIGHER_PLATFORM(), (Object)JvmTarget.Companion.getDescription(inlinedVersion), (Object)JvmTarget.Companion.getDescription(currentVersion), (DiagnosticContext)context2, null, 32, null);
        }
    }
}

