/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsRuntimeAnnotationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
public final class FirJsRuntimeAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsRuntimeAnnotationChecker INSTANCE = new FirJsRuntimeAnnotationChecker();

    private FirJsRuntimeAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirAnnotation annotation : declaration2.getAnnotations()) {
            FirClassLikeSymbol<?> annotationClassSymbol;
            if (FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation, context2.getSession()) == null || FirRetentionAnnotationHelpersKt.getExplicitAnnotationRetention(annotationClassSymbol, context2.getSession()) != AnnotationRetention.RUNTIME) continue;
            if (declaration2 instanceof FirMemberDeclaration && FirJsHelpersKt.isEffectivelyExternal(((FirMemberDeclaration)declaration2).getSymbol(), context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJsErrors.INSTANCE.getRUNTIME_ANNOTATION_ON_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirJsErrors.INSTANCE.getRUNTIME_ANNOTATION_NOT_SUPPORTED(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

