/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryToRendererMap;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderers;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.BaseDiagnosticRendererFactory;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.CommonRenderers;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import ksp.org.jetbrains.kotlin.diagnostics.rendering.LanguageFeatureMessageRenderer;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderers;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrorsDefaultMessagesKt;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirExpectActualAnnotationIncompatibilityDiagnosticRenderers;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirIncompatibleExpectedActualClassScopesRenderer;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirPlatformIncompatibilityDiagnosticRenderer;
import ksp.org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/diagnostics/FirErrorsDefaultMessages;", "Lksp/org/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;", "<init>", "()V", "MAP", "Lksp/org/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "getMAP", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "checkers"})
public final class FirErrorsDefaultMessages
extends BaseDiagnosticRendererFactory {
    @NotNull
    public static final FirErrorsDefaultMessages INSTANCE;
    @NotNull
    private static final KtDiagnosticFactoryToRendererMap MAP;

    private FirErrorsDefaultMessages() {
    }

    @Override
    @NotNull
    public KtDiagnosticFactoryToRendererMap getMAP() {
        return MAP;
    }

    private static final String MAP$lambda$2$lambda$0(List symbols) {
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        if (symbols.isEmpty()) {
            return "";
        }
        return " Potential signatures for overriding:" + FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES().render(symbols);
    }

    private static final String MAP$lambda$2$lambda$1(IncompatibleVersionErrorData incompatibility) {
        Intrinsics.checkNotNullParameter((Object)incompatibility, (String)"incompatibility");
        return "The actual metadata version is " + incompatibility.getActualVersion() + ", but the compiler version " + incompatibility.getCompilerVersion() + (Intrinsics.areEqual(incompatibility.getLanguageVersion(), incompatibility.getCompilerVersion()) ? "" : " [with language version " + incompatibility.getLanguageVersion() + ']') + " can read versions up to " + incompatibility.getExpectedVersion() + ".\nThe class is loaded from " + FileUtil.toSystemIndependentName(incompatibility.getFilePath());
    }

    static {
        KtDiagnosticFactoryToRendererMap ktDiagnosticFactoryToRendererMap;
        INSTANCE = new FirErrorsDefaultMessages();
        KtDiagnosticFactoryToRendererMap map = ktDiagnosticFactoryToRendererMap = new KtDiagnosticFactoryToRendererMap("FIR");
        boolean bl = false;
        map.put(FirErrors.INSTANCE.getUNSUPPORTED(), "Unsupported [{0}].", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), "{0}", (DiagnosticParameterRenderer)new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.UNSUPPORTED, false, 2, null));
        map.put(FirErrors.INSTANCE.getUNSUPPORTED_SUSPEND_TEST(), "'suspend' functions annotated with '@kotlin.test.Test' are unsupported.");
        map.put(FirErrors.INSTANCE.getNEW_INFERENCE_ERROR(), "New inference error [{0}].", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOTHER_ERROR(), "Unknown error.");
        map.put(FirErrors.INSTANCE.getOTHER_ERROR_WITH_REASON(), "Unknown error: {0}.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getILLEGAL_CONST_EXPRESSION(), "Incorrect const expression.");
        map.put(FirErrors.INSTANCE.getILLEGAL_UNDERSCORE(), "Incorrect usage of underscore in numeric literal.");
        map.put(FirErrors.INSTANCE.getBREAK_OR_CONTINUE_OUTSIDE_A_LOOP(), "'break' and 'continue' are only allowed inside loops.");
        map.put(FirErrors.INSTANCE.getNOT_A_LOOP_LABEL(), "Label does not denote a reachable loop.");
        map.put(FirErrors.INSTANCE.getBREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY(), "'break' or 'continue' crosses a function or class boundary.");
        map.put(FirErrors.INSTANCE.getVARIABLE_EXPECTED(), "Variable expected.");
        map.put(FirErrors.INSTANCE.getDELEGATION_IN_INTERFACE(), "Delegation cannot be used in interfaces.");
        map.put(FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), "Delegation is supported only for interfaces.");
        map.put(FirErrors.INSTANCE.getDELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE(), "Delegated member ''{0}'' hides supertype override ''{1}''. Please specify proper override explicitly.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNESTED_CLASS_NOT_ALLOWED(), "''{0}'' is prohibited here.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVAL_OR_VAR_ON_LOOP_PARAMETER(), "''{0}'' on loop parameter is prohibited.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVAL_OR_VAR_ON_FUN_PARAMETER(), "''{0}'' on function parameter is prohibited.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVAL_OR_VAR_ON_CATCH_PARAMETER(), "''{0}'' on catch parameter is prohibited.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER(), "''{0}'' on secondary constructor parameter is prohibited.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDEPRECATION(), "''{0}'' is deprecated.{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getOPTIONAL_SENTENCE());
        map.put(FirErrors.INSTANCE.getDEPRECATION_ERROR(), "''{0}'' is deprecated.{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getOPTIONAL_SENTENCE());
        map.put(FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION(), "''{0}''{1} should not be used in Kotlin {2}.{3}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getREQUIRE_KOTLIN_VERSION(), (DiagnosticParameterRenderer)CommonRenderers.STRING, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getOPTIONAL_SENTENCE());
        map.put(FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION_ERROR(), "''{0}''{1} cannot be used in Kotlin {2}.{3}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getREQUIRE_KOTLIN_VERSION(), (DiagnosticParameterRenderer)CommonRenderers.STRING, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getOPTIONAL_SENTENCE());
        map.put(FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION(), "''{0}'' uses ''{1}'', which is deprecated. {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION_ERROR(), "''{0}'' uses ''{1}'', which is an error. {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getAPI_NOT_AVAILABLE(), "This declaration is only available in Kotlin {0} and newer versions and cannot be used with the specified API version {1}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), "Cannot access class ''{0}''. Check your module classpath for missing or conflicting dependencies.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_EXPRESSION_TYPE(), "Cannot access class ''{0}'' in the expression type. While it may work, this case indicates a configuration mistake and can lead to avoidable compilation errors, so it may be forbidden soon. Check your module classpath for missing or conflicting dependencies.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS(), "Cannot access ''{0}'' which is a supertype of ''{1}''. Check your module classpath for missing or conflicting dependencies.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS_IN_TYPE_ARGUMENT(), "Cannot access ''{0}'' which is a supertype of ''{1}'' or one of its type/supertype arguments. While it may work, this case indicates a configuration mistake and can lead to avoidable compilation errors, so it may be forbidden soon. Check your module classpath for missing or conflicting dependencies.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_LAMBDA_PARAMETER(), "Class ''{0}'' of the parameter ''{1}'' is inaccessible. While it may work, this case indicates a configuration mistake and can lead to avoidable compilation errors, so it may be forbidden soon. Check your module classpath for missing or conflicting dependencies.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)CommonRenderers.NAME);
        map.put(FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_LAMBDA_RECEIVER(), "Class ''{0}'' of the lambda receiver is inaccessible. While it may work, this case indicates a configuration mistake and can lead to avoidable compilation errors, so it may be forbidden soon. Check your module classpath for missing or conflicting dependencies.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getASSIGNMENT_IN_EXPRESSION_CONTEXT(), "Only expressions are allowed in this context.");
        map.put(FirErrors.INSTANCE.getEXPRESSION_EXPECTED(), "Only expressions are allowed here.");
        map.put(FirErrors.INSTANCE.getDIVISION_BY_ZERO(), "Division by zero.");
        map.put(FirErrors.INSTANCE.getINT_LITERAL_OUT_OF_RANGE(), "Value out of range.");
        map.put(FirErrors.INSTANCE.getWRONG_LONG_SUFFIX(), "Use 'L' instead of 'l'.");
        map.put(FirErrors.INSTANCE.getEMPTY_CHARACTER_LITERAL(), "Empty character literal.");
        map.put(FirErrors.INSTANCE.getFLOAT_LITERAL_OUT_OF_RANGE(), "Value out of range.");
        map.put(FirErrors.INSTANCE.getUNSIGNED_LITERAL_WITHOUT_DECLARATIONS_ON_CLASSPATH(), "Type of constant expression cannot be resolved. Please make sure you have the required dependencies for unsigned types in the classpath.");
        map.put(FirErrors.INSTANCE.getINCORRECT_CHARACTER_LITERAL(), "Incorrect character literal.");
        map.put(FirErrors.INSTANCE.getTOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL(), "Too many characters in a character literal.");
        map.put(FirErrors.INSTANCE.getILLEGAL_ESCAPE(), "Unsupported escape sequence.");
        map.put(FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), "Null cannot be a value of a non-null type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getINVISIBLE_REFERENCE(), "Cannot access ''{0}'': it is {1} in {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getVISIBILITY(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getNAME_OF_DECLARATION_OR_FILE());
        map.put(FirErrors.INSTANCE.getINVISIBLE_SETTER(), "Cannot access ''{0}'': it is {1} in {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getVISIBILITY(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getNAME_OF_CONTAINING_DECLARATION_OR_FILE());
        map.put(FirErrors.INSTANCE.getINNER_ON_TOP_LEVEL_SCRIPT_CLASS(), "Top-level script class cannot be inner.");
        map.put(FirErrors.INSTANCE.getERROR_SUPPRESSION(), "This code uses error suppression for ''{0}''. While it might compile and work, the compiler behavior is UNSPECIFIED and WON''T BE PRESERVED. Please report your use case to the Kotlin issue tracker instead: https://kotl.in/issue", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getMISSING_CONSTRUCTOR_KEYWORD(), "Use the 'constructor' keyword after the modifiers of the primary constructor.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_INTERPOLATION_PREFIX(), "Redundant interpolation prefix.");
        map.put(FirErrors.INSTANCE.getUNRESOLVED_REFERENCE(), "Unresolved reference ''{0}''{1}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNULLABLE_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getFOR_OPTIONAL_OPERATOR());
        map.put(FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), "Unresolved reference ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNULLABLE_STRING());
        map.put(FirErrors.INSTANCE.getDUPLICATE_PARAMETER_NAME_IN_FUNCTION_TYPE(), "Duplicate parameter name in a function type.");
        map.put(FirErrors.INSTANCE.getUNRESOLVED_LABEL(), "Unresolved label.");
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_LABEL(), "Ambiguous label.");
        map.put(FirErrors.INSTANCE.getLABEL_NAME_CLASH(), "There is more than one label with such a name in this scope.");
        map.put(FirErrors.INSTANCE.getDESERIALIZATION_ERROR(), "Deserialization error.");
        map.put(FirErrors.INSTANCE.getERROR_FROM_JAVA_RESOLUTION(), "Java resolution error.");
        map.put(FirErrors.INSTANCE.getMISSING_STDLIB_CLASS(), "Missing stdlib class.");
        map.put(FirErrors.INSTANCE.getNO_THIS(), "'this' is not defined in this context.");
        map.put(FirErrors.INSTANCE.getSUPER_IS_NOT_AN_EXPRESSION(), "'super' cannot be a callee.");
        map.put(FirErrors.INSTANCE.getSUPER_NOT_AVAILABLE(), "No supertypes are accessible in this context.");
        map.put(FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), "Abstract member cannot be accessed directly.");
        map.put(FirErrors.INSTANCE.getABSTRACT_SUPER_CALL_WARNING(), "Access to abstract fake override member is deprecated. See https://youtrack.jetbrains.com/issue/KT-49017.");
        map.put(FirErrors.INSTANCE.getINSTANCE_ACCESS_BEFORE_SUPER_CALL(), "Cannot access ''{0}'' before the instance has been initialized.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCREATING_AN_INSTANCE_OF_ABSTRACT_CLASS(), "Cannot create an instance of an abstract class.");
        map.put(FirErrors.INSTANCE.getNO_CONSTRUCTOR(), "This type does not have a constructor.");
        map.put(FirErrors.INSTANCE.getFUNCTION_CALL_EXPECTED(), "Function invocation ''{0}({1})'' expected.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getFUNCTION_PARAMETERS());
        map.put(FirErrors.INSTANCE.getFUNCTION_EXPECTED(), "Expression ''{0}'' of type ''{1}'' cannot be invoked as a function. Function ''invoke()'' is not found.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getINTERFACE_AS_FUNCTION(), "Interface ''{0}'' does not have constructors.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getEXPECT_CLASS_AS_FUNCTION(), "Expected class ''{0}'' does not have default constructor.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getINNER_CLASS_CONSTRUCTOR_NO_RECEIVER(), "Constructor of the inner class ''{0}'' can only be called with a receiver of the containing class.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getRESOLUTION_TO_CLASSIFIER(), "Resolution to the classifier ''{0}'' is not appropriate here.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_ALTERED_ASSIGN(), "Multiple extensions attempted to alter this assignment at the same time. Extensions: {0}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.COLLECTION(KtDiagnosticRenderers.INSTANCE.getNULLABLE_STRING()));
        map.put(FirErrors.INSTANCE.getPLUGIN_AMBIGUOUS_INTERCEPTED_SYMBOL(), "Multiple extensions attempted to modify this function call. Extensions: {0}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.COLLECTION(KtDiagnosticRenderers.INSTANCE.getNULLABLE_STRING()));
        map.put(FirErrors.INSTANCE.getDEPRECATED_BINARY_MOD(), "Convention for ''{0}'' is prohibited. Use ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getFORBIDDEN_BINARY_MOD(), "Deprecated convention for ''{0}''. Use ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getILLEGAL_SELECTOR(), "The expression cannot be a selector (cannot occur after a dot).");
        map.put(FirErrors.INSTANCE.getNO_RECEIVER_ALLOWED(), "No receiver can be passed to this function or property.");
        map.put(FirErrors.INSTANCE.getSUPER_CALL_WITH_DEFAULT_PARAMETERS(), "Super-calls with default arguments are prohibited. Please specify all arguments of ''super.{0}'' explicitly.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNOT_A_SUPERTYPE(), "Not an immediate supertype.");
        map.put(FirErrors.INSTANCE.getTYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER(), "Type arguments do not need to be specified in a 'super' qualifier.");
        map.put(FirErrors.INSTANCE.getSUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE(), "Superclass is not accessible from interface.");
        map.put(FirErrors.INSTANCE.getQUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE(), "Explicitly qualified supertype is extended by supertype ''{0}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), "Interfaces cannot initialize supertypes.");
        map.put(FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), "An interface cannot extend a class.");
        map.put(FirErrors.INSTANCE.getFINAL_SUPERTYPE(), "This type is final, so it cannot be extended.");
        map.put(FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), "Class ''{0}'' cannot be extended directly.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), "Extension function type is not allowed as a supertype.");
        map.put(FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), "Cannot extend an object.");
        map.put(FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), "Supertypes cannot be nullable.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_NULLABLE(), "Redundant '?'.");
        map.put(FirErrors.INSTANCE.getPLATFORM_CLASS_MAPPED_TO_KOTLIN(), "This class is not recommended for use in Kotlin. Use ''{0}'' instead.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID());
        map.put(FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), "Only one class can appear in a supertype list.");
        map.put(FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), "A supertype appears twice.");
        map.put(FirErrors.INSTANCE.getCLASS_IN_SUPERTYPE_FOR_ENUM(), "Enum classes cannot extend classes.");
        map.put(FirErrors.INSTANCE.getSEALED_SUPERTYPE(), "This type is sealed. It can only be extended by classes or objects in the same package.");
        map.put(FirErrors.INSTANCE.getSEALED_SUPERTYPE_IN_LOCAL_CLASS(), "{0} cannot extend a sealed {1}.", (DiagnosticParameterRenderer)CommonRenderers.STRING, (DiagnosticParameterRenderer)CommonRenderers.CLASS_KIND);
        map.put(FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_PACKAGE(), "A class can only extend a sealed class or interface declared in the same package.");
        map.put(FirErrors.INSTANCE.getSEALED_INHERITOR_IN_DIFFERENT_MODULE(), "Extending sealed classes or interfaces from a different module is prohibited.");
        map.put(FirErrors.INSTANCE.getCLASS_INHERITS_JAVA_SEALED_CLASS(), "Extending Java sealed classes is prohibited.");
        map.put(FirErrors.INSTANCE.getUNSUPPORTED_SEALED_FUN_INTERFACE(), "'sealed fun interface' is unsupported.");
        map.put(FirErrors.INSTANCE.getSUPERTYPE_NOT_A_CLASS_OR_INTERFACE(), "Supertype is not a class or interface.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getUNSUPPORTED_INHERITANCE_FROM_JAVA_MEMBER_REFERENCING_KOTLIN_FUNCTION(), "Inheritance of a Java member referencing ''kotlin.jvm.functions.FunctionN'': {0} is unsupported.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getCYCLIC_INHERITANCE_HIERARCHY(), "Cycle formed in the inheritance hierarchy of this type.");
        map.put(FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), "Projections for immediate arguments of a supertype are prohibited.");
        map.put(FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_VALUES(), "Type parameter ''{0}'' of ''{1}'' has inconsistent values: {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), FirDiagnosticRenderers.INSTANCE.getRENDER_COLLECTION_OF_TYPES());
        map.put(FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_BOUNDS(), "Type parameter ''{0}'' of ''{1}'' has inconsistent bounds: {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), FirDiagnosticRenderers.INSTANCE.getRENDER_COLLECTION_OF_TYPES());
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_SUPER(), "Multiple supertypes available. Please specify the intended supertype in angle brackets, e.g. ''super<Foo>''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getCONSTRUCTOR_IN_OBJECT(), "Objects cannot have constructors.");
        map.put(FirErrors.INSTANCE.getCONSTRUCTOR_IN_INTERFACE(), "Interfaces cannot have constructors.");
        map.put(FirErrors.INSTANCE.getNON_PRIVATE_CONSTRUCTOR_IN_ENUM(), "Constructor must be private in enum class.");
        map.put(FirErrors.INSTANCE.getNON_PRIVATE_OR_PROTECTED_CONSTRUCTOR_IN_SEALED(), "Constructor must be private or protected in sealed class.");
        map.put(FirErrors.INSTANCE.getCYCLIC_CONSTRUCTOR_DELEGATION_CALL(), "There's a cycle in the delegation calls chain.");
        map.put(FirErrors.INSTANCE.getPRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED(), "Primary constructor call expected.");
        map.put(FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL(), "Protected constructor ''{0}'' from other classes can only be used in super-call.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), "Supertype initialization is impossible without a primary constructor.");
        map.put(FirErrors.INSTANCE.getDELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR(), "Calls to super in enum constructors are prohibited.");
        map.put(FirErrors.INSTANCE.getEXPLICIT_DELEGATION_CALL_REQUIRED(), "Explicit 'this' or 'super' call is required. There is no constructor in the superclass that can be called without arguments.");
        map.put(FirErrors.INSTANCE.getSEALED_CLASS_CONSTRUCTOR_CALL(), "Sealed types cannot be instantiated.");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_COPY_VISIBILITY_WILL_BE_CHANGED(), "Non-public primary constructor is exposed via the generated 'copy()' method of the 'data' class.\n\nThe generated 'copy()' will change its visibility in future releases.\n\nTo suppress the warning do one of the following:\n- Annotate the data class with the '@ConsistentCopyVisibility' annotation.\n- Use the '-Xconsistent-data-class-copy-visibility' compiler flag.\n- Annotate the data class with the '@ExposedCopyVisibility' annotation \n  (Discouraged, but can be used to keep binary compatibility).\n\nTo learn more, see the documentation of the '@ConsistentCopyVisibility' and '@ExposedCopyVisibility' annotations.\n\n");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_INVISIBLE_COPY_USAGE(), "This 'copy()' exposes the non-public primary constructor of a 'data class'. Please migrate the usage. See the appropriate 'data class' documentation or contact the 'data class' author for migration guidance.");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), "'@ConsistentCopyVisibility' and '@ExposedCopyVisibility' are incompatible.");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), "'@ConsistentCopyVisibility' and '@ExposedCopyVisibility' can only be applied to data classes.");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), "Data class must have at least one primary constructor parameter.");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_VARARG_PARAMETER(), "Primary constructor vararg parameters are prohibited for data classes.");
        map.put(FirErrors.INSTANCE.getDATA_CLASS_NOT_PROPERTY_PARAMETER(), "Primary constructor of data class must only have property ('val' / 'var') parameters.");
        map.put(FirErrors.INSTANCE.getANNOTATION_USED_AS_ANNOTATION_ARGUMENT(), "Annotations cannot be used as annotation arguments.");
        map.put(FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), "Members are prohibited in annotation classes.");
        map.put(FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_CONST(), "Annotation argument must be a compile-time constant.");
        map.put(FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST(), "Enum annotation argument must be an enum constant.");
        map.put(FirErrors.INSTANCE.getANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL(), "Annotation argument must be class literal (T::class).");
        map.put(FirErrors.INSTANCE.getANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR(), "Type parameter in class literal is deprecated in an annotation argument.");
        map.put(FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), "Default value of annotation parameter must be a compile-time constant.");
        map.put(FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), "Annotation class cannot be local.");
        map.put(FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), "'val' keyword is missing in annotation parameter.");
        map.put(FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), "Annotation parameters cannot be nullable.");
        map.put(FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), "Invalid type of annotation member.");
        map.put(FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), "An annotation parameter cannot be 'var'.");
        map.put(FirErrors.INSTANCE.getANNOTATION_CLASS_CONSTRUCTOR_CALL(), "Annotation class cannot be instantiated.");
        map.put(FirErrors.INSTANCE.getENUM_CLASS_CONSTRUCTOR_CALL(), "Enum types cannot be instantiated.");
        map.put(FirErrors.INSTANCE.getNOT_AN_ANNOTATION_CLASS(), "Illegal annotation class ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNULLABLE_STRING());
        map.put(FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), "Annotation class cannot have supertypes.");
        map.put(FirErrors.INSTANCE.getILLEGAL_KOTLIN_VERSION_STRING_VALUE(), "Invalid value in version annotation (should be 'major.minor' or 'major.minor.patch').");
        map.put(FirErrors.INSTANCE.getNEWER_VERSION_IN_SINCE_KOTLIN(), "The version is greater than the specified API version {0}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNULLABLE_STRING());
        map.put(FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS(), "Version values in 'DeprecatedSinceKotlin' annotation, if specified, must be such that 'warningSince' <= 'errorSince' <= 'hiddenSince'.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS(), "'DeprecatedSinceKotlin' annotation should have at least one argument.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), "'DeprecatedSinceKotlin' annotation can be used only together with a 'Deprecated' annotation.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), "'DeprecatedSinceKotlin' annotation can be used only with an unspecified deprecation level in the 'Deprecated' annotation.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), "'DeprecatedSinceKotlin' annotation cannot be used outside 'kotlin' subpackages.");
        map.put(FirErrors.INSTANCE.getOVERRIDE_DEPRECATION(), "This declaration overrides a deprecated member but is not marked as deprecated itself. Please add the ''@Deprecated'' annotation or suppress the diagnostic.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getEMPTY(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getEMPTY());
        map.put(FirErrors.INSTANCE.getREDUNDANT_ANNOTATION(), "Annotation ''{0}'' is redundant.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID());
        map.put(FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), "Annotations on superclasses are meaningless.");
        map.put(FirErrors.INSTANCE.getRESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION(), "Expression annotations with retention other than SOURCE are prohibited.");
        map.put(FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), "This annotation is not applicable to target ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY(), "''@{0}:'' annotations can only be applied to property declarations.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY_WARNING(), "''@{0}:'' annotations can only be applied to property declarations. It will be an error in a future release. See https://youtrack.jetbrains.com/issue/KT-15470.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), "''@{0}:'' annotations can only be applied to mutable properties.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), "'@delegate:' annotations can only be applied to delegated properties.");
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), "'@field:' annotations can only be applied to properties with backing fields.");
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), "'@param:' annotations can only be applied to primary constructor parameters.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), "Redundant annotation target ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), "'@file:' annotations can only be applied before package declaration.");
        map.put(FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), "This annotation is not applicable to target ''{0}'' and use-site target ''@{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getREPEATED_ANNOTATION(), "This annotation is not repeatable.");
        map.put(FirErrors.INSTANCE.getREPEATED_ANNOTATION_WARNING(), "This annotation is not repeatable.");
        map.put(FirErrors.INSTANCE.getNON_INTERNAL_PUBLISHED_API(), "'@PublishedApi' annotation is only applicable to internal declaration.");
        map.put(FirErrors.INSTANCE.getVOLATILE_ON_VALUE(), "'@Volatile' annotation cannot be used on immutable properties.");
        map.put(FirErrors.INSTANCE.getVOLATILE_ON_DELEGATE(), "'@Volatile' annotation cannot be used on delegated properties.");
        map.put(FirErrors.INSTANCE.getNON_SOURCE_ANNOTATION_ON_INLINED_LAMBDA_EXPRESSION(), "The lambda expression here is an inlined argument, so this annotation cannot be stored anywhere.");
        map.put(FirErrors.INSTANCE.getPOTENTIALLY_NON_REPORTED_ANNOTATION(), "Deprecations and opt-ins on a method overridden from 'Any' may not be reported.");
        map.put(FirErrors.INSTANCE.getOPT_IN_USAGE(), "{1}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPT_IN_USAGE_ERROR(), "{1}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPT_IN_OVERRIDE(), "{1}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPT_IN_OVERRIDE_ERROR(), "{1}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPT_IN_IS_NOT_ENABLED(), "This annotation should be used with the compiler argument '-opt-in=kotlin.RequiresOptIn'.");
        map.put(FirErrors.INSTANCE.getOPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION(), "This class can only be used as an annotation.");
        map.put(FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), "This class can only be used as an annotation or as an argument to '@OptIn'.");
        map.put(FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), "'@OptIn' without any arguments has no effect.");
        map.put(FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER(), "Annotation ''{0}'' is not annotated with ''@RequiresOptIn''. ''@OptIn'' has no effect.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID());
        map.put(FirErrors.INSTANCE.getOPT_IN_MARKER_WITH_WRONG_TARGET(), "Opt-in requirement marker annotation cannot be used on the following code elements: {0}. Please remove these targets.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPT_IN_MARKER_WITH_WRONG_RETENTION(), "Opt-in requirement marker annotation cannot be used with SOURCE retention. Please replace retention with BINARY.");
        map.put(FirErrors.INSTANCE.getOPT_IN_MARKER_ON_WRONG_TARGET(), "Opt-in requirement marker annotation cannot be used on {0}.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPT_IN_MARKER_ON_OVERRIDE(), "Opt-in requirement marker annotation on override requires the same marker on base declaration.");
        map.put(FirErrors.INSTANCE.getOPT_IN_MARKER_ON_OVERRIDE_WARNING(), "Opt-in requirement marker annotation on override. It's recommended to add the same annotation to the base declaration.");
        map.put(FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), "''@SubclassOptInRequired'' is not applicable to ''{0}''.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getSUBCLASS_OPT_ARGUMENT_IS_NOT_MARKER(), "Annotation ''{0}'' is not annotated with ''@RequiresOptIn''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID());
        map.put(FirErrors.INSTANCE.getNOT_A_CLASS(), "Not a class.");
        map.put(FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), "'@ExtensionFunctionType' is prohibited on a function type without parameters or on a non-function type.");
        map.put(FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE_WARNING(), "'@ExtensionFunctionType' makes no sense on a non-function type. It will be an error in a future release. See https://youtrack.jetbrains.com/issue/KT-43527.");
        map.put(FirErrors.INSTANCE.getANNOTATION_IN_WHERE_CLAUSE_ERROR(), "Type parameter annotations are prohibited inside 'where' clauses. You should probably move the annotations to the type parameter declaration.");
        map.put(FirErrors.INSTANCE.getCOMPILER_REQUIRED_ANNOTATION_AMBIGUITY(), "Resolution of the annotation type is ambiguous between ''{1}'' and the compiler-required annotation ''{0}''. Please specify a fully qualified annotation name.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_ANNOTATION_ARGUMENT(), "Resolution of the annotation argument is ambiguous between the following candidates:{0}\nPlease use a fully qualified name as argument.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), "Typealias ''{0}'' exposes ''{2}'' in expanded type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), "Function ''{0}'' exposes its ''{2}'' return type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), "Member ''{0}'' exposes its ''{2}'' receiver type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), "Property ''{0}'' exposes its ''{2}'' type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), "Property ''{0}'' exposes its ''{2}'' type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), "Function ''{0}'' exposes its ''{2}'' parameter type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE(), "Sub-interface ''{0}'' exposes its ''{2}'' supertype ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), "Subclass ''{0}'' exposes its ''{2}'' supertype ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), "Generic ''{0}'' exposes its ''{2}'' parameter bound type ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND_DEPRECATION_WARNING(), "Generic ''{0}'' exposes its ''{2}'' parameter bound type ''{1}''. This will be prohibited in the future.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_INFIX_MODIFIER(), "'infix' modifier is inapplicable to this function.");
        map.put(FirErrors.INSTANCE.getREPEATED_MODIFIER(), "Repeated ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), "Modifier ''{0}'' is redundant in presence of ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDEPRECATED_MODIFIER(), "Modifier ''{0}'' is deprecated; use ''{1}'' instead.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), "Modifier ''{0}'' is deprecated in presence of ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDEPRECATED_MODIFIER_FOR_TARGET(), "Modifier ''{0}'' is deprecated for ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getREDUNDANT_MODIFIER_FOR_TARGET(), "Modifier ''{0}'' is redundant for ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE(), "Visibility must be specified in explicit API mode.");
        map.put(FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE(), "Return type must be specified in explicit API mode.");
        map.put(FirErrors.INSTANCE.getNO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING(), "Visibility must be specified in explicit API mode.");
        map.put(FirErrors.INSTANCE.getNO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING(), "Return type must be specified in explicit API mode.");
        map.put(FirErrors.INSTANCE.getANONYMOUS_SUSPEND_FUNCTION(), "Anonymous suspend functions are prohibited.");
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), "Modifier ''{0}'' is incompatible with ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getREDUNDANT_OPEN_IN_INTERFACE(), "Modifier 'open' is redundant for abstract interface members.");
        map.put(FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), "Modifier ''{0}'' is not applicable to ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPERATOR_MODIFIER_REQUIRED(), "''operator'' modifier is required on ''{0}'' in ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getOPERATOR_CALL_ON_CONSTRUCTOR(), "Constructor of ''{0}'' cannot be used as an operator.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getINFIX_MODIFIER_REQUIRED(), "''infix'' modifier is required on ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getWRONG_MODIFIER_CONTAINING_DECLARATION(), "Modifier ''{0}'' is not applicable inside ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getDEPRECATED_MODIFIER_CONTAINING_DECLARATION(), "Modifier ''{0}'' is deprecated inside ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), "''operator'' modifier is not applicable to function: {0}.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getSUPERTYPE_NOT_INITIALIZED(), "This type has a constructor, so it must be initialized here.");
        map.put(FirErrors.INSTANCE.getNONE_APPLICABLE(), "None of the following candidates is applicable:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_CANDIDATE(), "Inapplicable candidate(s): {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), "''lateinit'' modifier {0}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVARARG_OUTSIDE_PARENTHESES(), "Passing value as a vararg is allowed only inside a parenthesized argument list.");
        map.put(FirErrors.INSTANCE.getNAMED_ARGUMENTS_NOT_ALLOWED(), "Named arguments are prohibited for {0}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNON_VARARG_SPREAD(), "The spread operator (*foo) can only be applied in a vararg position.");
        map.put(FirErrors.INSTANCE.getTOO_MANY_ARGUMENTS(), "Too many arguments for ''{0}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getARGUMENT_PASSED_TWICE(), "Argument already passed for this parameter.");
        map.put(FirErrors.INSTANCE.getNO_VALUE_FOR_PARAMETER(), "No value passed for parameter ''{0}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getNAMED_PARAMETER_NOT_FOUND(), "No parameter with name ''{0}'' found.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNAME_FOR_AMBIGUOUS_PARAMETER(), "Named argument is prohibited for parameter with an ambiguous name.");
        map.put(FirErrors.INSTANCE.getMANY_LAMBDA_EXPRESSION_ARGUMENTS(), "Only one lambda expression is allowed outside a parenthesized argument list.");
        map.put(FirErrors.INSTANCE.getNEW_INFERENCE_NO_INFORMATION_FOR_PARAMETER(), "Not enough information to infer type argument for ''{0}''.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getSPREAD_OF_NULLABLE(), "The spread operator (*foo) cannot be applied to an argument of nullable type.");
        map.put(FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION(), "Assigning single elements to varargs in named form is prohibited.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION(), "Assigning single elements to varargs in named form is prohibited.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION(), "Redundant spread (*) operator.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION(), "Redundant spread (*) operator.");
        map.put(FirErrors.INSTANCE.getINFERENCE_UNSUCCESSFUL_FORK(), "Unsuccessful inference fork at position ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE(), "Nested {0} accessed via instance reference", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_NAME_QUOTED());
        map.put(FirErrors.INSTANCE.getINFERRED_TYPE_VARIABLE_INTO_EMPTY_INTERSECTION(), "Type argument for type parameter ''{0}'' cannot be inferred because it has incompatible upper bounds: {1} ({2}{3}).", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_COLLECTION_OF_TYPES(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getINFERRED_TYPE_VARIABLE_INTO_POSSIBLE_EMPTY_INTERSECTION(), "Type argument for type parameter ''{0}'' has possible incompatible upper bounds: {1} ({2}{3}).", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_COLLECTION_OF_TYPES(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNULLABLE_ON_DEFINITELY_NOT_NULLABLE(), "'!!' type cannot be marked as nullable.");
        map.put(FirErrors.INSTANCE.getINCORRECT_LEFT_COMPONENT_OF_INTERSECTION(), "Intersection types are supported only for definitely non-nullable types: left part should be a type parameter with nullable bounds.");
        map.put(FirErrors.INSTANCE.getINCORRECT_RIGHT_COMPONENT_OF_INTERSECTION(), "Intersection types are supported only for definitely non-nullable types: right part should be non-nullable 'Any'.");
        map.put(FirErrors.INSTANCE.getTYPE_MISMATCH(), "Type mismatch: inferred type is ''{1}'', but ''{0}'' was expected.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getTYPE_INFERENCE_ONLY_INPUT_TYPES_ERROR(), "Type inference failed. The value of the type parameter ''{0}'' should be mentioned in input types (argument types, receiver type, or expected type). Try to specify it explicitly.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getTHROWABLE_TYPE_MISMATCH(), "Throwable type mismatch: actual type is ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getCONDITION_TYPE_MISMATCH(), "Condition type mismatch: inferred type is ''{0}'' but ''Boolean'' was expected.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getARGUMENT_TYPE_MISMATCH(), "Argument type mismatch: actual type is ''{1}'', but ''{0}'' was expected.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getASSIGNMENT_TYPE_MISMATCH(), "Assignment type mismatch: actual type is ''{1}'', but ''{0}'' was expected.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getRESULT_TYPE_MISMATCH(), "Function return type mismatch: actual type is ''{1}'', but ''{0}'' was expected.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getITERATOR_MISSING(), "For-loop range must have an 'iterator()' method.");
        map.put(FirErrors.INSTANCE.getITERATOR_ON_NULLABLE(), "Non-nullable value required to call an 'iterator()' method in a for-loop.");
        map.put(FirErrors.INSTANCE.getITERATOR_AMBIGUITY(), "Method ''iterator()'' is ambiguous for this expression. Applicable candidates:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getNEXT_MISSING(), "Method 'next()' cannot be called on 'iterator()'.");
        map.put(FirErrors.INSTANCE.getNEXT_AMBIGUITY(), "Method ''next()'' is ambiguous for this expression. Applicable candidates:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_FUNCTION_TYPE_KIND(), "Multiple function type conversions are prohibited for a single type. Detected type conversions: {0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getFUNCTIONAL_TYPE_KINDS());
        map.put(FirErrors.INSTANCE.getNEXT_NONE_APPLICABLE(), "None of the ''next()'' functions is applicable for this expression. Candidates are:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED(), "Experimental context receivers are deprecated and will be superseded by context parameters. Please don't use context receivers. You can either pass parameters explicitly or use members with extensions.\n\nSee new context parameters proposal: https://github.com/Kotlin/KEEP/blob/context-parameters/proposals/context-parameters.md. During the transition period, neither context receivers nor context parameters will be supported. This warning will become an error in future releases.");
        map.put(FirErrors.INSTANCE.getNO_CONTEXT_RECEIVER(), "No context receiver for ''{0}'' found.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getMULTIPLE_ARGUMENTS_APPLICABLE_FOR_CONTEXT_RECEIVER(), "Multiple arguments applicable to context receiver ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_CALL_WITH_IMPLICIT_CONTEXT_RECEIVER(), "With implicit context receivers, the call is ambiguous. Please specify the receiver explicitly.");
        map.put(FirErrors.INSTANCE.getUNSUPPORTED_CONTEXTUAL_DECLARATION_CALL(), "To use contextual declarations, specify the '-Xcontext-receivers' compiler option.");
        map.put(FirErrors.INSTANCE.getSUBTYPING_BETWEEN_CONTEXT_RECEIVERS(), "Subtyping relation between context receivers is prohibited.");
        map.put(FirErrors.INSTANCE.getCONTEXT_RECEIVERS_WITH_BACKING_FIELD(), "Property with context receivers cannot be initialized because it has no backing field.");
        map.put(FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), "Self references to members of containing class are prohibited in constructor of nested object.");
        map.put(FirErrors.INSTANCE.getOVERLOAD_RESOLUTION_AMBIGUITY(), "Overload resolution ambiguity between candidates:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getASSIGN_OPERATOR_AMBIGUITY(), "Ambiguity between assign operator candidates:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getHAS_NEXT_MISSING(), "'hasNext()' cannot be called on 'iterator()'.");
        map.put(FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_AMBIGUITY(), "Method ''hasNext()'' is ambiguous for this expression. Applicable candidates:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_NONE_APPLICABLE(), "None of the ''hasNext()'' functions is applicable for this expression. Candidates are:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getUNRESOLVED_REFERENCE_WRONG_RECEIVER(), "Unresolved reference. None of the following candidates is applicable because of a receiver type mismatch:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getRECURSION_IN_IMPLICIT_TYPES(), "Recursion in implicit types.");
        map.put(FirErrors.INSTANCE.getINFERENCE_ERROR(), "Inference error.");
        map.put(FirErrors.INSTANCE.getILLEGAL_PROJECTION_USAGE(), "Illegal projection usage.");
        map.put(FirErrors.INSTANCE.getPROJECTION_ON_NON_CLASS_TYPE_ARGUMENT(), "Projections are not allowed on type arguments of functions calls.");
        map.put(FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED(), "Type argument is not within its bounds: should be subtype of ''{0}''.{2}", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getOPTIONAL_SENTENCE());
        map.put(FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION(), "Type argument is not within its bounds: should be subtype of ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED(), "Type arguments are not allowed {0}.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getTYPE_ARGUMENTS_FOR_OUTER_CLASS_WHEN_NESTED_REFERENCED(), "Type arguments for outer class are redundant when nested class is referenced");
        String wrongNumberOfTypeArguments = "{0,choice,0#No type arguments|1#One type argument|1<{0,number,integer} type arguments} expected";
        map.put(FirErrors.INSTANCE.getWRONG_NUMBER_OF_TYPE_ARGUMENTS(), wrongNumberOfTypeArguments + " for {1}.", null, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_NAME_QUOTED());
        map.put(FirErrors.INSTANCE.getNO_TYPE_ARGUMENTS_ON_RHS(), wrongNumberOfTypeArguments + ". Use {1} if you don''t intend to pass type arguments.", null, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_NAME_QUOTED());
        map.put(FirErrors.INSTANCE.getOUTER_CLASS_ARGUMENTS_REQUIRED(), "Type arguments should be specified for outer {0}. Use the full class name to specify them.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_NAME_QUOTED());
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_OBJECT(), "Type parameters are prohibited for objects.");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ANONYMOUS_OBJECT(), "Type parameters for anonymous objects are deprecated.");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETERS_IN_ENUM(), "Enum class cannot have type parameters.");
        map.put(FirErrors.INSTANCE.getCONFLICTING_PROJECTION(), "Projection is conflicting with variance of the corresponding type parameter of ''{0}''. Remove the projection or replace it with ''*''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getCONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION(), "Conflicting projection in type alias expansion in intermediate type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getREDUNDANT_PROJECTION(), "Projection is redundant: the corresponding type parameter of ''{0}'' has the same variance.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getVARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED(), "Variance annotations are only allowed for type parameters of classes and interfaces.");
        map.put(FirErrors.INSTANCE.getCATCH_PARAMETER_WITH_DEFAULT_VALUE(), "Catch clause parameter cannot have a default value.");
        map.put(FirErrors.INSTANCE.getREIFIED_TYPE_IN_CATCH_CLAUSE(), "Reified type is prohibited for catch parameter.");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_IN_CATCH_CLAUSE(), "Type parameter is prohibited for catch parameter.");
        map.put(FirErrors.INSTANCE.getKCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE(), "Declaration has an inconsistent return type. Please add upper bound ''Any'' for type parameter ''{0}'' or specify return type explicitly.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), "Cannot use ''{0}'' as reified type parameter. Use a class instead.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), "Cannot use ''{0}'' as reified type parameter, since the array type parameter is not reified.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), "Cannot use ''{0}'' as reified type parameter.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getDEFINITELY_NON_NULLABLE_AS_REIFIED(), "Cannot use definitely-non-nullable type as a reified type argument.");
        map.put(FirErrors.INSTANCE.getFINAL_UPPER_BOUND(), "Type ''{0}'' is final, so the value of the type parameter is predetermined.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE(), "Extension function type cannot be used as an upper bound.");
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_TYPES(), "Incompatible types ''{0}'' and ''{1}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_TYPES_WARNING(), "Potentially incompatible types ''{0}'' and ''{1}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getSMARTCAST_IMPOSSIBLE(), "Smart cast to ''{0}'' is impossible, because ''{1}'' is a {2}.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getCALLEE_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getSMARTCAST_IMPOSSIBLE_ON_IMPLICIT_INVOKE_RECEIVER(), "Smart cast to ''{0}'' is impossible, because ''{1}'' is a {2}. Use explicit ''?.invoke'' to make a function-like call instead.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getCALLEE_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getDEPRECATED_SMARTCAST_ON_DELEGATED_PROPERTY(), "Smart cast to ''{0}'' is impossible, because ''{1}'' is a property inherited by class delegation. This warning will become an error in future releases. See https://youtrack.jetbrains.com/issue/KT-57417.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_ERROR(), "Type parameter ''{0}'' is declared as ''{1}'' but occurs in ''{2}'' position in type ''{3}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)CommonRenderers.RENDER_POSITION_VARIANCE, (DiagnosticParameterRenderer)CommonRenderers.RENDER_POSITION_VARIANCE, FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE(), "Type parameter ''{0}'' is declared as ''{1}'' but occurs in ''{2}'' position in abbreviated type ''{3}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)CommonRenderers.RENDER_POSITION_VARIANCE, (DiagnosticParameterRenderer)CommonRenderers.RENDER_POSITION_VARIANCE, FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getBOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER(), "Type parameter cannot have any other bounds if it's bounded by another type parameter.");
        map.put(FirErrors.INSTANCE.getONLY_ONE_CLASS_BOUND_ALLOWED(), "Only one of the upper bounds can be a class.");
        map.put(FirErrors.INSTANCE.getREPEATED_BOUND(), "Type parameter already has this bound.");
        map.put(FirErrors.INSTANCE.getCONFLICTING_UPPER_BOUNDS(), "Upper bounds of ''{0}'' have an empty intersection.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER(), "''{0}'' does not refer to a type parameter of ''{1}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getBOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED(), "Bounds on type alias parameters are prohibited.");
        map.put(FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_NO_INLINE(), "Only type parameters of inline functions can be reified.");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), "Type parameters are prohibited here.");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER(), "Type parameter of a property must be used in its receiver type.");
        map.put(FirErrors.INSTANCE.getNO_RETURN_IN_FUNCTION_WITH_BLOCK_BODY(), "Missing return statement.");
        map.put(FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH(), "Return type mismatch: expected ''{0}'', actual ''{1}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getIMPLICIT_NOTHING_RETURN_TYPE(), "Return type 'Nothing' needs to be specified explicitly.");
        map.put(FirErrors.INSTANCE.getIMPLICIT_NOTHING_PROPERTY_TYPE(), "Property type 'Nothing' needs to be specified explicitly.");
        map.put(FirErrors.INSTANCE.getABBREVIATED_NOTHING_RETURN_TYPE(), "'Nothing' return type can't be specified with type alias.");
        map.put(FirErrors.INSTANCE.getABBREVIATED_NOTHING_PROPERTY_TYPE(), "'Nothing' property type can't be specified with type alias.");
        map.put(FirErrors.INSTANCE.getCYCLIC_GENERIC_UPPER_BOUND(), "Type parameter has cyclic upper bounds.");
        map.put(FirErrors.INSTANCE.getFINITE_BOUNDS_VIOLATION(), "This type parameter violates the Finite Bound Restriction.");
        map.put(FirErrors.INSTANCE.getFINITE_BOUNDS_VIOLATION_IN_JAVA(), "Violation of Finite Bound Restriction for {0}.", CommonRenderers.commaSeparated((DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME()));
        map.put(FirErrors.INSTANCE.getEXPANSIVE_INHERITANCE(), "This type parameter violates the Non-Expansive Inheritance Restriction.");
        map.put(FirErrors.INSTANCE.getEXPANSIVE_INHERITANCE_IN_JAVA(), "Violation of Non-Expansive Inheritance Restriction for {0}.", CommonRenderers.commaSeparated((DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME()));
        map.put(FirErrors.INSTANCE.getDEPRECATED_TYPE_PARAMETER_SYNTAX(), "Type parameters must be placed before function name.");
        map.put(FirErrors.INSTANCE.getMISPLACED_TYPE_PARAMETER_CONSTRAINTS(), "If a type parameter has multiple constraints, they all need to be placed in the 'where' clause.");
        map.put(FirErrors.INSTANCE.getDYNAMIC_SUPERTYPE(), "Supertypes cannot be dynamic.");
        map.put(FirErrors.INSTANCE.getDYNAMIC_UPPER_BOUND(), "Dynamic type cannot be used as an upper bound.");
        map.put(FirErrors.INSTANCE.getDYNAMIC_RECEIVER_NOT_ALLOWED(), "Dynamic receivers are prohibited.");
        map.put(FirErrors.INSTANCE.getDYNAMIC_RECEIVER_EXPECTED_BUT_WAS_NON_DYNAMIC(), "Calling functions expecting the ''dynamic'' receiver over a non-''dynamic'' one such as ''{0}'' is prohibited.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getEXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED(), "''{0}'' is a member and an extension at the same time. References to such elements are prohibited.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getCALLABLE_REFERENCE_LHS_NOT_A_CLASS(), "Left-hand side of callable reference cannot be a type parameter.");
        map.put(FirErrors.INSTANCE.getCALLABLE_REFERENCE_TO_ANNOTATION_CONSTRUCTOR(), "Annotation class cannot be instantiated.");
        map.put(FirErrors.INSTANCE.getADAPTED_CALLABLE_REFERENCE_AGAINST_REFLECTION_TYPE(), "Adapted callable reference cannot be resolved against reflective types.");
        map.put(FirErrors.INSTANCE.getCLASS_LITERAL_LHS_NOT_A_CLASS(), "Only classes are allowed on the left-hand side of a class literal.");
        map.put(FirErrors.INSTANCE.getNULLABLE_TYPE_IN_CLASS_LITERAL_LHS(), "Type in a class literal must not be nullable.");
        map.put(FirErrors.INSTANCE.getEXPRESSION_OF_NULLABLE_TYPE_IN_CLASS_LITERAL_LHS(), "Expression in class literal has nullable type ''{0}''. Use ''!!'' to make the type non-nullable.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUNSUPPORTED_CLASS_LITERALS_WITH_EMPTY_LHS(), "Class literals with empty left hand side are unsupported.");
        map.put(FirErrors.INSTANCE.getMUTABLE_PROPERTY_WITH_CAPTURED_TYPE(), "Captured type in mutable property reference. Usages of 'set' may lead to cast exceptions.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_NOT_TOP_LEVEL(), "Value class cannot be local or inner.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_NOT_FINAL(), "Value class can be only final.");
        map.put(FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS(), "Primary constructor is required for value classes.");
        map.put(FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), "Inline class must have exactly one primary constructor parameter.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_EMPTY_CONSTRUCTOR(), "Value class must have at least one primary constructor parameter.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), "Value class primary constructor must only have final read-only ('val') property parameters.");
        map.put(FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_VALUE_CLASS(), "Value class cannot have properties with backing fields.");
        map.put(FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_VALUE_CLASS(), "Value class cannot have delegated properties.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), "Value class cannot have value parameter of type ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), "Value class cannot implement an interface by delegation.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_EXTEND_CLASSES(), "Value class cannot extend classes.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_RECURSIVE(), "Value class cannot be recursive.");
        map.put(FirErrors.INSTANCE.getMULTI_FIELD_VALUE_CLASS_PRIMARY_CONSTRUCTOR_DEFAULT_PARAMETER(), "Default parameters are not supported in the primary constructor of a multi-field value class.");
        map.put(FirErrors.INSTANCE.getINVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE(), "Invalid default value for inline function parameter. Only lambdas, anonymous functions, and callable references are supported.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getNOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE(), "Usage of inline parameter ''{0}'' in default value of inline parameter is not supported.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_VALUE_CLASS(), "Secondary constructors with bodies are reserved for future releases.");
        map.put(FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_VALUE_CLASS(), "Member name ''{0}'' is reserved for future releases.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getRESERVED_MEMBER_FROM_INTERFACE_INSIDE_VALUE_CLASS(), "Member name ''{1}'' is reserved for future releases but is implemented in supertype ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getTYPE_ARGUMENT_ON_TYPED_VALUE_CLASS_EQUALS(), "Type arguments for typed value class equals must all be star projections.");
        map.put(FirErrors.INSTANCE.getINNER_CLASS_INSIDE_VALUE_CLASS(), "Value class cannot have inner classes.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), "Value class cannot be 'Cloneable'.");
        map.put(FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS(), "Value classes cannot have context receivers.");
        map.put(FirErrors.INSTANCE.getANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET(), "Annotations on {0} of multi-field value class type are not supported.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED(), "'inline' modifier on virtual members is prohibited. Only private or final members can be inlined.");
        map.put(FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED_DEPRECATION(), "'inline' modifier on virtual members is prohibited. Only private or final members can be inlined.");
        map.put(FirErrors.INSTANCE.getOVERRIDE_BY_INLINE(), "Override by an inline function.");
        map.put(FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_IN_OVERRIDE(), "Override by a function with reified type parameter.");
        map.put(FirErrors.INSTANCE.getINLINE_PROPERTY_WITH_BACKING_FIELD(), "Inline property cannot have a backing field.");
        map.put(FirErrors.INSTANCE.getINLINE_PROPERTY_WITH_BACKING_FIELD_DEPRECATION(), "Inline property cannot have a backing field.");
        map.put(FirErrors.INSTANCE.getNOTHING_TO_OVERRIDE(), "''{0}'' overrides nothing.{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)DiagnosticParameterRendererKt.Renderer(FirErrorsDefaultMessages::MAP$lambda$2$lambda$0));
        map.put(FirErrors.INSTANCE.getCANNOT_OVERRIDE_INVISIBLE_MEMBER(), "{0} has no access to {1}, so it cannot override it.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        String multipleDefaultsMessage = "More than one function overridden by ''{0}'' declares a default value for ''{1}'': {2}";
        String multipleDefaultsNotAllowed = "As the compiler can not make sure these values agree, this is not allowed.";
        map.put(FirErrors.INSTANCE.getMULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES(), multipleDefaultsMessage + multipleDefaultsNotAllowed, (DiagnosticParameterRenderer)CommonRenderers.NAME, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getCALLABLES_FQ_NAMES());
        map.put(FirErrors.INSTANCE.getMULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE(), multipleDefaultsMessage + multipleDefaultsNotAllowed, (DiagnosticParameterRenderer)CommonRenderers.NAME, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getCALLABLES_FQ_NAMES());
        String multipleDefaultsDiscouraged = "As the compiler can not make sure these values agree, this will be prohibited in the future. See: https://youtrack.jetbrains.com/issue/KT-36188";
        map.put(FirErrors.INSTANCE.getMULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_DEPRECATION(), multipleDefaultsMessage + multipleDefaultsDiscouraged, (DiagnosticParameterRenderer)CommonRenderers.NAME, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getCALLABLES_FQ_NAMES());
        map.put(FirErrors.INSTANCE.getMULTIPLE_DEFAULTS_INHERITED_FROM_SUPERTYPES_WHEN_NO_EXPLICIT_OVERRIDE_DEPRECATION(), multipleDefaultsMessage + multipleDefaultsDiscouraged, (DiagnosticParameterRenderer)CommonRenderers.NAME, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getCALLABLES_FQ_NAMES());
        map.put(FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), "Type alias expanded to malformed type ''{0}''", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER(), "''{0}'' in ''{1}'' is final and cannot be overridden.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE(), "Cannot weaken access privilege {0} for ''{1}'' in ''{2}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getVISIBILITY(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCANNOT_WEAKEN_ACCESS_PRIVILEGE_WARNING(), "Cannot weaken access privilege {0} for ''{1}'' in ''{2}''. This will be prohibited in the future.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getVISIBILITY(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE(), "Cannot change access privilege {0} for ''{1}'' in ''{2}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getVISIBILITY(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCANNOT_CHANGE_ACCESS_PRIVILEGE_WARNING(), "Cannot change access privilege {0} for ''{1}'' in ''{2}''. This will be prohibited in the future.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getVISIBILITY(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY(), "Cannot infer visibility for ''{0}''. Please specify it explicitly.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getCANNOT_INFER_VISIBILITY_WARNING(), "Cannot infer visibility for ''{0}''. Please specify it explicitly. This will be prohibited in the future.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getABSTRACT_MEMBER_NOT_IMPLEMENTED(), "{0} is not abstract and does not implement abstract member ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_QUOTED(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getABSTRACT_MEMBER_NOT_IMPLEMENTED_BY_ENUM_ENTRY(), "{0} does not implement abstract members:{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_ENUM_ENTRY_QUOTED(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED(), "{0} is not abstract and does not implement abstract base class member ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_QUOTED(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getINVISIBLE_ABSTRACT_MEMBER_FROM_SUPER(), "''{0}'' inherits invisible abstract member {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_ANONYMOUS_TYPE_INFERRED(), "Right-hand side has an anonymous type. Please specify the type explicitly.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getMANY_IMPL_MEMBER_NOT_IMPLEMENTED(), "{0} must override ''{1}'' because it inherits multiple implementations for it.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_QUOTED(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getMANY_INTERFACES_MEMBER_NOT_IMPLEMENTED(), "{0} must override ''{1}'' because it inherits multiple interface methods for it.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_QUOTED(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_OVERRIDE(), "Return type of ''{0}'' is not a subtype of the return type of the overridden member {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_OVERRIDE(), "Type of ''{0}'' is not a subtype of overridden property {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_OVERRIDE(), "Type of ''{0}'' doesn''t match the type of the overridden ''var'' property {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL(), "''var'' property {0} cannot be overridden by ''val'' property ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getVAR_IMPLEMENTED_BY_INHERITED_VAL(), "{0} overrides ''var'' property {1} with inherited ''val'' property {2}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getRENDER_CLASS_OR_OBJECT_QUOTED(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_FINAL_CLASS(), "'open' has no effect on a final class.");
        map.put(FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_OBJECT(), "'open' has no effect on object.");
        map.put(FirErrors.INSTANCE.getVIRTUAL_MEMBER_HIDDEN(), "''{0}'' hides member of supertype ''{1}'' and needs an ''override'' modifier.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_CONFLICT(), "Function ''{0}'' generated for the data class conflicts with the supertype member {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getDATA_CLASS_OVERRIDE_DEFAULT_VALUES(), "Generated function ''{0}'' of the data class has default values for parameters which conflicts with the overriden member of supertype ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getGENERIC_THROWABLE_SUBCLASS(), "Subclass of 'Throwable' cannot have type parameters.");
        map.put(FirErrors.INSTANCE.getINNER_CLASS_OF_GENERIC_THROWABLE_SUBCLASS(), "Inner class of generic class extending 'Throwable' is prohibited.");
        map.put(FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_ON_INHERITANCE(), "{0} clashes with {1}: return types are incompatible.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_ON_INHERITANCE(), "{0} clashes with {1}: property types are incompatible.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getVAR_TYPE_MISMATCH_ON_INHERITANCE(), "{0} clashes with {1}: property types do not match.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getRETURN_TYPE_MISMATCH_BY_DELEGATION(), "{0} clashes with {1} from delegation: return types are incompatible.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getPROPERTY_TYPE_MISMATCH_BY_DELEGATION(), "{0} clashes with {1} from delegation: property types are incompatible.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER_BY_DELEGATION(), "{0} implicitly overrides a final member {1} by delegation.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getVAR_OVERRIDDEN_BY_VAL_BY_DELEGATION(), "''val'' property {0} implicitly overrides a ''var'' property {1} by delegation.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION());
        map.put(FirErrors.INSTANCE.getCONFLICTING_INHERITED_MEMBERS(), "''{0}'' inherits conflicting members: {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), CommonRenderers.commaSeparated((DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_WITH_CONTAINING_DECLARATION()));
        map.put(FirErrors.INSTANCE.getINLINE_CLASS_DEPRECATED(), "'inline' modifier is deprecated. Use 'value' instead.");
        map.put(FirErrors.INSTANCE.getMANY_COMPANION_OBJECTS(), "Only one companion object is allowed per class.");
        map.put(FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), "Conflicting overloads:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getREDECLARATION(), "Conflicting declarations:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getCLASSIFIER_REDECLARATION(), "Redeclaration:{0}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getPACKAGE_CONFLICTS_WITH_CLASSIFIER(), "Package conflicts with classifier {0}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID());
        map.put(FirErrors.INSTANCE.getEXPECT_AND_ACTUAL_IN_THE_SAME_MODULE(), "{0}: expect and corresponding actual are declared in the same module", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getMETHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE(), "Interfaces cannot implement a method of 'Any'.");
        map.put(FirErrors.INSTANCE.getLOCAL_OBJECT_NOT_ALLOWED(), "Named object ''{0}'' cannot be local. Try to use an anonymous object instead.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getLOCAL_INTERFACE_NOT_ALLOWED(), "Interface ''{0}'' cannot be local. Try to use an anonymous object or abstract class instead.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS(), "Abstract function ''{0}'' in non-abstract class ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getABSTRACT_FUNCTION_WITH_BODY(), "Function ''{0}'' with a body cannot be abstract.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getNON_ABSTRACT_FUNCTION_WITH_NO_BODY(), "Function ''{0}'' without a body must be abstract.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getPRIVATE_FUNCTION_WITH_NO_BODY(), "Function ''{0}'' without a body cannot be private.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getNON_MEMBER_FUNCTION_NO_BODY(), "Function ''{0}'' must have a body.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getFUNCTION_DECLARATION_WITH_NO_NAME(), "Function declaration must have a name.");
        map.put(FirErrors.INSTANCE.getANONYMOUS_FUNCTION_WITH_NAME(), "Anonymous functions with names are prohibited.");
        map.put(FirErrors.INSTANCE.getSINGLE_ANONYMOUS_FUNCTION_WITH_NAME(), "Anonymous functions with names are prohibited.");
        map.put(FirErrors.INSTANCE.getANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE(), "Anonymous functions cannot specify default values for their parameters.");
        map.put(FirErrors.INSTANCE.getUSELESS_VARARG_ON_PARAMETER(), "Vararg on this parameter is useless.");
        map.put(FirErrors.INSTANCE.getFUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS(), "Functional interface must have exactly one abstract function.");
        map.put(FirErrors.INSTANCE.getFUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES(), "Functional interface cannot have abstract properties.");
        map.put(FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS(), "Functional interface cannot have an abstract method with type parameters.");
        map.put(FirErrors.INSTANCE.getFUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE(), "Functional interface abstract method cannot have a default value.");
        map.put(FirErrors.INSTANCE.getFUN_INTERFACE_WITH_SUSPEND_FUNCTION(), "Functional interface abstract method cannot have a suspend modifier.");
        map.put(FirErrors.INSTANCE.getMULTIPLE_VARARG_PARAMETERS(), "Multiple vararg parameters are prohibited.");
        map.put(FirErrors.INSTANCE.getFORBIDDEN_VARARG_PARAMETER_TYPE(), "Prohibited vararg parameter type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getVALUE_PARAMETER_WITHOUT_EXPLICIT_TYPE(), "An explicit type is required on a value parameter.");
        map.put(FirErrors.INSTANCE.getCANNOT_INFER_PARAMETER_TYPE(), "Cannot infer type for this parameter. Please specify it explicitly.");
        map.put(FirErrors.INSTANCE.getNO_TAIL_CALLS_FOUND(), "A function is marked as tail-recursive but no tail calls are found.");
        map.put(FirErrors.INSTANCE.getTAILREC_ON_VIRTUAL_MEMBER_ERROR(), "Tailrec is prohibited on open members.");
        map.put(FirErrors.INSTANCE.getNON_TAIL_RECURSIVE_CALL(), "Recursive call is not a tail call.");
        map.put(FirErrors.INSTANCE.getTAIL_RECURSION_IN_TRY_IS_NOT_SUPPORTED(), "Tail recursion optimization inside try/catch/finally is not supported.");
        map.put(FirErrors.INSTANCE.getDATA_OBJECT_CUSTOM_EQUALS_OR_HASH_CODE(), "Data object cannot have a custom implementation of 'equals' or 'hashCode'.");
        map.put(FirErrors.INSTANCE.getDEFAULT_VALUE_NOT_ALLOWED_IN_OVERRIDE(), "An overriding function is not allowed to specify default values for its parameters.");
        map.put(FirErrors.INSTANCE.getFUN_INTERFACE_CONSTRUCTOR_REFERENCE(), "Functional interface constructor references are prohibited.");
        map.put(FirErrors.INSTANCE.getABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS(), "Abstract property ''{0}'' in non-abstract class ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME());
        map.put(FirErrors.INSTANCE.getPRIVATE_PROPERTY_IN_INTERFACE(), "Abstract property in interface cannot be private.");
        map.put(FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_INITIALIZER(), "Property with initializer cannot be abstract.");
        map.put(FirErrors.INSTANCE.getPROPERTY_INITIALIZER_IN_INTERFACE(), "Property initializers in interfaces are prohibited.");
        map.put(FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), "This property must have an explicit type, be initialized, or be delegated.");
        map.put(FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITHOUT_TYPE(), "Abstract property must have an explicit type.");
        map.put(FirErrors.INSTANCE.getLATEINIT_PROPERTY_WITHOUT_TYPE(), "'lateinit' property must have an explicit type.");
        map.put(FirErrors.INSTANCE.getVARIABLE_WITH_NO_TYPE_NO_INITIALIZER(), "This variable must either have an explicit type or be initialized.");
        map.put(FirErrors.INSTANCE.getINITIALIZATION_BEFORE_DECLARATION(), "Variable cannot be initialized before declaration.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getTYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM(), "Type checking has run into a recursive problem. Easiest workaround: specify the types of your declarations explicitly.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED(), "Property must be initialized.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_WARNING(), "Property must be initialized. This warning will become an error in future releases.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL(), "Property must be initialized or be final.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_FINAL_WARNING(), "Property must be initialized or be final. This warning will become an error in future releases.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT(), "Property must be initialized or be abstract.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT_WARNING(), "Property must be initialized or be abstract. This warning will become an error in future releases.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT(), "Property must be initialized, be final, or be abstract.");
        map.put(FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_FINAL_OR_ABSTRACT_WARNING(), "Property must be initialized, be final, or be abstract. This warning will become an error in future releases.");
        map.put(FirErrors.INSTANCE.getEXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT(), "Extension property must have accessors or be abstract.");
        map.put(FirErrors.INSTANCE.getUNNECESSARY_LATEINIT(), "'lateinit' is unnecessary: definitely initialized in constructors.");
        map.put(FirErrors.INSTANCE.getBACKING_FIELD_IN_INTERFACE(), "Property in interface cannot have a backing field.");
        map.put(FirErrors.INSTANCE.getEXTENSION_PROPERTY_WITH_BACKING_FIELD(), "Extension property cannot be initialized because it has no backing field.");
        map.put(FirErrors.INSTANCE.getPROPERTY_INITIALIZER_NO_BACKING_FIELD(), "Initializer is prohibited here because this property has no backing field.");
        map.put(FirErrors.INSTANCE.getABSTRACT_DELEGATED_PROPERTY(), "Delegated property cannot be abstract.");
        map.put(FirErrors.INSTANCE.getDELEGATED_PROPERTY_IN_INTERFACE(), "Delegated properties in interfaces are prohibited.");
        map.put(FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), "Property with getter implementation cannot be abstract.");
        map.put(FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), "Property with setter implementation cannot be abstract.");
        map.put(FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), "Private setters for abstract properties are prohibited.");
        map.put(FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), "Private setters for open properties are prohibited.");
        map.put(FirErrors.INSTANCE.getVAL_WITH_SETTER(), "A 'val' property cannot have a setter.");
        map.put(FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), "Setter parameter type must be equal to the type of the property, i.e. ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getDELEGATE_USES_EXTENSION_PROPERTY_TYPE_PARAMETER(), "Extension property type parameter ''{0}'' cannot be used in delegates. See https://youtrack.jetbrains.com/issue/KT-24643", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getINITIALIZER_TYPE_MISMATCH(), "Initializer type mismatch: expected ''{0}'', actual ''{1}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), "Getter visibility must be the same as property visibility.");
        map.put(FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), "Setter visibility cannot be more permissive than property visibility.");
        map.put(FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), "Setter return type must be 'Unit'.");
        map.put(FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), "Getter return type must be equal to the type of the property, i.e. ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getACCESSOR_FOR_DELEGATED_PROPERTY(), "Delegated property cannot have accessors with non-default implementations.");
        map.put(FirErrors.INSTANCE.getPROPERTY_INITIALIZER_WITH_EXPLICIT_FIELD_DECLARATION(), "Property initializers are prohibited for properties with explicit backing field declaration.");
        map.put(FirErrors.INSTANCE.getPROPERTY_FIELD_DECLARATION_MISSING_INITIALIZER(), "Property backing field declaration must have an initializer.");
        map.put(FirErrors.INSTANCE.getLATEINIT_PROPERTY_FIELD_DECLARATION_WITH_INITIALIZER(), "'lateinit' backing field cannot have an initializer.");
        map.put(FirErrors.INSTANCE.getLATEINIT_FIELD_IN_VAL_PROPERTY(), "Only mutable properties can have a mutable backing field. Consider changing 'val' to 'var'.");
        map.put(FirErrors.INSTANCE.getLATEINIT_NULLABLE_BACKING_FIELD(), "'lateinit' modifier is prohibited on backing fields of a type with nullable upper bound.");
        map.put(FirErrors.INSTANCE.getBACKING_FIELD_FOR_DELEGATED_PROPERTY(), "Delegated properties cannot have explicit backing field declarations.");
        map.put(FirErrors.INSTANCE.getPROPERTY_MUST_HAVE_GETTER(), "This property needs a custom getter, because its type is not a supertype of the backing field's type.");
        map.put(FirErrors.INSTANCE.getPROPERTY_MUST_HAVE_SETTER(), "This property needs a custom setter, because its type is not a subtype of the backing field's type.");
        map.put(FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_INTERFACE(), "Backing fields inside interfaces are prohibited.");
        map.put(FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_ABSTRACT_PROPERTY(), "Abstract property cannot have a backing field.");
        map.put(FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_EXTENSION(), "Extension properties cannot have a backing field.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_BACKING_FIELD(), "Explicit backing field declaration is unnecessary if it has the same type as the property.");
        map.put(FirErrors.INSTANCE.getABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS(), "Property in primary constructor cannot be declared as abstract.");
        map.put(FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS_WARNING(), "Type parameters for local variables are deprecated.");
        map.put(FirErrors.INSTANCE.getLOCAL_VARIABLE_WITH_TYPE_PARAMETERS(), "Local variables cannot have type parameters.");
        map.put(FirErrors.INSTANCE.getEXPLICIT_TYPE_ARGUMENTS_IN_PROPERTY_ACCESS(), "{0} access cannot have explicit type arguments.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getSAFE_CALLABLE_REFERENCE_CALL(), "This syntax is reserved for future releases.");
        map.put(FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LITERAL(), "This declaration can only be called on a property literal (e.g. 'Foo::bar').");
        map.put(FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT(), "This declaration can only be called on a reference to a 'lateinit' property.");
        map.put(FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION(), "This declaration cannot be used inside an inline function.");
        map.put(FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY(), "Backing field of ''{0}'' is not accessible at this point.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getLOCAL_EXTENSION_PROPERTY(), "Local extension properties are prohibited.");
        map.put(FirErrors.INSTANCE.getCONST_VAL_NOT_TOP_LEVEL_OR_OBJECT(), "Const 'val' is only allowed on top level, in named objects, or in companion objects.");
        map.put(FirErrors.INSTANCE.getCONST_VAL_WITH_GETTER(), "Const 'val' cannot have a getter.");
        map.put(FirErrors.INSTANCE.getCONST_VAL_WITH_DELEGATE(), "Const 'val' cannot have a delegate.");
        map.put(FirErrors.INSTANCE.getTYPE_CANT_BE_USED_FOR_CONST_VAL(), "Const ''val'' has type ''{0}''. Only primitive types and ''String'' are allowed.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getCONST_VAL_WITHOUT_INITIALIZER(), "Const 'val' must have an initializer.");
        map.put(FirErrors.INSTANCE.getCONST_VAL_WITH_NON_CONST_INITIALIZER(), "Const 'val' initializer should be a constant value.");
        map.put(FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION(), "Only 'const val' can be used in constant expressions.");
        map.put(FirErrors.INSTANCE.getCYCLE_IN_ANNOTATION_PARAMETER(), "Cycle formed by one or more annotations and their parameter types.");
        map.put(FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), "Expected declaration cannot have a body.");
        map.put(FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL(), "Explicit delegation call for constructor of expected class is prohibited.");
        map.put(FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), "Expected class constructor cannot have a property parameter.");
        map.put(FirErrors.INSTANCE.getEXPECTED_ENUM_CONSTRUCTOR(), "Expected enum class cannot have a constructor.");
        map.put(FirErrors.INSTANCE.getEXPECTED_ENUM_ENTRY_WITH_BODY(), "Expected enum entry cannot have a body.");
        map.put(FirErrors.INSTANCE.getEXPECTED_PROPERTY_INITIALIZER(), "Expected property cannot have an initializer.");
        map.put(FirErrors.INSTANCE.getEXPECTED_DELEGATED_PROPERTY(), "Expected property cannot be delegated.");
        map.put(FirErrors.INSTANCE.getEXPECTED_LATEINIT_PROPERTY(), "Expected property cannot be 'lateinit'.");
        map.put(FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), "Expected declaration cannot be private.");
        map.put(FirErrors.INSTANCE.getEXPECTED_EXTERNAL_DECLARATION(), "Expected declaration cannot be external.");
        map.put(FirErrors.INSTANCE.getEXPECTED_TAILREC_FUNCTION(), "Expected function cannot have 'tailrec' modifier.");
        map.put(FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS(), "Expected classes cannot initialize supertypes.");
        map.put(FirErrors.INSTANCE.getIMPLEMENTATION_BY_DELEGATION_IN_EXPECT_CLASS(), "Implementation by delegation in expected classes is prohibited.");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_NOT_TO_CLASS(), "Right-hand side of actual type alias should be a class, not another type alias.");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE(), "Aliased class should not have type parameters with declaration-site variance.");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE(), "Right-hand side of actual type alias cannot contain use-site variance or star projections.");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION(), "Type arguments in the right-hand side of actual type alias should be its type parameters in the same order, e.g. 'actual typealias Foo<A, B> = Bar<A, B>'.");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NULLABLE_TYPE(), "Right-hand side of actual type alias cannot be a nullable type");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NOTHING(), "Right-hand side of actual type alias cannot be of type kotlin.Nothing");
        map.put(FirErrors.INSTANCE.getACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS(), "Actual function cannot have default argument values. They should be declared in the expected function.");
        map.put(FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_WITH_ACTUAL_TYPEALIAS(), "Default argument values inside expect declaration ''{0}'' are not allowed if it is actualized via typealias. Possible fix is to remove default argument values in members:{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEWLINE_WITH_INDENT());
        map.put(FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_ACTUALIZED_BY_FAKE_OVERRIDE(), "Default argument values inside expect declaration ''{0}'' are not allowed for methods actualized via fake override. Possible fix is to remove default argument values in members:{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getDECLARATION_NAME(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEWLINE_WITH_INDENT());
        map.put(FirErrors.INSTANCE.getEXPECTED_FUNCTION_SOURCE_WITH_DEFAULT_ARGUMENTS_NOT_FOUND(), "Expected function source is not found, so generating default argument values declared there is impossible. Please add the corresponding file to compilation sources.");
        map.put(FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), "''{0}'' has no corresponding expected declaration{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirPlatformIncompatibilityDiagnosticRenderer.TEXT);
        map.put(FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), "''{0}'' has several compatible expect declarations in modules {1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.COLLECTION(FirDiagnosticRenderers.INSTANCE.getMODULE_DATA()));
        map.put(FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), "''{0}'' has no corresponding members for expected class members:{1}", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirIncompatibleExpectedActualClassScopesRenderer.TEXT);
        map.put(FirErrors.INSTANCE.getACTUAL_MISSING(), "Declaration must be marked with 'actual'.");
        map.put(FirErrors.INSTANCE.getEXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING(), "'expect'/'actual' classes (including interfaces, objects, annotations, enums, and 'actual' typealiases) are in Beta. You can use -Xexpect-actual-classes flag to suppress this warning. Also see: https://youtrack.jetbrains.com/issue/KT-61573");
        map.put(FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION(), "'expect' and 'actual' declarations can be used only in multiplatform projects. Learn more about Kotlin Multiplatform: https://kotl.in/multiplatform-setup");
        map.put(FirErrors.INSTANCE.getEXPECT_ACTUAL_OPT_IN_ANNOTATION(), "Opt-in annotations are prohibited to be 'expect' or 'actual'. Instead, declare annotation once in common sources.");
        map.put(FirErrors.INSTANCE.getACTUAL_TYPEALIAS_TO_SPECIAL_ANNOTATION(), "''actual typealias'' to annotation which affects code compilation can lead to incorrect behavior. Instead, use ''{0}'' annotation directly.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getCLASS_ID());
        map.put(FirErrors.INSTANCE.getACTUAL_ANNOTATIONS_NOT_MATCH_EXPECT(), "{3}.\nAll annotations from expect ''{0}'' must be present with the same arguments on actual ''{1}'', otherwise they might behave incorrectly.", (DiagnosticParameterRenderer)FirExpectActualAnnotationIncompatibilityDiagnosticRenderers.INSTANCE.getSYMBOL_RENDERER(), (DiagnosticParameterRenderer)FirExpectActualAnnotationIncompatibilityDiagnosticRenderers.INSTANCE.getSYMBOL_RENDERER(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)FirExpectActualAnnotationIncompatibilityDiagnosticRenderers.INSTANCE.getINCOMPATIBILITY());
        map.put(FirErrors.INSTANCE.getOPTIONAL_DECLARATION_OUTSIDE_OF_ANNOTATION_ENTRY(), "Declaration annotated with '@OptionalExpectation' can only be used inside an annotation entry");
        map.put(FirErrors.INSTANCE.getOPTIONAL_DECLARATION_USAGE_IN_NON_COMMON_SOURCE(), "Declaration annotated with '@OptionalExpectation' can only be used in common module sources");
        map.put(FirErrors.INSTANCE.getOPTIONAL_EXPECTATION_NOT_ON_EXPECTED(), "'@OptionalExpectation' can only be used on an expected annotation class");
        map.put(FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), "Initializer required for destructuring declaration.");
        map.put(FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), "Destructuring of type ''{1}'' requires operator function ''{0}()''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY(), "Function ''{0}()'' is ambiguous for this expression: {1}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getAMBIGUOUS_CALLS());
        map.put(FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE(), "Non-nullable value required to call ''{0}()'' function of destructuring declaration initializer.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), "Function ''{0}()'' returns ''{1}'', but ''{2}'' is expected.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), "Variable ''{0}'' must be initialized.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getUNINITIALIZED_PARAMETER(), "Parameter ''{0}'' is uninitialized here.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getUNINITIALIZED_ENUM_ENTRY(), "Enum entry ''{0}'' is uninitialized here.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getUNINITIALIZED_ENUM_COMPANION(), "Companion object of enum class ''{0}'' is uninitialized here.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getVAL_REASSIGNMENT(), "''val'' cannot be reassigned.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), "Reassignment of read-only property via backing field.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getCAPTURED_VAL_INITIALIZATION(), "Captured values cannot be initialized because of possible reassignments.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getCAPTURED_MEMBER_VAL_INITIALIZATION(), "Initialization of captured member values is prohibited because of possible reassignments.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getNON_INLINE_MEMBER_VAL_INITIALIZATION(), "Initialization of captured member values must be inlined.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getSETTER_PROJECTED_OUT(), "Setter for ''{0}'' is removed by type projection.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getVARIABLE_NAME());
        map.put(FirErrors.INSTANCE.getWRONG_INVOCATION_KIND(), "Wrong invocation kind ''{1}'' for ''{0}'' specified, the actual invocation kind is ''{2}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getLEAKED_IN_PLACE_LAMBDA(), "Leaked in-place lambda ''{0}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getWRONG_IMPLIES_CONDITION(), "Wrong 'implies' condition.");
        map.put(FirErrors.INSTANCE.getUNREACHABLE_CODE(), "Unreachable code.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getSENSELESS_COMPARISON(), "Condition is always ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getSENSELESS_NULL_IN_WHEN(), "Expression under 'when' is never equal to null.");
        map.put(FirErrors.INSTANCE.getUSELESS_CALL_ON_NOT_NULL(), "Unnecessary call on a non-null value.");
        map.put(FirErrors.INSTANCE.getUNSAFE_CALL(), "Only safe (?.) or non-null asserted (!!.) calls are allowed on a nullable receiver of type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getUNSAFE_IMPLICIT_INVOKE_CALL(), "Reference has a nullable type ''{0}''. Use explicit ''?.invoke'' to make a function-like call instead.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUNSAFE_INFIX_CALL(), "Infix call is prohibited on a nullable receiver of type ''{0}''. Use ''?.''-qualified call instead.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getUNSAFE_OPERATOR_CALL(), "Operator call is prohibited on a nullable receiver of type ''{0}''. Use ''?.''-qualified call instead.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getUNNECESSARY_NOT_NULL_ASSERTION(), "Unnecessary non-null assertion (!!) on a non-null receiver of type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getNOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION(), "Non-null assertion (!!) called on a lambda expression.");
        map.put(FirErrors.INSTANCE.getNOT_NULL_ASSERTION_ON_CALLABLE_REFERENCE(), "Non-null assertion (!!) called on a callable reference expression.");
        map.put(FirErrors.INSTANCE.getUNNECESSARY_SAFE_CALL(), "Unnecessary safe call on a non-null receiver of type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getSAFE_CALL_WILL_CHANGE_NULLABILITY(), "Safe call on a non-null receiver will have nullable type in future releases.\nSafe call on non-nullable receiver has a non-null type: SomeType.\nIn future releases all safe calls will have nullable type: SomeType?");
        map.put(FirErrors.INSTANCE.getUNEXPECTED_SAFE_CALL(), "Safe call is prohibited here.");
        map.put(FirErrors.INSTANCE.getUSELESS_ELVIS(), "Elvis operator (?:) always returns the left operand of non-nullable type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUSELESS_ELVIS_RIGHT_IS_NULL(), "Right operand of elvis operator (?:) is useless if it is null.");
        map.put(FirErrors.INSTANCE.getCANNOT_CHECK_FOR_ERASED(), "Cannot check for instance of erased type ''{0}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getCAST_NEVER_SUCCEEDS(), "This cast can never succeed.");
        map.put(FirErrors.INSTANCE.getUSELESS_CAST(), "No cast needed.");
        map.put(FirErrors.INSTANCE.getUNCHECKED_CAST(), "Unchecked cast of ''{0}'' to ''{1}''.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUSELESS_IS_CHECK(), "Check for instance is always ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDYNAMIC_NOT_ALLOWED(), "Dynamic types are not allowed in this position.");
        map.put(FirErrors.INSTANCE.getIS_ENUM_ENTRY(), "'is' over enum entry is prohibited. Use comparison instead.");
        map.put(FirErrors.INSTANCE.getENUM_ENTRY_AS_TYPE(), "Use of enum entry names as types is prohibited. Use enum type instead.");
        map.put(FirErrors.INSTANCE.getEXPECTED_CONDITION(), "Condition of type 'Boolean' expected.");
        map.put(FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), "''when'' expression must be exhaustive. Add {0}{1}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getWHEN_MISSING_CASES(), (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), "'if' must have both main and 'else' branches when used as an expression.");
        map.put(FirErrors.INSTANCE.getNON_EXHAUSTIVE_WHEN_STATEMENT(), "Non-exhaustive ''when'' statements on ''{0}'' will be prohibited in 1.7. Add {1}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getWHEN_MISSING_CASES());
        map.put(FirErrors.INSTANCE.getELSE_MISPLACED_IN_WHEN(), "'else' entry must be the last one in a 'when' expression.");
        map.put(FirErrors.INSTANCE.getCOMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT(), "Use '||' instead of commas in conditions of 'when' without a subject.");
        map.put(FirErrors.INSTANCE.getDUPLICATE_BRANCH_CONDITION_IN_WHEN(), "Duplicate branch condition in 'when'.");
        map.put(FirErrors.INSTANCE.getILLEGAL_DECLARATION_IN_WHEN_SUBJECT(), "Illegal variable declaration in ''when'' subject: {0}. Should be a simple ''val'' with an initializer.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getCONFUSING_BRANCH_CONDITION(), "Logical expression in when-with-subject. The branch will be matched by comparing the result of the logical expression with the subject. To suppress the diagnostic, wrap the expression with parentheses.");
        map.put(FirErrors.INSTANCE.getCOMMA_IN_WHEN_CONDITION_WITH_WHEN_GUARD(), "Use of comma in 'when' condition with guard statement is not allowed.");
        map.put(FirErrors.INSTANCE.getWHEN_GUARD_WITHOUT_SUBJECT(), "Guard statements are only allowed in 'when' with subject.");
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_IS_NOT_AN_EXPRESSION(), "Type parameter ''{0}'' is not an expression.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getTYPE_PARAMETER_ON_LHS_OF_DOT(), "Type parameter ''{0}'' cannot have or inherit a companion object, so it cannot be on the left-hand side of a dot.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNO_COMPANION_OBJECT(), "Classifier ''{0}'' does not have a companion object, so it cannot be used as an expression.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getEXPRESSION_EXPECTED_PACKAGE_FOUND(), "Expression expected, but package name found.");
        map.put(FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), "Error in contract description: {0}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), "{0}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNO_GET_METHOD(), "No 'get' operator method providing array access.");
        map.put(FirErrors.INSTANCE.getNO_SET_METHOD(), "No 'set' operator method providing array access.");
        map.put(FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_MISSING(), "Type ''{1}'' has no method ''{0}'', so it cannot serve as a {2}.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_AMBIGUITY(), "Overload resolution ambiguity on method ''{0}'':{1}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE(), "Property delegate must have a ''{0}'' method. None of the following functions is applicable:{1}", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOLS_ON_NEXT_LINES());
        map.put(FirErrors.INSTANCE.getDELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH(), "Function ''{0}'' of property delegate is expected to return ''{1}'', but returns ''{2}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), "Names _, __, ___, ... are reserved in Kotlin.");
        map.put(FirErrors.INSTANCE.getUNDERSCORE_USAGE_WITHOUT_BACKTICKS(), "Names _, __, ___, ... can only be used in back-ticks (`_`, `__`, `___`, ...).");
        map.put(FirErrors.INSTANCE.getRESOLVED_TO_UNDERSCORE_NAMED_CATCH_PARAMETER(), "Referencing an underscore-named parameter is deprecated. It will be an error in a future release.");
        map.put(FirErrors.INSTANCE.getINVALID_CHARACTERS(), "Name {0}.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getDANGEROUS_CHARACTERS(), "Name contains character(s) that can cause problems on Windows: {0}", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE(), "Operator ''{0}'' cannot be applied to ''{1}'' and ''{2}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE_WARNING(), "Comparison with ''{0}'' might not be intended because ''{1}'' and ''{2}'' are incompatible types.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON_ERROR(), "Comparison of incompatible enums ''{0}'' and ''{1}'' is always unsuccessful.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON(), "Comparison of incompatible enums ''{0}'' and ''{1}'' is always unsuccessful.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getFORBIDDEN_IDENTITY_EQUALS(), "Identity equality for arguments of types ''{0}'' and ''{1}'' is prohibited.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getFORBIDDEN_IDENTITY_EQUALS_WARNING(), "Identity equality for arguments of types ''{0}'' and ''{1}'' is prohibited.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getDEPRECATED_IDENTITY_EQUALS(), "Identity equality for arguments of types ''{0}'' and ''{1}'' is deprecated.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getIMPLICIT_BOXING_IN_IDENTITY_EQUALS(), "Identity equality for arguments of types ''{0}'' and ''{1}'' can be unstable because of implicit boxing.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE(), FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getINC_DEC_SHOULD_NOT_RETURN_UNIT(), "Functions 'inc()', 'dec()' shouldn't return 'Unit' to be used by operators ++, --.");
        map.put(FirErrors.INSTANCE.getASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT(), "Function ''{0}'' must return ''Unit'' to be used by corresponding operator ''{1}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getNOT_FUNCTION_AS_OPERATOR(), "{0} ''{1}'' cannot be used as operator.", (DiagnosticParameterRenderer)CommonRenderers.STRING, (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getDSL_SCOPE_VIOLATION(), "''{0}'' cannot be called in this context with an implicit receiver. Use an explicit receiver if necessary.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getTOPLEVEL_TYPEALIASES_ONLY(), "Nested and local type aliases are not supported.");
        map.put(FirErrors.INSTANCE.getRECURSIVE_TYPEALIAS_EXPANSION(), "Recursive type alias in expansion.");
        map.put(FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), "Type alias expands to ''{0}'', which is not a class, interface, or object.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getCONSTRUCTOR_OR_SUPERTYPE_ON_TYPEALIAS_WITH_TYPE_PROJECTION(), "Type alias with type projection ('in', 'out' or '*') in expanded type in constructor call or supertype position. See https://youtrack.jetbrains.com/issue/KT-60305.");
        map.put(FirErrors.INSTANCE.getRETURN_NOT_ALLOWED(), "'return' is prohibited here.");
        map.put(FirErrors.INSTANCE.getNOT_A_FUNCTION_LABEL(), "Target label does not denote a function.");
        map.put(FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY(), "Returns are prohibited for functions with an expression body. Use block body '{...}'.");
        map.put(FirErrors.INSTANCE.getANONYMOUS_INITIALIZER_IN_INTERFACE(), "Anonymous initializers in interfaces are prohibited.");
        map.put(FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), "Illegal usage of inline parameter ''{0}''. Add ''noinline'' modifier to the parameter declaration.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED(), "Cannot inline ''{0}'' here: it might contain non-local returns. Add ''crossinline'' modifier to parameter declaration ''{0}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getRECURSION_IN_INLINE(), "Inline function ''{0}'' cannot be recursive.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE(), "Public-API inline {1} cannot access non-public-API {0}.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND());
        map.put(FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE_DEPRECATION(), "Public-API inline {1} cannot access non-public-API {0}. This will become an error in " + FirErrorsDefaultMessagesKt.formatKotlinWithVersion(LanguageFeature.ProhibitPrivateOperatorCallInInline) + '.', (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND());
        map.put(FirErrors.INSTANCE.getNON_PUBLIC_INLINE_CALL_FROM_PUBLIC_INLINE(), "Public-API inline {1} cannot access non-public-API inline {0} as it could transitively access non-public-API declarations.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND());
        map.put(FirErrors.INSTANCE.getNON_PUBLIC_DATA_COPY_CALL_FROM_PUBLIC_INLINE(), "This ''copy'' usage exposes the non-public primary constructor of a ''data class''. The ''copy'' will change its visibility in future versions of Kotlin. The public-API inline {0} won''t be able to access non-public-API ''copy''. See https://youtrack.jetbrains.com/issue/KT-11914", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND());
        map.put(FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE(), "Protected constructor call from public-API inline {0} is deprecated.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE(), "Protected function call from public-API inline {0} is deprecated.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR(), "Protected function call from public-API inline {0} is prohibited.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getNOT_RENDERED());
        map.put(FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), "Non-private inline function ''{1}'' cannot access members of private class ''{0}''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), "{0} are not yet supported in inline functions.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getNOTHING_TO_INLINE(), "Expected performance impact from inlining is insignificant. Inlining works best for functions with parameters of function types.");
        map.put(FirErrors.INSTANCE.getNULLABLE_INLINE_PARAMETER(), "Inline parameter ''{0}'' of ''{1}'' must not be nullable. Add ''noinline'' modifier to the parameter declaration or make its type not nullable.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL(), (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), "Accessing super members from public-API inline {0} is deprecated.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL_KIND());
        map.put(FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), "Modifier is only allowed for function parameters of an inline function.");
        map.put(FirErrors.INSTANCE.getINLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED(), "Suspend inline lambda parameters of non-suspend function type are not supported. Add 'noinline' or 'crossinline' modifier.");
        map.put(FirErrors.INSTANCE.getINEFFICIENT_EQUALS_OVERRIDING_IN_VALUE_CLASS(), "Overriding ''equals'' from ''Any'' in value class without operator ''equals(other: {0}): Boolean'' leads to boxing on every equality comparison.", FirDiagnosticRenderers.INSTANCE.getRENDER_TYPE());
        map.put(FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), "Cannot import on demand from object ''{0}''.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), "Packages cannot be imported.");
        map.put(FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), "Cannot import ''{0}''. Functions and properties can only be imported from packages or objects.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getCONFLICTING_IMPORT(), "Conflicting import: imported name ''{0}'' is ambiguous.", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), "Operator renamed to a different operator on import.");
        map.put(FirErrors.INSTANCE.getTYPEALIAS_AS_CALLABLE_QUALIFIER_IN_IMPORT(), "Cannot use typealias ''{0}'' as a callable qualifier in import. Use original class ''{1}'' instead or rewrite calls with ''{0}'' as a qualifier. See https://youtrack.jetbrains.com/issue/KT-64431.", (DiagnosticParameterRenderer)CommonRenderers.NAME, (DiagnosticParameterRenderer)CommonRenderers.NAME);
        map.put(FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), "Suspend function ''{0}'' should be called only from a coroutine or another suspend function.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), "Suspend property ''{0}'' should be accessed only from a coroutine or suspend function.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), "Suspension functions can only be called within coroutine body.");
        map.put(FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), "Restricted suspending functions can invoke member or extension suspending functions only on their restricted coroutine scope.");
        map.put(FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), "'suspend' function can only be called in the form of a modifier of a lambda: suspend { ... }.");
        map.put(FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), "Calls in the form of 'suspend {}' are deprecated because 'suspend' in this context will have the meaning of a modifier. Surround the lambda with parentheses: 'suspend({ ... })'.");
        map.put(FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN(), "Calls in the form of 'suspend fun' are deprecated because 'suspend' in the context will have the meaning of a modifier. Surround the argument of the call with parentheses: 'suspend(fun() { ... })'. See https://youtrack.jetbrains.com/issue/KT-49264");
        map.put(FirErrors.INSTANCE.getRETURN_FOR_BUILT_IN_SUSPEND(), "Using implicit label for this lambda is prohibited.");
        map.put(FirErrors.INSTANCE.getMIXING_SUSPEND_AND_NON_SUSPEND_SUPERTYPES(), "Mixing suspend and non-suspend supertypes is not allowed");
        map.put(FirErrors.INSTANCE.getMIXING_FUNCTIONAL_KINDS_IN_SUPERTYPES(), "Mixing supertypes of different functional kinds ({0}) is not allowed.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getFUNCTIONAL_TYPE_KINDS());
        map.put(FirErrors.INSTANCE.getREDUNDANT_LABEL_WARNING(), "Label is redundant, because it cannot be referenced in a 'break', 'continue', or 'return' expression.");
        map.put(FirErrors.INSTANCE.getMULTIPLE_LABELS_ARE_FORBIDDEN(), "Multiple labels per statement are forbidden.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENUM_ENTRY_COMPANION_PROPERTY(), "Ambiguous access to the enum companion's property 'entries' is deprecated. Please, add the explicit 'Companion' qualifier to the class name.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENTRY_PROPERTY_FROM_ENUM(), "Ambiguous access to the 'entries' property from within the enum is deprecated. Please add the explicit qualifier to the call.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENTRIES_PROPERTY(), "Ambiguous access to the 'entries' property is deprecated. In the future, it will be shadowed by enum 'entries' property. Please resolve the ambiguity (e.g. by adding explicit qualifier to the call).");
        map.put(FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENUM_ENTRY_PROPERTY_AS_REFERENCE(), "Ambiguous access to the 'entries' property is deprecated. Please specify the type of the referenced expression explicitly.");
        map.put(FirErrors.INSTANCE.getDEPRECATED_ACCESS_TO_ENTRIES_AS_QUALIFIER(), "Ambiguous access to the 'entries' qualifier is deprecated. In the future, it will be shadowed by enum 'entries' property. Please resolve the ambiguity (e.g. by renaming conflicting declaration).");
        map.put(FirErrors.INSTANCE.getDEPRECATED_DECLARATION_OF_ENUM_ENTRY(), "Conflicting declarations: the enum entry 'entries' and the property 'Enum.entries' (KT-48872). Please rename the enum entry declaration.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), "Redundant visibility modifier.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_MODALITY_MODIFIER(), "Redundant modality modifier.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_RETURN_UNIT_TYPE(), "Redundant return 'Unit' type.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE(), "Redundant explicit type.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_SINGLE_EXPRESSION_STRING_TEMPLATE(), "Redundant string template.");
        map.put(FirErrors.INSTANCE.getCAN_BE_VAL(), "The 'var' property is never written to, so it can be declared as 'val'.");
        map.put(FirErrors.INSTANCE.getCAN_BE_REPLACED_WITH_OPERATOR_ASSIGNMENT(), "Assignment can be replaced with operator assignment.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), "Redundant call of conversion method.");
        map.put(FirErrors.INSTANCE.getARRAY_EQUALITY_OPERATOR_CAN_BE_REPLACED_WITH_EQUALS(), "'==' compares only references. Replace '==' with 'contentEquals' to compare the arrays' contents.");
        map.put(FirErrors.INSTANCE.getEMPTY_RANGE(), "Range is empty.");
        map.put(FirErrors.INSTANCE.getREDUNDANT_SETTER_PARAMETER_TYPE(), "Redundant setter parameter type.");
        map.put(FirErrors.INSTANCE.getUNUSED_VARIABLE(), "Variable is unused.");
        map.put(FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), "Assigned value is never read.");
        map.put(FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), "Initializer is redundant.");
        map.put(FirErrors.INSTANCE.getVARIABLE_NEVER_READ(), "Variable is never read.");
        map.put(FirErrors.INSTANCE.getUNUSED_ANONYMOUS_PARAMETER(), "Parameter ''{0}'' is never used, could be renamed to ''_''.", (DiagnosticParameterRenderer)FirDiagnosticRenderers.INSTANCE.getSYMBOL());
        map.put(FirErrors.INSTANCE.getINCOMPATIBLE_CLASS(), "{0} was compiled with an incompatible version of Kotlin. {1}", (DiagnosticParameterRenderer)CommonRenderers.STRING, (DiagnosticParameterRenderer)DiagnosticParameterRendererKt.Renderer(FirErrorsDefaultMessages::MAP$lambda$2$lambda$1));
        map.put(FirErrors.INSTANCE.getPRE_RELEASE_CLASS(), "{0} is compiled by a pre-release version of Kotlin and cannot be loaded by this version of the compiler", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getIR_WITH_UNSTABLE_ABI_COMPILED_CLASS(), "{0} is compiled by an unstable version of the Kotlin compiler and cannot be loaded by this compiler.", (DiagnosticParameterRenderer)CommonRenderers.STRING);
        map.put(FirErrors.INSTANCE.getBUILDER_INFERENCE_STUB_RECEIVER(), "The type of a receiver hasn''t been inferred yet. Please specify type argument for generic parameter ''{0}'' of ''{1}'' explicitly", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        map.put(FirErrors.INSTANCE.getBUILDER_INFERENCE_MULTI_LAMBDA_RESTRICTION(), "Unstable inference behaviour with multiple lambdas. Please specify the type argument for generic parameter ''{0}'' of ''{1}'' explicitly", (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING(), (DiagnosticParameterRenderer)KtDiagnosticRenderers.INSTANCE.getTO_STRING());
        MAP = ktDiagnosticFactoryToRendererMap;
    }
}

