/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirBlock;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirBlock;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "<init>", "()V", "isDestructuredParameter", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkForLocalConflictingFunctions", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n2632#2,3:44\n827#2:47\n855#2,2:48\n*S KotlinDebug\n*F\n+ 1 FirConflictsExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConflictsExpressionChecker\n*L\n25#1:44,3\n26#1:47\n26#1:48,2\n*E\n"})
public final class FirConflictsExpressionChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirConflictsExpressionChecker INSTANCE = new FirConflictsExpressionChecker();

    private FirConflictsExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    private final boolean isDestructuredParameter(FirStatement $this$isDestructuredParameter) {
        return $this$isDestructuredParameter instanceof FirVariable && FirConflictsHelpersKt.getDestructuredParameter((FirVariable)$this$isDestructuredParameter) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirBlock expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        List list;
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Iterable $this$none$iv = expression2.getStatements();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirStatement it = (FirStatement)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.isDestructuredParameter(it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            list = expression2.getStatements();
        } else {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = expression2.getStatements();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirStatement it = (FirStatement)element$iv$iv;
                boolean bl3 = false;
                if (INSTANCE.isDestructuredParameter(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List elements = list;
        FirConflictsHelpersKt.checkForLocalRedeclarations(elements, context2, reporter);
        this.checkForLocalConflictingFunctions(expression2, context2, reporter);
    }

    private final void checkForLocalConflictingFunctions(FirBlock expression2, CheckerContext context2, DiagnosticReporter reporter) {
        Map<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> conflictingFunctions = FirConflictsHelpersKt.collectConflictingLocalFunctionsFrom(expression2, context2);
        for (Map.Entry<FirFunctionSymbol<?>, Set<FirBasedSymbol<?>>> entry : conflictingFunctions.entrySet()) {
            FirFunctionSymbol<?> function2 = entry.getKey();
            Set<FirBasedSymbol<?>> otherFunctionsThatConflictWithIt = entry.getValue();
            if (otherFunctionsThatConflictWithIt.isEmpty()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), otherFunctionsThatConflictWithIt, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

