/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.InferenceUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallableReferenceChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkReferenceIsToAllowedMember", "referredSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "checkCapturedTypeInMutableReference", "callableReferenceAccess", "Lksp/org/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "checkers"})
public final class FirCallableReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirCallableReferenceChecker INSTANCE = new FirCallableReferenceChecker();

    private FirCallableReferenceChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirCallableReferenceAccess)) {
            return;
        }
        if (((FirCallableReferenceAccess)expression2).getHasQuestionMarkAtLHS()) {
            FirExpression firExpression = ((FirCallableReferenceAccess)expression2).getExplicitReceiver();
            if (!((firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null) instanceof FirResolvedQualifier)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCallableReferenceAccess)expression2).getSource(), FirErrors.INSTANCE.getSAFE_CALLABLE_REFERENCE_CALL(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(((FirCallableReferenceAccess)expression2).getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        FirBasedSymbol<?> referredSymbol = reference2.getResolvedSymbol();
        KtSourceElement ktSourceElement = reference2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        this.checkReferenceIsToAllowedMember(referredSymbol, source, context2, reporter);
        this.checkCapturedTypeInMutableReference((FirCallableReferenceAccess)expression2, referredSymbol, source, context2, reporter);
    }

    private final void checkReferenceIsToAllowedMember(FirBasedSymbol<?> referredSymbol, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (referredSymbol instanceof FirConstructorSymbol) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(referredSymbol);
            if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) == ClassKind.ANNOTATION_CLASS) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCALLABLE_REFERENCE_TO_ANNOTATION_CONSTRUCTOR(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        FirCallableSymbol firCallableSymbol = referredSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)referredSymbol : null;
        boolean bl = firCallableSymbol != null ? DeclarationUtilsKt.isExtensionMember(firCallableSymbol) : false;
        if (bl && !DeclarationUtilsKt.isLocalMember(referredSymbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED(), referredSymbol, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkCapturedTypeInMutableReference(FirCallableReferenceAccess callableReferenceAccess, FirBasedSymbol<?> referredSymbol, KtSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (!InferenceUtilsKt.isKMutableProperty(FirTypeUtilsKt.getResolvedType(callableReferenceAccess), context2.getSession())) {
            return;
        }
        if (!(referredSymbol instanceof FirCallableSymbol)) {
            return;
        }
        FirResolvedTypeRef returnType2 = context2.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol)referredSymbol);
        if (ConeTypeUtilsKt.hasCapture(returnType2.getConeType())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMUTABLE_PROPERTY_WITH_CAPTURED_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

