/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.contracts.parsing.effects;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import ksp.org.jetbrains.kotlin.contracts.parsing.AbstractPsiEffectParser;
import ksp.org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import ksp.org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import ksp.org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import ksp.org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import ksp.org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/contracts/parsing/effects/PsiCallsEffectParser;", "Lksp/org/jetbrains/kotlin/contracts/parsing/AbstractPsiEffectParser;", "collector", "Lksp/org/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lksp/org/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "contractParserDispatcher", "Lksp/org/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "<init>", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "tryParseEffect", "Lksp/org/jetbrains/kotlin/contracts/description/EffectDeclaration;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "toInvocationKind", "Lksp/org/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class PsiCallsEffectParser
extends AbstractPsiEffectParser {
    public PsiCallsEffectParser(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull PsiContractParserDispatcher contractParserDispatcher) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        Intrinsics.checkNotNullParameter((Object)contractParserDispatcher, (String)"contractParserDispatcher");
        super(collector2, callContext, contractParserDispatcher);
    }

    @Override
    @Nullable
    public EffectDeclaration tryParseEffect(@NotNull KtExpression expression2) {
        EventOccurrencesRange kind;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getCallContext().getBindingContext());
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor descriptor2 = callableDescriptor;
        if (!PsiContractsUtilsKt.isCallsInPlaceEffectDescriptor(descriptor2)) {
            return null;
        }
        VariableReference variableReference = this.getContractParserDispatcher().parseVariable(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3));
        if (variableReference == null) {
            return null;
        }
        VariableReference lambda = variableReference;
        List<ResolvedValueArgument> list = resolvedCall3.getValueArgumentsByIndex();
        ResolvedValueArgument kindArgument = list != null ? (ResolvedValueArgument)CollectionsKt.getOrNull(list, (int)1) : null;
        ResolvedValueArgument resolvedValueArgument = kindArgument;
        EventOccurrencesRange eventOccurrencesRange = resolvedValueArgument instanceof DefaultValueArgument ? EventOccurrencesRange.UNKNOWN : (resolvedValueArgument instanceof ExpressionValueArgument ? ((object = ((ExpressionValueArgument)kindArgument).getValueArgument()) != null && (object = object.getArgumentExpression()) != null ? this.toInvocationKind((KtExpression)object, this.getCallContext().getBindingContext()) : null) : (kind = null));
        if (kind == null) {
            Object object2 = kindArgument instanceof ExpressionValueArgument ? (ExpressionValueArgument)kindArgument : null;
            if (object2 == null || (object2 = ((ExpressionValueArgument)object2).getValueArgument()) == null || (object2 = object2.getArgumentExpression()) == null) {
                object2 = expression2;
            }
            Object reportOn = object2;
            this.getCollector().badDescription("unrecognized InvocationKind", (KtElement)reportOn);
            return null;
        }
        return new CallsEffectDeclaration(lambda, kind);
    }

    private final EventOccurrencesRange toInvocationKind(KtExpression $this$toInvocationKind, BindingContext bindingContext) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$toInvocationKind, bindingContext);
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall2;
        if (!PsiContractsUtilsKt.isInvocationKindEnum((DeclarationDescriptor)SequencesKt.first(DescriptorUtilsKt.getParents((DeclarationDescriptor)((Object)descriptor2))))) {
            return null;
        }
        Name name2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((Object)descriptor2)).shortName();
        return Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getAT_MOST_ONCE_KIND()) ? EventOccurrencesRange.AT_MOST_ONCE : (Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getEXACTLY_ONCE_KIND()) ? EventOccurrencesRange.EXACTLY_ONCE : (Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getAT_LEAST_ONCE_KIND()) ? EventOccurrencesRange.AT_LEAST_ONCE : (Intrinsics.areEqual((Object)name2, (Object)ContractsDslNames.INSTANCE.getUNKNOWN_KIND()) ? EventOccurrencesRange.UNKNOWN : null)));
    }
}

