/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.contracts.model.visitors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.contracts.model.Computation;
import ksp.org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import ksp.org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import ksp.org.jetbrains.kotlin.contracts.model.ESValue;
import ksp.org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESBooleanType;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESIs;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESNot;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESOr;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import ksp.org.jetbrains.kotlin.contracts.model.visitors.Reducer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B+\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lksp/org/jetbrains/kotlin/contracts/model/visitors/Substitutor;", "Lksp/org/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lksp/org/jetbrains/kotlin/contracts/model/Computation;", "substitutions", "", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESVariable;", "typeSubstitution", "Lksp/org/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "reducer", "Lksp/org/jetbrains/kotlin/contracts/model/visitors/Reducer;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;)V", "visitIs", "isOperator", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitNot", "not", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitEqual", "equal", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitAnd", "and", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitOr", "or", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitVariable", "esVariable", "visitConstant", "esConstant", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESConstant;", "visitReceiver", "Lksp/org/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitLambda", "lambda", "Lksp/org/jetbrains/kotlin/contracts/model/ESValue;", "resolution"})
public final class Substitutor
implements ESExpressionVisitor<Computation> {
    @NotNull
    private final Map<ESVariable, Computation> substitutions;
    @NotNull
    private final ESTypeSubstitution typeSubstitution;
    @NotNull
    private final Reducer reducer;

    public Substitutor(@NotNull Map<ESVariable, ? extends Computation> substitutions, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        Intrinsics.checkNotNullParameter(substitutions, (String)"substitutions");
        Intrinsics.checkNotNullParameter((Object)typeSubstitution, (String)"typeSubstitution");
        Intrinsics.checkNotNullParameter((Object)reducer, (String)"reducer");
        this.substitutions = substitutions;
        this.typeSubstitution = typeSubstitution;
        this.reducer = reducer;
    }

    @Override
    @Nullable
    public Computation visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkNotNullParameter((Object)isOperator, (String)"isOperator");
        Computation computation = (Computation)isOperator.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, isOperator.getFunctor().invokeWithArguments(arg, this.typeSubstitution));
    }

    @Override
    @Nullable
    public Computation visitNot(@NotNull ESNot not) {
        Intrinsics.checkNotNullParameter((Object)not, (String)"not");
        Computation computation = (Computation)not.getArg().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, not.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkNotNullParameter((Object)equal, (String)"equal");
        Computation computation = (Computation)equal.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)equal.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        Object[] objectArray = new Computation[]{left, right};
        return new CallComputation(ESBooleanType.INSTANCE, equal.getFunctor().invokeWithArguments(CollectionsKt.listOf((Object[])objectArray), this.typeSubstitution, this.reducer));
    }

    @Override
    @Nullable
    public Computation visitAnd(@NotNull ESAnd and2) {
        Intrinsics.checkNotNullParameter((Object)and2, (String)"and");
        Computation computation = (Computation)and2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)and2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, and2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitOr(@NotNull ESOr or2) {
        Intrinsics.checkNotNullParameter((Object)or2, (String)"or");
        Computation computation = (Computation)or2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)or2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, or2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @NotNull
    public Computation visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkNotNullParameter((Object)esVariable, (String)"esVariable");
        Computation computation = this.substitutions.get(esVariable);
        if (computation == null) {
            computation = esVariable;
        }
        return computation;
    }

    @Override
    @NotNull
    public Computation visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkNotNullParameter((Object)esConstant, (String)"esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkNotNullParameter((Object)esReceiver, (String)"esReceiver");
        return esReceiver;
    }

    @Override
    @NotNull
    public Computation visitLambda(@NotNull ESValue lambda) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        return lambda;
    }
}

