/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import ksp.one.util.streamex.Internals;

final class CollapseSpliterator<T, R>
extends Internals.Box<T>
implements Spliterator<R> {
    private final Spliterator<T> source;
    private final CollapseSpliterator<T, R> root;
    private R acc;
    volatile Connector<T, R> left;
    volatile Connector<T, R> right;
    private final Function<T, R> mapper;
    private final BiFunction<R, T, R> accumulator;
    private final BinaryOperator<R> combiner;
    private final BiPredicate<? super T, ? super T> mergeable;

    CollapseSpliterator(BiPredicate<? super T, ? super T> mergeable, Function<T, R> mapper, BiFunction<R, T, R> accumulator, BinaryOperator<R> combiner, Spliterator<T> source) {
        super(Internals.none());
        this.source = source;
        this.mergeable = mergeable;
        this.mapper = mapper;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.root = this;
    }

    private CollapseSpliterator(CollapseSpliterator<T, R> root, Spliterator<T> source, Connector<T, R> left, Connector<T, R> right) {
        super(Internals.none());
        this.source = source;
        this.root = root;
        this.mergeable = root.mergeable;
        this.mapper = root.mapper;
        this.accumulator = root.accumulator;
        this.combiner = root.combiner;
        this.left = left;
        this.right = right;
        if (left != null) {
            left.rhs = this;
        }
        right.lhs = this;
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        if (this.left != null && this.accept(this.handleLeft(), action)) {
            return true;
        }
        if (this.a == Internals.NONE && !this.source.tryAdvance(this)) {
            return this.accept(this.pushRight(Internals.none(), Internals.none()), action);
        }
        Object first = this.a;
        R acc = this.mapper.apply(this.a);
        Object last = first;
        while (this.source.tryAdvance(this)) {
            if (!this.mergeable.test(last, this.a)) {
                action.accept(acc);
                return true;
            }
            last = this.a;
            acc = this.accumulator.apply(acc, last);
        }
        return this.accept(this.pushRight(acc, last), action);
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        while (this.left != null) {
            this.accept(this.handleLeft(), action);
        }
        if (this.a != Internals.NONE) {
            this.acc = this.mapper.apply(this.a);
        }
        this.source.forEachRemaining((? super T next2) -> {
            if (this.a == Internals.NONE) {
                this.acc = this.mapper.apply(next2);
            } else if (!this.mergeable.test(this.a, next2)) {
                action.accept(this.acc);
                this.acc = this.mapper.apply(next2);
            } else {
                this.acc = this.accumulator.apply(this.acc, next2);
            }
            this.a = next2;
        });
        if (this.a == Internals.NONE) {
            this.accept(this.pushRight(Internals.none(), Internals.none()), action);
        } else if (this.accept(this.pushRight(this.acc, this.a), action) && this.right != null) {
            action.accept(this.right.acc);
            this.right = null;
        }
    }

    private boolean accept(R acc, Consumer<? super R> action) {
        if (acc != Internals.NONE) {
            action.accept(acc);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R handleLeft() {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l = this.left;
            if (l == null) {
                return (R)Internals.none();
            }
            if (l.left == Internals.NONE && l.right == Internals.NONE && l.acc != Internals.NONE) {
                return l.drain();
            }
        }
        if (this.source.tryAdvance(this)) {
            Object first;
            Object last = first = this.a;
            R acc = this.mapper.apply(first);
            while (this.source.tryAdvance(this)) {
                if (!this.mergeable.test(last, this.a)) {
                    return this.pushLeft(first, acc);
                }
                last = this.a;
                acc = this.accumulator.apply(acc, last);
            }
            this.a = Internals.none();
            return this.connectOne(first, acc, last);
        }
        return this.connectEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R pushLeft(T first, R acc) {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l = this.left;
            if (l == null) {
                return acc;
            }
            this.left = null;
            l.rhs = null;
            Object laright = l.right;
            l.right = Internals.none();
            if (l.acc == Internals.NONE) {
                l.acc = acc;
                l.left = first;
                return (R)Internals.none();
            }
            if (this.mergeable.test(laright, first)) {
                l.acc = this.combiner.apply(l.acc, acc);
                return l.drainLeft();
            }
            if (l.left == Internals.NONE) {
                this.left = new Connector(null, acc, this);
                return l.drain();
            }
        }
        return acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R pushRight(R acc, T last) {
        this.a = Internals.none();
        if (this.right == null) {
            return acc;
        }
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> r = this.right;
            if (r == null) {
                return acc;
            }
            this.right = null;
            r.lhs = null;
            Object raleft = r.left;
            r.left = Internals.none();
            if (r.acc == Internals.NONE) {
                if (acc == Internals.NONE) {
                    r.drain();
                } else {
                    r.acc = acc;
                    r.right = last;
                }
                return (R)Internals.none();
            }
            if (acc == Internals.NONE) {
                return r.drainRight();
            }
            if (this.mergeable.test(last, raleft)) {
                r.acc = this.combiner.apply(acc, r.acc);
                return r.drainRight();
            }
            if (r.right == Internals.NONE) {
                this.right = new Connector(this, r.drain(), null);
            }
            return acc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R connectOne(T first, R acc, T last) {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l = this.left;
            if (l == null) {
                return this.pushRight(acc, last);
            }
            if (l.acc == Internals.NONE) {
                l.acc = acc;
                l.left = first;
                l.right = last;
                return this.connectEmpty();
            }
            Object laright = l.right;
            if (this.mergeable.test(laright, first)) {
                l.acc = this.combiner.apply(l.acc, acc);
                l.right = last;
                return this.connectEmpty();
            }
            this.left = null;
            l.rhs = null;
            l.right = Internals.none();
            if (l.left != Internals.NONE) {
                return this.pushRight(acc, last);
            }
            if ((acc = this.pushRight(acc, last)) != Internals.NONE) {
                this.left = new Connector(null, acc, this);
            }
            return l.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R connectEmpty() {
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            Connector<T, R> l = this.left;
            Connector<T, R> r = this.right;
            if (l == null) {
                return (R)this.pushRight(Internals.none(), Internals.none());
            }
            this.right = null;
            this.left = null;
            l.rhs = null;
            Object laright = l.right;
            l.right = Internals.none();
            if (l.acc == Internals.NONE) {
                if (r == null) {
                    l.drain();
                } else if (l.lhs != null) {
                    l.lhs.right = r;
                    r.lhs = l.lhs;
                }
                return (R)Internals.none();
            }
            if (r == null) {
                return l.drainLeft();
            }
            r.lhs = null;
            if (r.acc == Internals.NONE) {
                if (r.rhs != null) {
                    r.rhs.left = l;
                    l.rhs = r.rhs;
                    l.right = laright;
                }
                return (R)Internals.none();
            }
            Object raleft = r.left;
            r.left = Internals.none();
            if (this.mergeable.test(laright, raleft)) {
                Object acc = this.combiner.apply(l.acc, r.acc);
                if (l.left == Internals.NONE && r.right == Internals.NONE) {
                    l.drain();
                    r.drain();
                    return acc;
                }
                l.acc = acc;
                l.right = r.right;
                if (r.rhs != null) {
                    r.rhs.left = l;
                    l.rhs = r.rhs;
                }
                return (R)Internals.none();
            }
            if (l.left == Internals.NONE) {
                if (r.right == Internals.NONE) {
                    this.right = new Connector(this, r.drain(), null);
                }
                return l.drain();
            }
            return r.drainRight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<R> trySplit() {
        Spliterator<T> prefix = this.source.trySplit();
        if (prefix == null) {
            return null;
        }
        Connector newBox = new Connector(null, Internals.none(), this);
        CollapseSpliterator<T, R> collapseSpliterator = this.root;
        synchronized (collapseSpliterator) {
            CollapseSpliterator<T, R> result2 = new CollapseSpliterator<T, R>(this.root, prefix, this.left, newBox);
            this.left = newBox;
            return result2;
        }
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0x1410;
    }

    private static final class Connector<T, R> {
        CollapseSpliterator<T, R> lhs;
        CollapseSpliterator<T, R> rhs;
        T left = Internals.none();
        T right = Internals.none();
        R acc;

        Connector(CollapseSpliterator<T, R> lhs, R acc, CollapseSpliterator<T, R> rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
            this.acc = acc;
        }

        R drain() {
            if (this.lhs != null) {
                this.lhs.right = null;
            }
            if (this.rhs != null) {
                this.rhs.left = null;
            }
            return this.acc;
        }

        R drainLeft() {
            return (R)(this.left == Internals.NONE ? this.drain() : Internals.none());
        }

        R drainRight() {
            return (R)(this.right == Internals.NONE ? this.drain() : Internals.none());
        }
    }
}

