/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.sun.jna;

import ksp.com.sun.jna.Memory;
import ksp.com.sun.jna.Native;
import ksp.com.sun.jna.Pointer;
import ksp.com.sun.jna.WString;

class NativeString
implements CharSequence,
Comparable {
    static final String WIDE_STRING = "--WIDE-STRING--";
    private Pointer pointer;
    private String encoding;

    public NativeString(String string2) {
        this(string2, Native.getDefaultStringEncoding());
    }

    public NativeString(String string2, boolean wide) {
        this(string2, wide ? WIDE_STRING : Native.getDefaultStringEncoding());
    }

    public NativeString(WString string2) {
        this(string2.toString(), WIDE_STRING);
    }

    public NativeString(String string2, String encoding) {
        if (string2 == null) {
            throw new NullPointerException("String must not be null");
        }
        this.encoding = encoding;
        if (WIDE_STRING.equals(this.encoding)) {
            int len = (string2.length() + 1) * Native.WCHAR_SIZE;
            this.pointer = new StringMemory(len);
            this.pointer.setWideString(0L, string2);
        } else {
            byte[] data = Native.getBytes(string2, encoding);
            this.pointer = new StringMemory(data.length + 1);
            this.pointer.write(0L, data, 0, data.length);
            this.pointer.setByte(data.length, (byte)0);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            return this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        boolean wide = WIDE_STRING.equals(this.encoding);
        return wide ? this.pointer.getWideString(0L) : this.pointer.getString(0L, this.encoding);
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        return this.toString().compareTo(other.toString());
    }

    private class StringMemory
    extends Memory {
        public StringMemory(long size) {
            super(size);
        }

        @Override
        public String toString() {
            return NativeString.this.toString();
        }
    }
}

