/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import ksp.com.intellij.openapi.Forceable;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.ThrowableNotNullFunction;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.openapi.util.io.FileUtilRt;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.ThrowableRunnable;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.io.DataOutputStream;
import ksp.com.intellij.util.io.PagedFileStorage;
import ksp.com.intellij.util.io.StorageLockContext;
import ksp.com.intellij.util.lang.CompoundRuntimeException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ResizeableMappedFile
implements Forceable,
Closeable {
    private static final Logger LOG = Logger.getInstance(ResizeableMappedFile.class);
    private volatile long myLogicalSize;
    private volatile long myLastWrittenLogicalSize;
    private final PagedFileStorage myStorage;
    private final int myInitialSize;
    static final int DEFAULT_ALLOCATION_ROUND_FACTOR = 4096;
    private int myRoundFactor;

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(0);
        }
        this(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(1);
        }
        this.myRoundFactor = 4096;
        this.myStorage = new PagedFileStorage(file2, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        this.ensureParentDirectoryExists();
        this.myInitialSize = initialSize;
        this.myLastWrittenLogicalSize = this.myLogicalSize = this.readLength();
        if (this.myLastWrittenLogicalSize > 0L && !Files.exists(file2, new LinkOption[0])) {
            this.myLogicalSize = 0L;
            this.myLastWrittenLogicalSize = 0L;
            this.writeLength(0L);
        }
    }

    public boolean isNativeBytesOrder() {
        return this.myStorage.isNativeBytesOrder();
    }

    public void clear() throws IOException {
        this.myStorage.resize(0L);
        this.myLogicalSize = 0L;
        this.myLastWrittenLogicalSize = 0L;
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    void ensureSize(long pos) {
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        this.expand(pos);
    }

    public void setRoundFactor(int roundFactor) {
        this.myRoundFactor = roundFactor;
    }

    private void expand(long max) {
        long suggestedSize;
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        if (realSize == 0L) {
            suggestedSize = this.doRoundToFactor(Math.max((long)this.myInitialSize, max));
        } else {
            suggestedSize = Math.max(realSize + 1L, 2L);
            while (max > suggestedSize) {
                long newSuggestedSize = suggestedSize * 13L >> 3;
                if (newSuggestedSize >= Integer.MAX_VALUE) {
                    suggestedSize += suggestedSize / 5L;
                    continue;
                }
                suggestedSize = newSuggestedSize;
            }
            suggestedSize = this.doRoundToFactor(suggestedSize);
        }
        try {
            this.myStorage.resize(suggestedSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long doRoundToFactor(long suggestedSize) {
        int roundFactor = this.myRoundFactor;
        if (suggestedSize % (long)roundFactor != 0L) {
            suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
        }
        return suggestedSize;
    }

    private Path getLengthFile() {
        Path file2 = this.myStorage.getFile();
        return file2.resolveSibling(file2.getFileName() + ".len");
    }

    private void writeLength(long len) {
        Path lengthFile = this.getLengthFile();
        try (DataOutputStream stream = FileUtilRt.doIOOperation(lastAttempt -> {
            try {
                return new DataOutputStream(Files.newOutputStream(lengthFile, new OpenOption[0]));
            }
            catch (NoSuchFileException ex) {
                this.ensureParentDirectoryExists();
                if (!lastAttempt) {
                    return null;
                }
                throw ex;
            }
        });){
            if (stream != null) {
                stream.writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Override
    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    @Override
    public void force() throws IOException {
        this.ensureLengthWritten();
        this.myStorage.force();
    }

    private void ensureLengthWritten() {
        if (this.myLastWrittenLogicalSize != this.myLogicalSize) {
            this.writeLength(this.myLogicalSize);
            this.myLastWrittenLogicalSize = this.myLogicalSize;
        }
    }

    private void ensureParentDirectoryExists() throws IOException {
        Path parent2 = this.getLengthFile().getParent();
        if (!Files.exists(parent2, new LinkOption[0])) {
            Files.createDirectories(parent2, new FileAttribute[0]);
        }
    }

    private long readLength() throws IOException {
        long l;
        Path storageFile = this.myStorage.getFile();
        Path lengthFile = this.getLengthFile();
        long zero = 0L;
        if (!(Files.exists(lengthFile, new LinkOption[0]) || Files.exists(storageFile, new LinkOption[0]) && Files.size(storageFile) != 0L)) {
            this.writeLength(0L);
            return 0L;
        }
        DataInputStream stream = new DataInputStream(Files.newInputStream(lengthFile, StandardOpenOption.READ));
        try {
            l = stream.readLong();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                long realSize = this.realSize();
                this.writeLength(realSize);
                LOG.info("Can't find .len file for " + storageFile + ", re-creating it from actual file. Storage size = " + realSize + ", file size = " + Files.size(storageFile), e);
                return realSize;
            }
        }
        stream.close();
        return l;
    }

    public int getInt(long index) throws IOException {
        return this.myStorage.getInt(index);
    }

    public void putInt(long index, int value2) throws IOException {
        this.ensureSize(index + 4L);
        this.myStorage.putInt(index, value2);
    }

    public long getLong(long index) throws IOException {
        return this.myStorage.getLong(index);
    }

    public void putLong(long index, long value2) throws IOException {
        this.ensureSize(index + 8L);
        this.myStorage.putLong(index, value2);
    }

    public byte get(long index) throws IOException {
        return this.get(index, true);
    }

    public byte get(long index, boolean checkAccess) throws IOException {
        return this.myStorage.get(index, checkAccess);
    }

    public void get(long index, byte[] dst, int offset, int length, boolean checkAccess) throws IOException {
        this.myStorage.get(index, dst, offset, length, checkAccess);
    }

    public void put(long index, byte[] src, int offset, int length) throws IOException {
        this.ensureSize(index + (long)length);
        this.myStorage.put(index, src, offset, length);
    }

    /*
     * WARNING - void declaration
     */
    public void put(long index, @NotNull ByteBuffer byteBuffer) throws IOException {
        void buffer;
        if (byteBuffer == null) {
            ResizeableMappedFile.$$$reportNull$$$0(2);
        }
        this.ensureSize(index + (long)(buffer.limit() - buffer.position()));
        this.myStorage.putBuffer(index, (ByteBuffer)buffer);
    }

    public void setLogicalSize(long logicalSize) {
        this.myLogicalSize = logicalSize;
    }

    public long getLogicalSize() {
        return this.myLogicalSize;
    }

    @Override
    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> {
            this.ensureLengthWritten();
            assert (this.myLogicalSize == this.myLastWrittenLogicalSize);
            this.myStorage.force();
            boolean truncateOnClose = SystemProperties.getBooleanProperty("idea.resizeable.file.truncate.on.close", false);
            if (truncateOnClose && this.myLogicalSize < this.myStorage.length()) {
                this.myStorage.resize(this.myLogicalSize);
            }
        };
        throwableRunnableArray[1] = this.myStorage::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Failed to close ResizableMappedFile[" + this.getPagedFileStorage().getFile() + "]"), throwableRunnableArray);
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.myStorage;
        if (pagedFileStorage == null) {
            ResizeableMappedFile.$$$reportNull$$$0(3);
        }
        return pagedFileStorage;
    }

    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.myStorage.getStorageLockContext();
        if (storageLockContext == null) {
            ResizeableMappedFile.$$$reportNull$$$0(4);
        }
        return storageLockContext;
    }

    @NotNull
    public <R> R readInputStream(@NotNull ThrowableNotNullFunction<? super InputStream, R, ? extends IOException> consumer2) throws IOException {
        if (consumer2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(5);
        }
        R r = this.myStorage.readInputStream(consumer2);
        if (r == null) {
            ResizeableMappedFile.$$$reportNull$$$0(6);
        }
        return r;
    }

    @NotNull
    public <R> R readChannel(@NotNull ThrowableNotNullFunction<? super ReadableByteChannel, R, ? extends IOException> consumer2) throws IOException {
        if (consumer2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(7);
        }
        R r = this.myStorage.readChannel(consumer2);
        if (r == null) {
            ResizeableMappedFile.$$$reportNull$$$0(8);
        }
        return r;
    }

    public void lockRead() {
        this.myStorage.lockRead();
    }

    public void unlockRead() {
        this.myStorage.unlockRead();
    }

    public void lockWrite() {
        this.myStorage.lockWrite();
    }

    public void unlockWrite() {
        this.myStorage.unlockWrite();
    }

    public void closeAndRemoveAllFiles() throws IOException {
        SmartList exceptions = new SmartList();
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(this.myStorage::close));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> FileUtil.delete(this.myStorage.getFile())));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> FileUtil.delete(this.getLengthFile())));
        if (!exceptions.isEmpty()) {
            throw new IOException(new CompoundRuntimeException(exceptions));
        }
    }

    public String toString() {
        return "ResizeableMappedFile[" + this.myStorage.toString() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPagedFileStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readInputStream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readChannel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readInputStream";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readChannel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

