/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.compiled;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.ide.plugins.PluginManager;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.project.DefaultProjectFactory;
import ksp.com.intellij.openapi.project.IndexNotReadyException;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.projectRoots.JavaSdkVersion;
import ksp.com.intellij.openapi.roots.FileIndexFacade;
import ksp.com.intellij.openapi.ui.Queryable;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.ModificationTracker;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.ClassFileViewProvider;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassOwnerEx;
import ksp.com.intellij.psi.PsiCompiledFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiFileFactory;
import ksp.com.intellij.psi.PsiImportList;
import ksp.com.intellij.psi.PsiInvalidElementAccessException;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.PsiJavaModule;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiPackageStatement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.compiled.ClassFileDecompilers;
import ksp.com.intellij.psi.impl.JavaPsiImplementationHelper;
import ksp.com.intellij.psi.impl.PsiFileEx;
import ksp.com.intellij.psi.impl.PsiManagerImpl;
import ksp.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import ksp.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicyEx;
import ksp.com.intellij.psi.impl.compiled.ClsElementImpl;
import ksp.com.intellij.psi.impl.compiled.ClsPackageStatementImpl;
import ksp.com.intellij.psi.impl.compiled.ClsParsingUtil;
import ksp.com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import ksp.com.intellij.psi.impl.compiled.ModuleStubBuildingVisitor;
import ksp.com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import ksp.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import ksp.com.intellij.psi.impl.file.PsiBinaryFileImpl;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.StubbedSpine;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.stubs.PsiClassHolderFileStub;
import ksp.com.intellij.psi.stubs.PsiFileStubImpl;
import ksp.com.intellij.psi.stubs.StubTree;
import ksp.com.intellij.psi.stubs.StubTreeLoader;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.AstLoadingFilter;
import ksp.com.intellij.util.BitUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.cls.ClsFormatException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.org.objectweb.asm.Attribute;
import ksp.org.jetbrains.org.objectweb.asm.ClassReader;

public class ClsFileImpl
extends PsiBinaryFileImpl
implements PsiJavaFile,
PsiFileWithStubSupport,
PsiFileEx,
Queryable,
PsiClassOwnerEx,
PsiCompiledFile {
    private static final Logger LOG = Logger.getInstance(ClsFileImpl.class);
    private static final String BANNER = "\n  // IntelliJ API Decompiler stub source generated from a class file\n  // Implementation of methods is not available\n\n";
    private static final String CORRUPTED_CLASS_PACKAGE = "corrupted_class_file";
    private static final Key<Document> CLS_DOCUMENT_LINK_KEY = Key.create("cls.document.link");
    private final Object myMirrorLock;
    private final Object myStubLock;
    private final boolean myIsForDecompiling;
    private volatile SoftReference<StubTree> myStub;
    private volatile Reference<TreeElement> myMirrorFileElement;
    private volatile ClsPackageStatementImpl myPackageStatement;
    private static final InnerClassSourceStrategy<FileContentPair> STRATEGY = new InnerClassSourceStrategy<FileContentPair>(){

        @Override
        @Nullable
        public FileContentPair findInnerClass(String innerName, FileContentPair outerClass) {
            String baseName = ((VirtualFile)outerClass.first).getNameWithoutExtension();
            VirtualFile dir = ((VirtualFile)outerClass.first).getParent();
            assert (dir != null) : outerClass;
            VirtualFile innerClass = dir.findChild(baseName + '$' + innerName + ".class");
            if (innerClass != null) {
                try {
                    byte[] bytes = innerClass.contentsToByteArray(false);
                    return new FileContentPair(innerClass, new ClassReader(bytes));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void accept(FileContentPair innerClass, StubBuildingVisitor<FileContentPair> visitor2) {
            try {
                ((ClassReader)innerClass.second).accept(visitor2, EMPTY_ATTRIBUTES, 261);
            }
            catch (Exception e) {
                VirtualFile file2 = (VirtualFile)innerClass.first;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.valueOf(file2), e);
                }
                LOG.info(file2 + ": " + e.getMessage());
            }
        }
    };
    public static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];

    public ClsFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(0);
        }
        this(viewProvider, false);
    }

    private ClsFileImpl(@NotNull FileViewProvider viewProvider, boolean forDecompiling) {
        if (viewProvider == null) {
            ClsFileImpl.$$$reportNull$$$0(1);
        }
        super((PsiManagerImpl)viewProvider.getManager(), viewProvider);
        this.myMirrorLock = new Object();
        this.myStubLock = new Object();
        this.myIsForDecompiling = forDecompiling;
        JavaElementType.CLASS.getIndex();
    }

    @Override
    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.myIsForDecompiling || this.getVirtualFile().isValid());
    }

    boolean isForDecompiling() {
        return this.myIsForDecompiling;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            ClsFileImpl.$$$reportNull$$$0(2);
        }
        return javaLanguage;
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray;
        PsiJavaModule module2 = this.getModuleDeclaration();
        if (module2 != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = module2;
        } else {
            psiElementArray = this.getClasses();
        }
        if (psiElementArray == null) {
            ClsFileImpl.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        PsiClass[] psiClassArray = this.getStub().getClasses();
        if (psiClassArray == null) {
            ClsFileImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ClsPackageStatementImpl statement = this.myPackageStatement;
        if (statement == null) {
            String packageName2;
            statement = ClsPackageStatementImpl.NULL_PACKAGE;
            PsiClassHolderFileStub<?> stub = this.getStub();
            if (!(stub instanceof PsiJavaFileStub && stub.findChildStubByType(JavaStubElementTypes.MODULE) != null || (packageName2 = ClsFileImpl.findPackageName(stub)) == null)) {
                statement = new ClsPackageStatementImpl(this, packageName2);
            }
            this.myPackageStatement = statement;
        }
        return statement != ClsPackageStatementImpl.NULL_PACKAGE ? statement : null;
    }

    private static String findPackageName(PsiClassHolderFileStub<?> stub) {
        String packageName2 = null;
        if (stub instanceof PsiJavaFileStub) {
            packageName2 = ((PsiJavaFileStub)stub).getPackageName();
        } else {
            int index;
            String className;
            PsiClass[] psiClasses = stub.getClasses();
            if (psiClasses.length > 0 && (className = psiClasses[0].getQualifiedName()) != null && (index = className.lastIndexOf(46)) >= 0) {
                packageName2 = className.substring(0, index);
            }
        }
        return !StringUtil.isEmpty(packageName2) ? packageName2 : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiPackageStatement statement = this.getPackageStatement();
        String string2 = statement == null ? "" : statement.getPackageName();
        if (string2 == null) {
            ClsFileImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public void setPackageName(@NotNull String packageName2) throws IncorrectOperationException {
        if (packageName2 == null) {
            ClsFileImpl.$$$reportNull$$$0(6);
        }
        throw new IncorrectOperationException("Cannot set package name for compiled files");
    }

    @Override
    public PsiImportList getImportList() {
        return null;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClsFileImpl.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException("Cannot add imports to compiled classes");
    }

    @Override
    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(8);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        if (PsiClass.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(9);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    public String @NotNull [] getImplicitlyImportedPackages() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(10);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.getVirtualFile().getNameWithoutExtension());
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
            ClsFileImpl.$$$reportNull$$$0(11);
        }
        return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        PsiClassHolderFileStub<?> stub = this.getStub();
        if (stub instanceof PsiJavaFileStub && (level = ((PsiJavaFileStub)stub).getLanguageLevel()) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                ClsFileImpl.$$$reportNull$$$0(12);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            ClsFileImpl.$$$reportNull$$$0(13);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        PsiClassHolderFileStub<?> stub = this.getStub();
        return stub instanceof PsiJavaFileStub ? ((PsiJavaFileStub)stub).getModule() : null;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            ClsFileImpl.$$$reportNull$$$0(14);
        }
        throw ClsElementImpl.cannotModifyException(this);
    }

    @Override
    public void checkSetName(String name2) throws IncorrectOperationException {
        throw ClsElementImpl.cannotModifyException(this);
    }

    private void appendMirrorText(StringBuilder buffer) {
        buffer.append(BANNER);
        PsiJavaModule module2 = this.getModuleDeclaration();
        if (module2 != null) {
            ClsElementImpl.appendText(module2, 0, buffer);
        } else {
            PsiClass[] classes = this.getClasses();
            if (classes.length > 0) {
                PsiClass topClass = classes[0];
                if ("package-info".equals(topClass.getName())) {
                    PsiAnnotation[] annotations2;
                    for (PsiAnnotation annotation : annotations2 = topClass.getAnnotations()) {
                        ClsElementImpl.appendText(annotation, 0, buffer, "go_to_next_line_and_indent");
                    }
                    ClsElementImpl.appendText(this.getPackageStatement(), 0, buffer, "\n");
                } else {
                    ClsElementImpl.appendText(this.getPackageStatement(), 0, buffer, "\n\n");
                    ClsElementImpl.appendText(topClass, 0, buffer);
                }
            }
        }
    }

    private void setFileMirror(TreeElement element2) {
        Object mirrorElement = SourceTreeToPsiMap.treeToPsiNotNull(element2);
        if (!(mirrorElement instanceof PsiJavaFile)) {
            throw new ClsElementImpl.InvalidMirrorException("Unexpected mirror file: " + mirrorElement);
        }
        PsiJavaFile mirrorFile = (PsiJavaFile)mirrorElement;
        PsiJavaModule module2 = this.getModuleDeclaration();
        if (module2 != null) {
            ClsElementImpl.setMirror(module2, mirrorFile.getModuleDeclaration());
        } else {
            PsiElement[] classes = this.getClasses();
            PsiElement[] mirrors = mirrorFile.getClasses();
            PsiPackageStatement pkg = this.getPackageStatement();
            PsiPackageStatement mirrorPkg = mirrorFile.getPackageStatement();
            if (classes.length == 1 && mirrors.length == 0 && "package-info".equals(classes[0].getName())) {
                ClsElementImpl.setMirror(pkg, mirrorPkg);
                ClsElementImpl.setMirrorIfPresent(classes[0].getModifierList(), mirrorPkg.getAnnotationList());
            } else if (pkg == null || !CORRUPTED_CLASS_PACKAGE.equals(pkg.getPackageName())) {
                ClsElementImpl.setMirrorIfPresent(pkg, mirrorPkg);
                ClsElementImpl.setMirrors((PsiElement[])classes, (PsiElement[])mirrors);
            }
        }
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        for (ClsCustomNavigationPolicy navigationPolicy : ClsCustomNavigationPolicy.EP_NAME.getExtensionList()) {
            PsiElement psiElement;
            try {
                PsiElement navigationElement = navigationPolicy instanceof ClsCustomNavigationPolicyEx ? ((ClsCustomNavigationPolicyEx)navigationPolicy).getFileNavigationElement(this) : navigationPolicy.getNavigationElement(this);
                if (navigationElement == null) continue;
                psiElement = navigationElement;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                continue;
            }
            if (psiElement == null) {
                ClsFileImpl.$$$reportNull$$$0(15);
            }
            return psiElement;
        }
        PsiElement psiElement = (PsiElement)CachedValuesManager.getCachedValue(this, () -> {
            PsiElement target = JavaPsiImplementationHelper.getInstance(this.getProject()).getClsFileNavigationElement(this);
            ModificationTracker tracker = FileIndexFacade.getInstance(this.getProject()).getRootModificationTracker();
            return CachedValueProvider.Result.create(target, this, target.getContainingFile(), tracker);
        });
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiElement getMirror() {
        TreeElement mirrorTreeElement = ksp.com.intellij.reference.SoftReference.dereference(this.myMirrorFileElement);
        if (mirrorTreeElement == null) {
            Object object = this.myMirrorLock;
            synchronized (object) {
                mirrorTreeElement = ksp.com.intellij.reference.SoftReference.dereference(this.myMirrorFileElement);
                if (mirrorTreeElement == null) {
                    VirtualFile file2 = this.getVirtualFile();
                    AstLoadingFilter.assertTreeLoadingAllowed(file2);
                    PsiClass[] classes = this.getClasses();
                    String fileName2 = (classes.length > 0 ? classes[0].getName() : file2.getNameWithoutExtension()) + ".java";
                    Document document = FileDocumentManager.getInstance().getDocument(file2);
                    assert (document != null) : file2.getUrl();
                    CharSequence mirrorText = document.getImmutableCharSequence();
                    boolean internalDecompiler = StringUtil.startsWith(mirrorText, BANNER);
                    PsiFileFactory factory2 = PsiFileFactory.getInstance(this.getManager().getProject());
                    PsiFile mirror = factory2.createFileFromText(fileName2, JavaLanguage.INSTANCE, mirrorText, false, false, true);
                    mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                    mirrorTreeElement = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                    try {
                        TreeElement _mirrorTreeElement = mirrorTreeElement;
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            this.setFileMirror(_mirrorTreeElement);
                            this.putUserData(CLS_DOCUMENT_LINK_KEY, document);
                        });
                    }
                    catch (ClsElementImpl.InvalidMirrorException e) {
                        LOG.error(file2.getUrl(), internalDecompiler ? e : ClsFileImpl.wrapException(e, file2));
                    }
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                    this.myMirrorFileElement = new SoftReference<TreeElement>(mirrorTreeElement);
                }
            }
        }
        PsiElement psiElement = mirrorTreeElement.getPsi();
        if (psiElement == null) {
            ClsFileImpl.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    @Override
    public String getText() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getText();
    }

    @Override
    public int getTextLength() {
        VirtualFile file2 = this.getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null) : file2.getUrl();
        return document.getTextLength();
    }

    private static Exception wrapException(ClsElementImpl.InvalidMirrorException e, VirtualFile file2) {
        PluginDescriptor plugin;
        ClassFileDecompilers.Light decompiler = ClassFileDecompilers.getInstance().find(file2, ClassFileDecompilers.Light.class);
        if (decompiler != null && (plugin = PluginManager.getPluginByClass(decompiler.getClass())) != null) {
            return new PluginException(e, plugin.getPluginId());
        }
        return e;
    }

    @Override
    @NotNull
    public PsiFile getDecompiledPsiFile() {
        PsiFile psiFile = (PsiFile)this.getMirror();
        if (psiFile == null) {
            ClsFileImpl.$$$reportNull$$$0(18);
        }
        return psiFile;
    }

    @Nullable
    public PsiFile getCachedMirror() {
        TreeElement mirrorTreeElement = ksp.com.intellij.reference.SoftReference.dereference(this.myMirrorFileElement);
        return mirrorTreeElement == null ? null : (PsiFile)mirrorTreeElement.getPsi();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsFileImpl.$$$reportNull$$$0(19);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    public String toString() {
        return "PsiFile:" + this.getName();
    }

    @Override
    public final TextRange getTextRange() {
        return TextRange.create(0, this.getTextLength());
    }

    @Override
    public final int getStartOffsetInParent() {
        return 0;
    }

    @Override
    public final PsiElement findElementAt(int offset) {
        return this.getMirror().findElementAt(offset);
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        return this.getMirror().findReferenceAt(offset);
    }

    @Override
    public final int getTextOffset() {
        return 0;
    }

    @Override
    public char @NotNull [] textToCharArray() {
        char[] cArray = this.getMirror().textToCharArray();
        if (cArray == null) {
            ClsFileImpl.$$$reportNull$$$0(20);
        }
        return cArray;
    }

    @NotNull
    public PsiClassHolderFileStub<?> getStub() {
        PsiClassHolderFileStub psiClassHolderFileStub = (PsiClassHolderFileStub)this.getStubTree().getRoot();
        if (psiClassHolderFileStub == null) {
            ClsFileImpl.$$$reportNull$$$0(21);
        }
        return psiClassHolderFileStub;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ClsFileImpl.$$$reportNull$$$0(22);
        }
        if (state == null) {
            ClsFileImpl.$$$reportNull$$$0(23);
        }
        if (place == null) {
            ClsFileImpl.$$$reportNull$$$0(24);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            for (PsiClass aClass : this.getClasses()) {
                if (processor.execute(aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = ksp.com.intellij.reference.SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                ClsFileImpl.$$$reportNull$$$0(25);
            }
            return stubTree2;
        }
        StubTreeLoader stubTreeLoader = StubTreeLoader.getInstance();
        Project project = this.getProject();
        VirtualFile virtualFile = this.getVirtualFile();
        boolean isDefault = project.isDefault();
        StubTree newStubTree = (StubTree)(isDefault ? stubTreeLoader.build(null, virtualFile, this) : stubTreeLoader.readOrBuild(project, virtualFile, this));
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file " + virtualFile.getPresentableUrl());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl(CORRUPTED_CLASS_PACKAGE, true));
        } else if (!(newStubTree.getRoot() instanceof PsiClassHolderFileStub)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid stub for class file " + virtualFile.getPresentableUrl() + ": " + newStubTree.getRoot());
            }
            newStubTree = new StubTree(new PsiJavaFileStubImpl(CORRUPTED_CLASS_PACKAGE, true));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = ksp.com.intellij.reference.SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl27 : MonitorExitStatement: MONITOREXIT : var7_7
                if (stubTree3 == null) {
                    ClsFileImpl.$$$reportNull$$$0(26);
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi(this);
            this.myStub = new SoftReference<StubTree>(stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            ClsFileImpl.$$$reportNull$$$0(27);
        }
        return stubTree4;
    }

    @Override
    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubbedSpine stubbedSpine = this.getStubTree().getSpine();
        if (stubbedSpine == null) {
            ClsFileImpl.$$$reportNull$$$0(28);
        }
        return stubbedSpine;
    }

    @Override
    public boolean isContentsLoaded() {
        return this.getCachedMirror() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = ksp.com.intellij.reference.SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("cls onContentReload");
            }
        }
        object = this.myMirrorLock;
        synchronized (object) {
            this.putUserData(CLS_DOCUMENT_LINK_KEY, null);
            this.myMirrorFileElement = null;
            this.myPackageStatement = null;
        }
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            ClsFileImpl.$$$reportNull$$$0(29);
        }
        PsiFileImpl.putInfo(this, info);
    }

    @NotNull
    public static CharSequence decompile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClsFileImpl.$$$reportNull$$$0(30);
        }
        PsiManager manager = PsiManager.getInstance(DefaultProjectFactory.getInstance().getDefaultProject());
        ClsFileImpl clsFile = new ClsFileImpl(new ClassFileViewProvider(manager, file2), true);
        StringBuilder buffer = new StringBuilder();
        ApplicationManager.getApplication().runReadAction(() -> clsFile.appendMirrorText(buffer));
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            ClsFileImpl.$$$reportNull$$$0(31);
        }
        return stringBuilder;
    }

    @Nullable
    public static PsiJavaFileStub buildFileStub(@NotNull VirtualFile file2, byte @NotNull [] bytes) throws ClsFormatException {
        if (file2 == null) {
            ClsFileImpl.$$$reportNull$$$0(32);
        }
        if (bytes == null) {
            ClsFileImpl.$$$reportNull$$$0(33);
        }
        try {
            block13: {
                LanguageLevel level;
                if (ClassFileViewProvider.isInnerClass(file2, bytes)) {
                    return null;
                }
                ClassReader reader = new ClassReader(bytes);
                String className = file2.getNameWithoutExtension();
                String internalName = reader.getClassName();
                boolean module2 = internalName.equals("module-info") && BitUtil.isSet(reader.getAccess(), 32768);
                JavaSdkVersion jdkVersion = ClsParsingUtil.getJdkVersionByBytecode(reader.readUnsignedShort(6));
                LanguageLevel languageLevel = level = jdkVersion != null ? jdkVersion.getMaxLanguageLevel() : null;
                if (level != null && level.isAtLeast(LanguageLevel.JDK_11) && ClsParsingUtil.isPreviewLevel(reader.readUnsignedShort(4))) {
                    level = ObjectUtils.notNull(level.getPreviewLevel(), LanguageLevel.HIGHEST);
                }
                if (module2) {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, "", level, true);
                    ModuleStubBuildingVisitor visitor2 = new ModuleStubBuildingVisitor(stub);
                    reader.accept(visitor2, EMPTY_ATTRIBUTES, 4);
                    if (visitor2.getResult() != null) {
                        return stub;
                    }
                } else {
                    PsiJavaFileStubImpl stub = new PsiJavaFileStubImpl(null, ClsFileImpl.getPackageName(internalName), level, true);
                    try {
                        FileContentPair source = new FileContentPair(file2, reader);
                        StubBuildingVisitor<FileContentPair> visitor3 = new StubBuildingVisitor<FileContentPair>(source, STRATEGY, stub, 0, className);
                        reader.accept(visitor3, EMPTY_ATTRIBUTES, 261);
                        if (visitor3.getResult() != null) {
                            return stub;
                        }
                    }
                    catch (OutOfOrderInnerClassException e) {
                        if (!LOG.isTraceEnabled()) break block13;
                        LOG.trace(file2.getPath());
                    }
                }
            }
            return null;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ClsFormatException(file2.getPath() + ": " + e.getMessage(), e);
        }
    }

    private static String getPackageName(String internalName) {
        int p = internalName.lastIndexOf(47);
        return p > 0 ? internalName.substring(0, p).replace('/', '.') : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/compiled/ClsFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecompiledPsiFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubTree";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "decompile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPackageName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "decompile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildFileStub";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class FileContentPair
    extends Pair<VirtualFile, ClassReader> {
        FileContentPair(@NotNull VirtualFile file2, @NotNull ClassReader content) {
            if (file2 == null) {
                FileContentPair.$$$reportNull$$$0(0);
            }
            if (content == null) {
                FileContentPair.$$$reportNull$$$0(1);
            }
            super(file2, content);
        }

        @NotNull
        public ClassReader getContent() {
            ClassReader classReader = (ClassReader)this.second;
            if (classReader == null) {
                FileContentPair.$$$reportNull$$$0(2);
            }
            return classReader;
        }

        @Override
        public String toString() {
            return ((VirtualFile)this.first).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/impl/compiled/ClsFileImpl$FileContentPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

