/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.application.impl;

import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import ksp.com.intellij.codeWithMe.ClientId;
import ksp.com.intellij.diagnostic.EventWatcher;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.application.ex.ApplicationEx;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.application.impl.BulkArrayQueue;
import ksp.com.intellij.openapi.application.impl.InvocationUtil;
import ksp.com.intellij.openapi.application.impl.LaterInvocator;
import ksp.com.intellij.openapi.application.impl.ModalityStateEx;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.diagnostic.ThrottledLogger;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.util.Condition;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.concurrency.ThreadingAssertions;
import ksp.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import ksp.it.unimi.dsi.fastutil.objects.ObjectList;
import ksp.org.jetbrains.annotations.Async;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

final class FlushQueue {
    private static final Logger LOG = Logger.getInstance(FlushQueue.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.MINUTES.toMillis(1L));
    private ObjectList<RunnableInfo> mySkippedItems = new ObjectArrayList<RunnableInfo>(100);
    private final BulkArrayQueue<RunnableInfo> myQueue = new BulkArrayQueue();
    private boolean FLUSHER_SCHEDULED;
    private final Runnable FLUSH_NOW = this::flushNow;

    FlushQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNow() {
        RunnableInfo info;
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.getQueueLock();
        synchronized (object) {
            this.FLUSHER_SCHEDULED = false;
        }
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        long startTime = System.currentTimeMillis();
        while ((info = this.pollNextEvent()) != null) {
            FlushQueue.runNextEvent(info, app);
            if (!InvocationUtil.priorityEventPending() && System.currentTimeMillis() - startTime <= 5L) continue;
            Object object2 = this.getQueueLock();
            synchronized (object2) {
                this.requestFlush();
                break;
            }
        }
    }

    private Object getQueueLock() {
        return this.myQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(@NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull Runnable runnable) {
        if (modalityState == null) {
            FlushQueue.$$$reportNull$$$0(0);
        }
        if (expired == null) {
            FlushQueue.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            FlushQueue.$$$reportNull$$$0(2);
        }
        Object object = this.getQueueLock();
        synchronized (object) {
            int queueSize = this.myQueue.size();
            RunnableInfo info = new RunnableInfo(runnable, modalityState, expired, queueSize);
            this.myQueue.enqueue(info);
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @NotNull
    Object getQueue() {
        Object object = this.getQueueLock();
        // MONITORENTER : object
        BulkArrayQueue<RunnableInfo> bulkArrayQueue = this.myQueue;
        // MONITOREXIT : object
        if (bulkArrayQueue != null) return bulkArrayQueue;
        FlushQueue.$$$reportNull$$$0(3);
        return bulkArrayQueue;
    }

    private static void doRun(@Async.Execute @NotNull RunnableInfo info, @NotNull ApplicationEx app) {
        if (info == null) {
            FlushQueue.$$$reportNull$$$0(4);
        }
        if (app == null) {
            FlushQueue.$$$reportNull$$$0(5);
        }
        try (AccessToken ignored = ClientId.withClientId(info.clientId);){
            app.runWithImplicitRead(info.runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.getQueueLock();
        synchronized (object) {
            return "LaterInvocator.FlushQueue size=" + this.myQueue.size() + "; FLUSHER_SCHEDULED=" + this.FLUSHER_SCHEDULED;
        }
    }

    @Nullable
    private RunnableInfo pollNextEvent() {
        Object object = this.getQueueLock();
        synchronized (object) {
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while (true) {
                RunnableInfo info;
                if ((info = this.myQueue.pollFirst()) == null) {
                    return null;
                }
                if (info.expired.value(null)) continue;
                if (!((ModalityState)currentModality).dominates(info.modalityState)) {
                    this.requestFlush();
                    return info;
                }
                this.mySkippedItems.add(info.wasSkipped());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void runNextEvent(@NotNull RunnableInfo info, @NotNull ApplicationEx app) {
        if (info == null) {
            FlushQueue.$$$reportNull$$$0(6);
        }
        if (app == null) {
            FlushQueue.$$$reportNull$$$0(7);
        }
        EventWatcher watcher = EventWatcher.getInstanceOrNull();
        long waitingFinishedNs = System.nanoTime();
        try {
            FlushQueue.doRun(info, app);
            if (watcher == null) return;
        }
        catch (ProcessCanceledException runnable) {
            if (watcher == null) return;
            Runnable runnable2 = info.runnable;
            long executionFinishedNs = System.nanoTime();
            long waitedInQueueNs = waitingFinishedNs - info.queuedTimeNs;
            long executionDurationNs = executionFinishedNs - waitingFinishedNs;
            long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
            long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
            watcher.runnableTaskFinished(runnable2, waitedTimeInQueueNs_safe, info.queueSize, executionDurationNs_safe, info.wasInSkippedItems);
            if (waitedInQueueNs >= 0L && executionDurationNs >= 0L) return;
            THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
            return;
        }
        catch (Throwable t) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrow(t);
            }
            LOG.error(t);
            if (watcher == null) return;
            {
                catch (Throwable throwable) {
                    if (watcher == null) throw throwable;
                    Runnable runnable3 = info.runnable;
                    long executionFinishedNs2 = System.nanoTime();
                    long waitedInQueueNs2 = waitingFinishedNs - info.queuedTimeNs;
                    long executionDurationNs2 = executionFinishedNs2 - waitingFinishedNs;
                    long waitedTimeInQueueNs_safe2 = waitedInQueueNs2 >= 0L ? waitedInQueueNs2 : 0L;
                    long executionDurationNs_safe2 = executionDurationNs2 >= 0L ? executionDurationNs2 : 0L;
                    watcher.runnableTaskFinished(runnable3, waitedTimeInQueueNs_safe2, info.queueSize, executionDurationNs_safe2, info.wasInSkippedItems);
                    if (waitedInQueueNs2 >= 0L && executionDurationNs2 >= 0L) throw throwable;
                    THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs2 + ") | executionDurationNs(" + executionDurationNs2 + ") is negative -> unexpected state");
                    throw throwable;
                }
            }
            Runnable runnable4 = info.runnable;
            long executionFinishedNs = System.nanoTime();
            long waitedInQueueNs = waitingFinishedNs - info.queuedTimeNs;
            long executionDurationNs = executionFinishedNs - waitingFinishedNs;
            long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
            long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
            watcher.runnableTaskFinished(runnable4, waitedTimeInQueueNs_safe, info.queueSize, executionDurationNs_safe, info.wasInSkippedItems);
            if (waitedInQueueNs >= 0L && executionDurationNs >= 0L) return;
            THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
            return;
        }
        Runnable runnable = info.runnable;
        long executionFinishedNs = System.nanoTime();
        long waitedInQueueNs = waitingFinishedNs - info.queuedTimeNs;
        long executionDurationNs = executionFinishedNs - waitingFinishedNs;
        long waitedTimeInQueueNs_safe = waitedInQueueNs >= 0L ? waitedInQueueNs : 0L;
        long executionDurationNs_safe = executionDurationNs >= 0L ? executionDurationNs : 0L;
        watcher.runnableTaskFinished(runnable, waitedTimeInQueueNs_safe, info.queueSize, executionDurationNs_safe, info.wasInSkippedItems);
        if (waitedInQueueNs >= 0L && executionDurationNs >= 0L) return;
        THROTTLED_LOG.info("waitedInQueueNs(" + waitedInQueueNs + ") | executionDurationNs(" + executionDurationNs + ") is negative -> unexpected state");
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reincludeSkippedItems() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.getQueueLock();
        synchronized (object) {
            int size = this.mySkippedItems.size();
            if (size != 0) {
                this.myQueue.bulkEnqueueFirst(this.mySkippedItems);
                if (size < 100) {
                    this.mySkippedItems.clear();
                } else {
                    this.mySkippedItems = new ObjectArrayList<RunnableInfo>(100);
                }
            }
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeExpiredItems() {
        ThreadingAssertions.assertEventDispatchThread();
        Object object = this.getQueueLock();
        synchronized (object) {
            this.reincludeSkippedItems();
            this.myQueue.removeAll(info -> ((RunnableInfo)info).expired.value(null));
            this.requestFlush();
        }
    }

    private void requestFlush() {
        boolean shouldSchedule;
        boolean bl = shouldSchedule = !this.FLUSHER_SCHEDULED && !this.myQueue.isEmpty();
        if (shouldSchedule) {
            this.FLUSHER_SCHEDULED = true;
            SwingUtilities.invokeLater(this.FLUSH_NOW);
        }
    }

    boolean isFlushNow(@NotNull Runnable runnable) {
        if (runnable == null) {
            FlushQueue.$$$reportNull$$$0(8);
        }
        return runnable == this.FLUSH_NOW;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runNextEvent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @NotNull
        private final String clientId;
        private final long queuedTimeNs;
        private final int queueSize;
        private final boolean wasInSkippedItems;

        @Async.Schedule
        RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, int queueSize) {
            if (runnable == null) {
                RunnableInfo.$$$reportNull$$$0(0);
            }
            if (modalityState == null) {
                RunnableInfo.$$$reportNull$$$0(1);
            }
            if (expired == null) {
                RunnableInfo.$$$reportNull$$$0(2);
            }
            this(runnable, modalityState, expired, ClientId.getCurrentValue(), queueSize, System.nanoTime(), false);
        }

        /*
         * WARNING - void declaration
         */
        @Async.Schedule
        private RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull String clientId, int queueSize, long queuedTimeNs, boolean bl) {
            void wasInSkippedItems;
            if (runnable == null) {
                RunnableInfo.$$$reportNull$$$0(3);
            }
            if (modalityState == null) {
                RunnableInfo.$$$reportNull$$$0(4);
            }
            if (expired == null) {
                RunnableInfo.$$$reportNull$$$0(5);
            }
            if (clientId == null) {
                RunnableInfo.$$$reportNull$$$0(6);
            }
            this.runnable = runnable;
            this.modalityState = modalityState;
            this.expired = expired;
            this.clientId = clientId;
            this.queuedTimeNs = queuedTimeNs;
            this.queueSize = queueSize;
            this.wasInSkippedItems = wasInSkippedItems;
        }

        public RunnableInfo wasSkipped() {
            return new RunnableInfo(this.runnable, this.modalityState, this.expired, this.clientId, this.queueSize, this.queuedTimeNs, true);
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "]{queued at: " + this.queuedTimeNs + " ns, " + this.queueSize + " items were in front of}{wasSkipped: " + this.wasInSkippedItems + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modalityState";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expired";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clientId";
                    break;
                }
            }
            objectArray[1] = "ksp/com/intellij/openapi/application/impl/FlushQueue$RunnableInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

