/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.java.parser;

import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.PsiBuilderUtil;
import ksp.com.intellij.lang.java.parser.BasicJavaParser;
import ksp.com.intellij.lang.java.parser.BasicJavaParserUtil;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import ksp.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class BasicPatternParser {
    private static final TokenSet PATTERN_MODIFIERS = TokenSet.create(JavaTokenType.FINAL_KEYWORD);
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicPatternParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicPatternParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
    }

    @Contract(pure=true)
    public boolean isPattern(PsiBuilder builder2) {
        PsiBuilder.Marker patternStart = this.preParsePattern(builder2, true);
        if (patternStart == null) {
            return false;
        }
        patternStart.rollbackTo();
        return true;
    }

    private boolean parseUnnamedPattern(PsiBuilder builder2) {
        PsiBuilder.Marker patternStart = builder2.mark();
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && "_".equals(builder2.getTokenText())) {
            BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.TYPE);
            builder2.advanceLexer();
            BasicJavaParserUtil.done(patternStart, this.myJavaElementTypeContainer.UNNAMED_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
            return true;
        }
        patternStart.rollbackTo();
        return false;
    }

    @Nullable(value="when not pattern")
    @Nullable(value="when not pattern") PsiBuilder.Marker preParsePattern(PsiBuilder builder2, boolean parensAllowed) {
        boolean isPattern;
        PsiBuilder.Marker patternStart = builder2.mark();
        if (parensAllowed) {
            while (builder2.getTokenType() == JavaTokenType.LPARENTH) {
                builder2.advanceLexer();
            }
        }
        Boolean hasNoModifier = (Boolean)this.myParser.getDeclarationParser().parseModifierList((PsiBuilder)builder2, (TokenSet)BasicPatternParser.PATTERN_MODIFIERS).second;
        PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder2, 5);
        boolean bl = isPattern = type2 != null && (builder2.getTokenType() == JavaTokenType.IDENTIFIER || builder2.getTokenType() == JavaTokenType.LPARENTH && hasNoModifier != false);
        if (!isPattern) {
            patternStart.rollbackTo();
            return null;
        }
        return patternStart;
    }

    public @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder2) {
        return this.parsePattern(builder2, false);
    }

    private @NotNull PsiBuilder.Marker parsePattern(PsiBuilder builder2, boolean expectVar) {
        PsiBuilder.Marker marker = this.parsePrimaryPattern(builder2, expectVar);
        if (marker == null) {
            BasicPatternParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @NotNull PsiBuilder.Marker parsePrimaryPattern(PsiBuilder builder2, boolean expectVar) {
        if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker parenPattern = builder2.mark();
            builder2.advanceLexer();
            this.parsePattern(builder2);
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            BasicJavaParserUtil.done(parenPattern, this.myJavaElementTypeContainer.PARENTHESIZED_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
            PsiBuilder.Marker marker = parenPattern;
            if (marker == null) {
                BasicPatternParser.$$$reportNull$$$0(2);
            }
            return marker;
        }
        return this.parseTypeOrRecordPattern(builder2, expectVar);
    }

    private void parseRecordStructurePattern(PsiBuilder builder2) {
        PsiBuilder.Marker recordStructure = builder2.mark();
        boolean hasLparen = PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH);
        assert (hasLparen);
        boolean isFirst = true;
        while (builder2.getTokenType() != JavaTokenType.RPARENTH) {
            if (!isFirst) {
                BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.COMMA, "expected.comma");
            }
            if (builder2.getTokenType() == null) break;
            if (this.isPattern(builder2)) {
                this.parsePattern(builder2, true);
                isFirst = false;
                continue;
            }
            if (this.parseUnnamedPattern(builder2)) {
                isFirst = false;
                continue;
            }
            int flags = 133;
            this.myParser.getReferenceParser().parseType(builder2, flags);
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.pattern", new Object[0]));
            if (builder2.getTokenType() == JavaTokenType.RPARENTH) break;
            builder2.advanceLexer();
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
            builder2.error(JavaPsiBundle.message("expected.rparen", new Object[0]));
        }
        recordStructure.done(this.myJavaElementTypeContainer.DECONSTRUCTION_LIST);
    }

    private @NotNull PsiBuilder.Marker parseTypeOrRecordPattern(PsiBuilder builder2, boolean expectVar) {
        boolean hasIdentifier;
        PsiBuilder.Marker pattern = builder2.mark();
        PsiBuilder.Marker patternVariable = builder2.mark();
        Boolean hasNoModifiers = (Boolean)this.myParser.getDeclarationParser().parseModifierList((PsiBuilder)builder2, (TokenSet)BasicPatternParser.PATTERN_MODIFIERS).second;
        int flags = 5;
        if (expectVar) {
            flags |= 0x80;
        }
        PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder2, flags);
        assert (type2 != null);
        boolean isRecord = false;
        if (builder2.getTokenType() == JavaTokenType.LPARENTH && hasNoModifiers.booleanValue()) {
            this.parseRecordStructurePattern(builder2);
            isRecord = true;
        }
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && (!"when".equals(builder2.getTokenText()) || BasicPatternParser.isWhenAsIdentifier(isRecord))) {
            if (isRecord) {
                PsiBuilder.Marker variable = builder2.mark();
                builder2.advanceLexer();
                variable.done(this.myJavaElementTypeContainer.DECONSTRUCTION_PATTERN_VARIABLE);
            } else {
                builder2.advanceLexer();
            }
            hasIdentifier = true;
        } else {
            hasIdentifier = false;
        }
        if (isRecord) {
            patternVariable.drop();
            BasicJavaParserUtil.done(pattern, this.myJavaElementTypeContainer.DECONSTRUCTION_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            if (hasIdentifier) {
                BasicJavaParserUtil.done(patternVariable, this.myJavaElementTypeContainer.PATTERN_VARIABLE, this.myWhiteSpaceAndCommentSetHolder);
            } else {
                patternVariable.drop();
            }
            BasicJavaParserUtil.done(pattern, this.myJavaElementTypeContainer.TYPE_TEST_PATTERN, this.myWhiteSpaceAndCommentSetHolder);
        }
        PsiBuilder.Marker marker = pattern;
        if (marker == null) {
            BasicPatternParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    private static boolean isWhenAsIdentifier(boolean previousIsRecord) {
        return !previousIsRecord;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/java/parser/BasicPatternParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/java/parser/BasicPatternParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePrimaryPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeOrRecordPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

