/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0002J \u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "extractModuleCalleeSymbols", "", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lksp/org/jetbrains/kotlin/AbstractKtSourceElement;", "checkReifiedTypeParameters", "expr", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsModuleQualifiedAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsModuleQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,62:1\n172#2,9:63\n*S KotlinDebug\n*F\n+ 1 FirJsModuleQualifiedAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsModuleQualifiedAccessChecker\n*L\n53#1:63,9\n*E\n"})
public final class FirJsModuleQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsModuleQualifiedAccessChecker INSTANCE = new FirJsModuleQualifiedAccessChecker();

    private FirJsModuleQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkReifiedTypeParameters(expression2, context2, reporter);
        List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> calleeSymbols = this.extractModuleCalleeSymbols(expression2);
        for (Pair<FirBasedSymbol<?>, AbstractKtSourceElement> pair : calleeSymbols) {
            FirBasedSymbol calleeSymbol = (FirBasedSymbol)pair.component1();
            AbstractKtSourceElement source = (AbstractKtSourceElement)pair.component2();
            AbstractKtSourceElement abstractKtSourceElement = source;
            if (abstractKtSourceElement == null) {
                abstractKtSourceElement = expression2.getSource();
            }
            FirJsModuleCheckUtilsKt.checkJsModuleUsage(calleeSymbol, context2, reporter, abstractKtSourceElement);
        }
    }

    private final List<Pair<FirBasedSymbol<?>, AbstractKtSourceElement>> extractModuleCalleeSymbols(FirQualifiedAccessExpression expression2) {
        List list;
        FirBasedSymbol calleeSymbol = FirReferenceUtilsKt.toResolvedBaseSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (calleeSymbol != null && FirHelpersKt.getContainingClassSymbol(calleeSymbol, calleeSymbol.getModuleData().getSession()) == null) {
            return CollectionsKt.listOf((Object)TuplesKt.to((Object)calleeSymbol, (Object)expression2.getCalleeReference().getSource()));
        }
        FirExpression receiver = expression2.getDispatchReceiver();
        if (receiver == null) {
            FirBasedSymbol firBasedSymbol = calleeSymbol;
            list = CollectionsKt.listOfNotNull(firBasedSymbol != null ? TuplesKt.to((Object)firBasedSymbol, (Object)expression2.getCalleeReference().getSource()) : null);
        } else if (receiver instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> classSymbol = ((FirResolvedQualifier)receiver).getSymbol();
            if (expression2 instanceof FirCallableReferenceAccess) {
                Object[] objectArray = new Pair[2];
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                objectArray[0] = firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, (Object)((FirResolvedQualifier)receiver).getSource()) : null;
                FirBasedSymbol firBasedSymbol = calleeSymbol;
                objectArray[1] = firBasedSymbol != null ? TuplesKt.to((Object)firBasedSymbol, (Object)((FirCallableReferenceAccess)expression2).getCalleeReference().getSource()) : null;
                list = CollectionsKt.listOfNotNull((Object[])objectArray);
            } else {
                FirClassLikeSymbol<?> firClassLikeSymbol = classSymbol;
                list = CollectionsKt.listOfNotNull(firClassLikeSymbol != null ? TuplesKt.to(firClassLikeSymbol, (Object)expression2.getCalleeReference().getSource()) : null);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReifiedTypeParameters(FirQualifiedAccessExpression expr, CheckerContext context2, DiagnosticReporter reporter) {
        block3: {
            FirFunctionCall firFunctionCall = expr instanceof FirFunctionCall ? (FirFunctionCall)expr : null;
            if (firFunctionCall == null) break block3;
            FirFunctionCall $this$forAllReifiedTypeParameters$iv = firFunctionCall;
            boolean $i$f$forAllReifiedTypeParameters = false;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default($this$forAllReifiedTypeParameters$iv.getCalleeReference(), false, 1, null);
            if (firNamedFunctionSymbol != null) {
                FirNamedFunctionSymbol functionSymbol$iv = firNamedFunctionSymbol;
                for (Pair pair : CollectionsKt.zip((Iterable)functionSymbol$iv.getTypeParameterSymbols(), (Iterable)$this$forAllReifiedTypeParameters$iv.getTypeArguments())) {
                    FirRegularClassSymbol typeArgumentClass;
                    void typeArgument;
                    ConeKotlinType type$iv;
                    FirTypeParameterSymbol typeParameterSymbol$iv = (FirTypeParameterSymbol)pair.component1();
                    FirTypeProjection typeArgument$iv = (FirTypeProjection)pair.component2();
                    if (!typeParameterSymbol$iv.isReified() || !(typeArgument$iv instanceof FirTypeProjectionWithVariance) || FirTypeUtilsKt.getConeTypeOrNull(((FirTypeProjectionWithVariance)typeArgument$iv).getTypeRef()) == null) continue;
                    FirTypeProjectionWithVariance firTypeProjectionWithVariance = (FirTypeProjectionWithVariance)typeArgument$iv;
                    ConeKotlinType type2 = type$iv;
                    boolean bl = false;
                    if (TypeUtilsKt.toRegularClassSymbol(type2, context2.getSession()) == null) continue;
                    KtSourceElement ktSourceElement = typeArgument.getSource();
                    if (ktSourceElement == null && (ktSourceElement = ((FirFunctionCall)expr).getCalleeReference().getSource()) == null) {
                        ktSourceElement = ((FirFunctionCall)expr).getSource();
                    }
                    KtSourceElement source = ktSourceElement;
                    FirJsModuleCheckUtilsKt.checkJsModuleUsage(typeArgumentClass, context2, reporter, source);
                }
            }
        }
    }
}

