/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\u0003H\u0002J\f\u0010\u0017\u001a\u00020\u000e*\u00020\u0003H\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0003H\u0002J&\u0010\u0019\u001a\u00020\u0007*\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0018\u0010\u0013\u001a\u00020\u000e*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasUnderlyingTypeForbiddenForLateinit", "", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "hasNullableUpperBound", "getHasNullableUpperBound", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isNullable", "hasGetter", "hasSetter", "reportError", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "target", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInapplicableLateinitChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n48#2:138\n12#2:139\n1755#3,3:140\n*S KotlinDebug\n*F\n+ 1 FirInapplicableLateinitChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker\n*L\n31#1:138\n79#1:139\n124#1:140,3\n*E\n"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();

    private FirInapplicableLateinitChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isLateInit$iv = declaration2;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit() || declaration2.getReturnTypeRef() instanceof FirErrorTypeRef) {
            return;
        }
        if (declaration2.isVal()) {
            this.reportError(reporter, declaration2.getSource(), "is allowed only on mutable properties", context2);
        }
        if (declaration2.getInitializer() != null) {
            if (declaration2.isLocal()) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on local variables with initializer", context2);
            } else {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on properties with initializer", context2);
            }
        }
        if (declaration2.getDelegate() != null) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on delegated properties", context2);
        }
        if (this.isNullable(declaration2)) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on properties of a type with nullable upper bound", context2);
        }
        if (ConeBuiltinTypeUtilsKt.isPrimitive(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()))) {
            if (declaration2.isLocal()) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on local variables of primitive types", context2);
            } else {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on properties of primitive types", context2);
            }
        }
        if (DeclarationAttributesKt.getHasExplicitBackingField(declaration2)) {
            this.reportError(reporter, declaration2.getSource(), "must be moved to the field declaration", context2);
        }
        if ((this.hasGetter(declaration2) || this.hasSetter(declaration2)) && declaration2.getDelegate() == null) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on properties with a custom getter or setter", context2);
        }
        if (FirDeclarationUtilKt.isExtension(declaration2)) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on extension properties", context2);
        }
        if (!((Collection)declaration2.getContextReceivers()).isEmpty()) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on properties with context receivers", context2);
        }
        FirMemberDeclaration $this$isAbstract$iv = declaration2;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
            this.reportError(reporter, declaration2.getSource(), "is not allowed on abstract properties", context2);
        }
        if (FirHelpersKt.isSingleFieldValueClass(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession())) {
            ConeKotlinType declarationType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession(), null, 2, null);
            String variables2 = declaration2.isLocal() ? "local variables" : "properties";
            if (ConeBuiltinTypeUtilsKt.isUnsignedType(declarationType)) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on " + variables2 + " of unsigned types", context2);
            } else if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineLateinit)) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on " + variables2 + " of inline class types", context2);
            } else if (this.hasUnderlyingTypeForbiddenForLateinit(declarationType, context2.getSession())) {
                this.reportError(reporter, declaration2.getSource(), "is not allowed on " + variables2 + " of inline type with underlying type not suitable for lateinit declaration", context2);
            }
        }
    }

    private final boolean hasUnderlyingTypeForbiddenForLateinit(ConeKotlinType type2, FirSession session) {
        if (FirHelpersKt.isRecursiveValueClassType(type2, session)) {
            return false;
        }
        return FirInapplicableLateinitChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit(session, FirHelpersKt.getInlineClassUnderlyingType(type2, session));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasNullableUpperBound(ConeKotlinType $this$hasNullableUpperBound) {
        if ($this$hasNullableUpperBound instanceof ConeTypeParameterType) {
            FirResolvedTypeRef it;
            if (ConeTypeUtilsKt.isNullable($this$hasNullableUpperBound)) return true;
            Iterable $this$any$iv = ((ConeTypeParameterType)$this$hasNullableUpperBound).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FirResolvedTypeRef)element$iv;
                boolean bl = false;
            } while (!ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(it)));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable($this$hasNullableUpperBound);
        return bl;
    }

    private final boolean isNullable(FirProperty $this$isNullable) {
        return this.getHasNullableUpperBound(FirTypeUtilsKt.getConeType($this$isNullable.getReturnTypeRef()));
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        return $this$hasGetter.getGetter() != null && !($this$hasGetter.getGetter() instanceof FirDefaultPropertyGetter);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        return $this$hasSetter.getSetter() != null && !($this$hasSetter.getSetter() instanceof FirDefaultPropertySetter);
    }

    private final void reportError(DiagnosticReporter $this$reportError, KtSourceElement source, String target, CheckerContext context2) {
        KtDiagnosticReportHelpersKt.reportOn$default($this$reportError, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), (Object)target, (DiagnosticContext)context2, null, 16, null);
    }

    private static final boolean hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit(FirSession $session, ConeKotlinType type2) {
        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(type2)) {
            return true;
        }
        if (INSTANCE.getHasNullableUpperBound(type2)) {
            return true;
        }
        if (FirHelpersKt.isSingleFieldValueClass(type2, $session)) {
            return FirInapplicableLateinitChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenTypeForLateinit($session, FirHelpersKt.getInlineClassUnderlyingType(type2, $session));
        }
        return false;
    }
}

