/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotated;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.KtWhenCondition;
import ksp.org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import ksp.org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import ksp.org.jetbrains.kotlin.psi.KtWhenEntry;
import ksp.org.jetbrains.kotlin.psi.KtWhenExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0011H\u0007J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030%2\u0006\u0010\t\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010'\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lksp/org/jetbrains/kotlin/cfg/WhenChecker;", "", "<init>", "()V", "exhaustivenessCheckers", "", "Lksp/org/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "getClassIdForEnumSubject", "Lksp/org/jetbrains/kotlin/name/ClassId;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "getClassIdForTypeIfEnum", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "getClassDescriptorOfTypeIfEnum", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptorOfTypeIfSealed", "whenSubjectType", "whenSubjectTypeWithoutSmartCasts", "getEnumMissingCases", "Lksp/org/jetbrains/kotlin/diagnostics/WhenMissingCase;", "enumClassDescriptor", "getSealedMissingCases", "sealedClassDescriptor", "getMissingCases", "isWhenExhaustive", "", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "containsNullCase", "checkDuplicatedLabels", "", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "isTrivial", "Lksp/org/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "checkDeprecatedWhenSyntax", "checkSealedWhenIsReserved", "sink", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "element", "Lksp/com/intellij/psi/PsiElement;", "frontend"})
@SourceDebugExtension(value={"SMAP\nWhenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenChecker.kt\norg/jetbrains/kotlin/cfg/WhenChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,485:1\n1#2:486\n774#3:487\n865#3,2:488\n1557#3:490\n1628#3,3:491\n*S KotlinDebug\n*F\n+ 1 WhenChecker.kt\norg/jetbrains/kotlin/cfg/WhenChecker\n*L\n342#1:487\n342#1:488,2\n344#1:490\n344#1:491,3\n*E\n"})
public final class WhenChecker {
    @NotNull
    public static final WhenChecker INSTANCE = new WhenChecker();
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    private WhenChecker() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForEnumSubject(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return WhenChecker.getClassIdForTypeIfEnum(WhenChecker.whenSubjectType(expression2, context2));
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForTypeIfEnum(@Nullable KotlinType type2) {
        ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        return classDescriptor != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor) : null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        return classDescriptor2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfSealed(@Nullable KotlinType type2) {
        Annotated annotated;
        KotlinType kotlinType = type2;
        Annotated annotated2 = kotlinType;
        if (kotlinType == null) return null;
        KotlinType it = annotated2;
        boolean bl = false;
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(it);
        annotated2 = classDescriptor;
        if (classDescriptor == null) return null;
        it = annotated = annotated2;
        boolean bl2 = false;
        if (!DescriptorUtils.isSealedClass((DeclarationDescriptor)((Object)it))) return null;
        Annotated annotated3 = annotated;
        return annotated3;
    }

    @JvmStatic
    @Nullable
    public static final KotlinType whenSubjectType(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context2.get(BindingContext.VARIABLE, subjectVariable);
            object = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else if (subjectExpression != null) {
            object = (ExplicitSmartCasts)context2.get(BindingContext.SMARTCAST, subjectExpression);
            if (object == null || (object = object.getDefaultType()) == null) {
                object = context2.getType(subjectExpression);
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final KotlinType whenSubjectTypeWithoutSmartCasts(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context2.get(BindingContext.VARIABLE, subjectVariable);
            kotlinType = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else {
            KtExpression ktExpression = subjectExpression;
            kotlinType = ktExpression != null ? context2.getType(ktExpression) : null;
        }
        return kotlinType;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)enumClassDescriptor, (String)"enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, enumClassDescriptor, false);
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getSealedMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2, @NotNull ClassDescriptor sealedClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sealedClassDescriptor, (String)"sealedClassDescriptor");
        return WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, sealedClassDescriptor, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        void $this$mapTo$iv$iv;
        WhenExhaustivenessChecker it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinType kotlinType = WhenChecker.whenSubjectType(expression2, context2);
        if (kotlinType == null) {
            return CollectionsKt.listOf((Object)WhenMissingCase.Unknown.INSTANCE);
        }
        KotlinType type2 = kotlinType;
        boolean nullable = type2.isMarkedNullable();
        Iterable $this$filter$iv = exhaustivenessCheckers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicable(type2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf((Object)WhenMissingCase.Unknown.INSTANCE);
        }
        Iterable $this$map$iv = checkers;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMissingCases(expression2, context2, TypeUtils.getClassDescriptor(type2), nullable));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        if (INSTANCE.getMissingCases(expression2, bindingContext).isEmpty()) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context2, true).isEmpty();
    }

    public final void checkDuplicatedLabels(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (expression2.getSubjectExpression() == null) {
            return;
        }
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        Map checkedConstants = new LinkedHashMap();
        Map notTrivialBranches = new LinkedHashMap();
        for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (KtWhenCondition condition : entry.getConditions()) {
                KotlinType type2;
                KtTypeReference typeReference;
                KtWhenCondition ktWhenCondition = condition;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    boolean isTrivial;
                    CompileTimeConstant<?> constant;
                    KtExpression constantExpression;
                    if (((KtWhenConditionWithExpression)condition).getExpression() == null) continue;
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    if (ConstantExpressionEvaluator.Companion.getConstant(constantExpression, bindingContext) == null) continue;
                    Boolean bl = (Boolean)checkedConstants.get(constant);
                    if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                        WhenChecker.checkDuplicatedLabels$report(trace, constantExpression);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        if (isTrivial) {
                            Object v = notTrivialBranches.remove(constant);
                            Intrinsics.checkNotNull(v);
                            KtExpression reportOn = (KtExpression)v;
                            WhenChecker.checkDuplicatedLabels$report(trace, reportOn);
                            checkedConstants.put(constant, true);
                            continue;
                        }
                        WhenChecker.checkDuplicatedLabels$report(trace, constantExpression);
                        continue;
                    }
                    if (bl == null) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        Boolean bl2 = isTrivial;
                        checkedConstants.put(constant, bl2);
                        if (isTrivial) continue;
                        notTrivialBranches.put(constant, constantExpression);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern) || ((KtWhenConditionIsPattern)condition).getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                Pair typeWithIsNegation = TuplesKt.to((Object)type2, (Object)((KtWhenConditionIsPattern)condition).isNegated());
                if (checkedTypes.contains(typeWithIsNegation)) {
                    trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(typeReference));
                    continue;
                }
                checkedTypes.add(typeWithIsNegation);
            }
        }
    }

    private final boolean isTrivial(CompileTimeConstant<?> $this$isTrivial, KtExpression expression2, LanguageVersionSettings languageVersionSettings) {
        if ($this$isTrivial.getUsesVariableAsConstant()) {
            return false;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return !ConstantExpressionEvaluator.Companion.isComplexBooleanConstant(expression2, $this$isTrivial);
        }
        return true;
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getSubjectExpression() != null) {
            return;
        }
        block0: for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNode().getElementType() == KtTokens.COMMA) {
                    trace.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                if (child.getNode().getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkSealedWhenIsReserved(@NotNull DiagnosticSink sink, @NotNull PsiElement element2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiElement psiElement = KtPsiUtil.getPreviousWord(element2, "sealed");
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            sink.report(Errors.UNSUPPORTED_SEALED_WHEN.on(it));
        }
    }

    private static final void checkDuplicatedLabels$report(BindingTrace $trace, KtExpression reportOn) {
        $trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(reportOn));
    }

    static {
        Object[] objectArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf((Object[])objectArray);
    }
}

