/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.CodegenUtil;
import ksp.org.jetbrains.kotlin.backend.common.CommonBackendContext;
import ksp.org.jetbrains.kotlin.backend.common.LoggingContext;
import ksp.org.jetbrains.kotlin.backend.common.phaser.AbstractNamedCompilerPhase;
import ksp.org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import ksp.org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.CrossFileCallAdjuster;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PerformByIrFileKt;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseConfigurationService;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import ksp.org.jetbrains.kotlin.backend.common.phaser.SameTypeCompilerPhase;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeys;
import ksp.org.jetbrains.kotlin.ir.IrFileEntry;
import ksp.org.jetbrains.kotlin.ir.LineAndColumn;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B/\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ3\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0014J;\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J0\u0010\u001a\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001c0\u001b0\u00062\u0006\u0010\u001d\u001a\u00020\u0018H\u0016R&\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase;", "Context", "Lksp/org/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lksp/org/jetbrains/kotlin/backend/common/phaser/SameTypeCompilerPhase;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "lower", "", "Lksp/org/jetbrains/kotlin/backend/common/phaser/CompilerPhase;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "copyBeforeLowering", "", "<init>", "(Ljava/util/List;Z)V", "invoke", "phaseConfig", "Lksp/org/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;", "phaserState", "Lksp/org/jetbrains/kotlin/backend/common/phaser/PhaserState;", "context", "input", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "invokeSequential", "invokeParallel", "nThreads", "", "(Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfigurationService;Lorg/jetbrains/kotlin/backend/common/phaser/PhaserState;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;I)Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getNamedSubphases", "Lkotlin/Pair;", "Lksp/org/jetbrains/kotlin/backend/common/phaser/AbstractNamedCompilerPhase;", "startDepth", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nperformByIrFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 performByIrFile.kt\norg/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1557#2:219\n1628#2,3:220\n1557#2:224\n1628#2,3:225\n1368#2:228\n1454#2,5:229\n1#3:223\n*S KotlinDebug\n*F\n+ 1 performByIrFile.kt\norg/jetbrains/kotlin/backend/common/phaser/PerformByIrFilePhase\n*L\n91#1:219\n91#1:220,3\n129#1:224\n129#1:225,3\n145#1:228\n145#1:229,5\n*E\n"})
final class PerformByIrFilePhase<Context extends CommonBackendContext>
implements SameTypeCompilerPhase<Context, IrModuleFragment> {
    @NotNull
    private final List<CompilerPhase<Context, IrFile, IrFile>> lower;
    private final boolean copyBeforeLowering;

    public PerformByIrFilePhase(@NotNull List<? extends CompilerPhase<? super Context, IrFile, IrFile>> lower2, boolean copyBeforeLowering) {
        Intrinsics.checkNotNullParameter(lower2, (String)"lower");
        this.lower = lower2;
        this.copyBeforeLowering = copyBeforeLowering;
    }

    @Override
    @NotNull
    public IrModuleFragment invoke(@NotNull PhaseConfigurationService phaseConfig, @NotNull PhaserState<IrModuleFragment> phaserState, @NotNull Context context2, @NotNull IrModuleFragment input) {
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, (String)"phaserState");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Integer n = context2.getConfiguration().get(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS);
        int nThreads = n != null ? n : 1;
        return nThreads > 1 ? this.invokeParallel(phaseConfig, phaserState, context2, input, nThreads) : this.invokeSequential(phaseConfig, phaserState, context2, input);
    }

    private final IrModuleFragment invokeSequential(PhaseConfigurationService phaseConfig, PhaserState<IrModuleFragment> phaserState, Context context2, IrModuleFragment input) {
        for (IrFile irFile : input.getFiles()) {
            try {
                PhaserState filePhaserState = CompilerPhaseKt.changePhaserStateType(phaserState);
                for (CompilerPhase<LoggingContext, IrFile, IrFile> compilerPhase : this.lower) {
                    compilerPhase.invoke(phaseConfig, filePhaserState, (LoggingContext)context2, irFile);
                }
            }
            catch (Throwable e) {
                CodegenUtil.reportBackendException$default(e, "IR lowering", irFile.getFileEntry().getName(), null, arg_0 -> PerformByIrFilePhase.invokeSequential$lambda$2(irFile, arg_0), 8, null);
                throw null;
            }
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private final IrModuleFragment invokeParallel(PhaseConfigurationService phaseConfig, PhaserState<IrModuleFragment> phaserState, Context context2, IrModuleFragment input, int nThreads) {
        IrFile irFile;
        List<IrFile> list;
        Pair $this$mapTo$iv$iv2;
        if (input.getFiles().isEmpty()) {
            return input;
        }
        AtomicReference<Object> thrownFromThread = new AtomicReference<Object>(null);
        Map remappedFiles = new LinkedHashMap();
        Map remappedFunctions = new LinkedHashMap();
        Map remappedClasses = new LinkedHashMap();
        Iterable $this$map$iv = input.getFiles();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        List<IrFile> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrFile irFile2 = (IrFile)item$iv$iv;
            list = destination$iv$iv;
            boolean bl = false;
            list.add((IrFile)(this.copyBeforeLowering ? TuplesKt.to((Object)PerformByIrFileKt.copySavingMappings((IrFile)it, remappedFiles, remappedFunctions, remappedClasses), phaserState.copyOf()) : TuplesKt.to((Object)it, phaserState.copyOf())));
        }
        List filesAndStates = destination$iv$iv;
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        for (Pair $this$mapTo$iv$iv2 : filesAndStates) {
            irFile = (IrFile)$this$mapTo$iv$iv2.component1();
            PhaserState state = (PhaserState)$this$mapTo$iv$iv2.component2();
            executor.execute(() -> PerformByIrFilePhase.invokeParallel$lambda$4(state, this, phaseConfig, context2, irFile, thrownFromThread));
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
        Object $i$f$map22 = thrownFromThread.get();
        if ($i$f$map22 != null) {
            irFile = $i$f$map22;
            boolean bl = false;
            Throwable e = (Throwable)irFile.component1();
            IrFile irFile3 = (IrFile)irFile.component2();
            CodegenUtil.reportBackendException$default(e, "Experimental parallel IR backend", irFile3.getFileEntry().getName(), null, arg_0 -> PerformByIrFilePhase.invokeParallel$lambda$8$lambda$7(irFile3, arg_0), 8, null);
            throw null;
        }
        phaserState.getAlreadyDone().addAll((Collection)((PhaserState)((Pair)filesAndStates.get(0)).getSecond()).getAlreadyDone());
        if (this.copyBeforeLowering) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            input.getFiles().clear();
            $i$f$map22 = filesAndStates;
            list = input.getFiles();
            boolean $i$f$map = false;
            irFile = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                IrFile irFile4 = (IrFile)pair.component1();
                collection.add(irFile4);
            }
            list.addAll(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2)));
            PerformByIrFileKt.access$adjustDefaultArgumentStubs(context2, remappedFunctions);
            context2.handleDeepCopy(remappedFiles, remappedClasses, remappedFunctions);
            PerformByIrFileKt.access$adjustDefaultArgumentStubs(context2, remappedFunctions);
            IrVisitorsKt.acceptChildrenVoid(input, new CrossFileCallAdjuster(remappedFunctions));
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Integer, AbstractNamedCompilerPhase<Context, ?, ?>>> getNamedSubphases(int startDepth) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.lower;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CompilerPhase it = (CompilerPhase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNamedSubphases(startDepth);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Pair invokeSequential$lambda$2(IrFile $irFile, int offset) {
        Pair pair;
        IrFileEntry irFileEntry;
        IrFileEntry it = irFileEntry = $irFile.getFileEntry();
        boolean bl = false;
        IrFileEntry irFileEntry2 = it.getSupportsDebugInfo() ? irFileEntry : null;
        if (irFileEntry2 != null) {
            it = irFileEntry2;
            boolean bl2 = false;
            LineAndColumn lineAndColumn = it.getLineAndColumnNumbers(offset);
            int line = lineAndColumn.component1();
            int column = lineAndColumn.component2();
            pair = TuplesKt.to((Object)line, (Object)column);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final void invokeParallel$lambda$4(PhaserState $state, PerformByIrFilePhase this$0, PhaseConfigurationService $phaseConfig, CommonBackendContext $context, IrFile $irFile, AtomicReference $thrownFromThread) {
        try {
            PhaserState filePhaserState = CompilerPhaseKt.changePhaserStateType($state);
            for (CompilerPhase<LoggingContext, IrFile, IrFile> compilerPhase : this$0.lower) {
                compilerPhase.invoke($phaseConfig, filePhaserState, $context, $irFile);
            }
        }
        catch (Throwable e) {
            $thrownFromThread.set(new Pair((Object)e, (Object)$irFile));
        }
    }

    private static final Pair invokeParallel$lambda$8$lambda$7(IrFile $irFile, int offset) {
        Pair pair;
        IrFileEntry irFileEntry;
        IrFileEntry it = irFileEntry = $irFile.getFileEntry();
        boolean bl = false;
        IrFileEntry irFileEntry2 = it.getSupportsDebugInfo() ? irFileEntry : null;
        if (irFileEntry2 != null) {
            it = irFileEntry2;
            boolean bl2 = false;
            LineAndColumn lineAndColumn = it.getLineAndColumnNumbers(offset);
            int line = lineAndColumn.component1();
            int column = lineAndColumn.component2();
            pair = TuplesKt.to((Object)line, (Object)column);
        } else {
            pair = null;
        }
        return pair;
    }
}

