/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.UtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeArgument;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeProjection;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrTypeTransformerVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00120\u0010\u0006\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0004\u0012\u00020\f0\bj\u0002`\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u001a\u0010\u001f\u001a\u00020\f*\b\u0012\u0004\u0012\u00020 0\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0014\u0010!\u001a\u00020\f*\u00020\"2\u0006\u0010\u0013\u001a\u00020\tH\u0002J)\u0010#\u001a\u0002H$\"\n\b\u0000\u0010$*\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0006\u001a,\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0004\u0012\u00020\f0\bj\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/IrVisibilityChecker;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrTypeTransformerVoid;", "module", "Lksp/org/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "file", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "reportError", "Lksp/org/jetbrains/kotlin/backend/common/ReportIrValidationError;", "Lkotlin/Function4;", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "", "", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function4;)V", "Lkotlin/jvm/functions/Function4;", "parentChain", "", "visibilityError", "element", "visibility", "Lksp/org/jetbrains/kotlin/descriptors/Visibility;", "visitElement", "isVisibleAsInternal", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "isVisibleAsPrivate", "checkVisibility", "referencedDeclarationSymbol", "Lksp/org/jetbrains/kotlin/ir/symbols/IrSymbol;", "reference", "checkVisibilities", "Lksp/org/jetbrains/kotlin/ir/types/IrTypeArgument;", "checkVisibilitiesInType", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "transformType", "Type", "container", "type", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrType;", "visitDeclarationReference", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrVisibilityChecker.kt\norg/jetbrains/kotlin/backend/common/IrVisibilityChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class IrVisibilityChecker
extends IrTypeTransformerVoid {
    @NotNull
    private final IrModuleFragment module;
    @NotNull
    private final IrFile file;
    @NotNull
    private final Function4<IrFile, IrElement, String, List<? extends IrElement>, Unit> reportError;
    @NotNull
    private final List<IrElement> parentChain;

    public IrVisibilityChecker(@NotNull IrModuleFragment module2, @NotNull IrFile file2, @NotNull Function4<? super IrFile, ? super IrElement, ? super String, ? super List<? extends IrElement>, Unit> reportError) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(reportError, (String)"reportError");
        this.module = module2;
        this.file = file2;
        this.reportError = reportError;
        this.parentChain = new ArrayList();
    }

    private final void visibilityError(IrElement element2, Visibility visibility) {
        String message = "The following element references " + (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Unknown.INSTANCE) ? "a declaration with unknown visibility:" : '\'' + visibility.getName() + "' declaration that is invisible in the current scope:");
        this.reportError.invoke((Object)this.file, (Object)element2, (Object)message, this.parentChain);
    }

    @Override
    public void visitElement(@NotNull IrElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        UtilsKt.push(this.parentChain, element2);
        IrVisitorsKt.acceptChildrenVoid(element2, this);
        UtilsKt.pop(this.parentChain);
    }

    private final boolean isVisibleAsInternal(IrDeclarationWithVisibility $this$isVisibleAsInternal) {
        IrPackageFragment referencedDeclarationPackageFragment = IrUtilsKt.getPackageFragment($this$isVisibleAsInternal);
        if (referencedDeclarationPackageFragment.getSymbol() instanceof DescriptorlessExternalPackageFragmentSymbol) {
            return Intrinsics.areEqual((Object)this.module.getName().asString(), (Object)"<kotlin>");
        }
        return this.module.getDescriptor().shouldSeeInternalsOf(IrPackageFragmentsKt.getModuleDescriptor(referencedDeclarationPackageFragment));
    }

    private final boolean isVisibleAsPrivate(IrDeclarationWithVisibility $this$isVisibleAsPrivate) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$isVisibleAsPrivate);
        return Intrinsics.areEqual((Object)this.file.getFileEntry(), (Object)(irFile != null ? irFile.getFileEntry() : null));
    }

    /*
     * Unable to fully structure code
     */
    private final void checkVisibility(IrSymbol referencedDeclarationSymbol, IrElement reference) {
        var5_3 = referencedDeclarationSymbol.getOwner();
        v0 = var5_3 instanceof IrDeclarationWithVisibility != false ? (IrDeclarationWithVisibility)var5_3 : null;
        if (v0 == null) {
            return;
        }
        referencedDeclaration = v0;
        classOfReferenced = IrUtilsKt.getParentClassOrNull(referencedDeclaration);
        visibility = referencedDeclaration.getVisibility().getDelegate();
        v1 = classOfReferenced;
        var8_6 = referencedDeclaration;
        var12_7 = true;
        var11_8 = v1 != null ? v1.getSymbol() : null;
        var10_9 = visibility;
        $i$a$-run-IrVisibilityChecker$checkVisibility$effectiveVisibility$1 = false;
        if (IrVisibilityChecker.checkVisibility$isPublishedApi((IrAnnotationContainer)$this$checkVisibility_u24lambda_u240)) ** GOTO lbl-1000
        if ($this$checkVisibility_u24lambda_u240 instanceof IrSimpleFunction) {
            v2 = ((IrSimpleFunction)$this$checkVisibility_u24lambda_u240).getCorrespondingPropertySymbol();
            v3 = v2 != null && (v2 = (IrProperty)v2.getOwner()) != null ? IrVisibilityChecker.checkVisibility$isPublishedApi((IrAnnotationContainer)v2) : false;
            ** if (!v3) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v4 = true;
            ** GOTO lbl23
        }
lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
lbl23:
        // 2 sources

        var13_11 = v4;
        effectiveVisibility = EffectiveVisibilityKt.toEffectiveVisibilityOrNull(var10_9, var11_8, var12_7, var13_11);
        var8_6 = effectiveVisibility;
        if (var8_6 instanceof EffectiveVisibility.Internal || var8_6 instanceof EffectiveVisibility.InternalProtected || var8_6 instanceof EffectiveVisibility.InternalProtectedBound) {
            v5 = this.isVisibleAsInternal(referencedDeclaration);
        } else if (var8_6 instanceof EffectiveVisibility.Local || var8_6 instanceof EffectiveVisibility.PrivateInClass || var8_6 instanceof EffectiveVisibility.PrivateInFile) {
            v5 = this.isVisibleAsPrivate(referencedDeclaration);
        } else if (var8_6 instanceof EffectiveVisibility.PackagePrivate || var8_6 instanceof EffectiveVisibility.Protected || var8_6 instanceof EffectiveVisibility.ProtectedBound || var8_6 instanceof EffectiveVisibility.Public) {
            v5 = true;
        } else if (var8_6 instanceof EffectiveVisibility.Unknown || var8_6 == null) {
            v5 = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        isVisible = v5;
        if (!isVisible) {
            this.visibilityError(reference, visibility);
        }
    }

    private final void checkVisibilities(List<? extends IrTypeArgument> $this$checkVisibilities, IrElement element2) {
        for (IrTypeArgument irTypeArgument : $this$checkVisibilities) {
            Object object = irTypeArgument instanceof IrTypeProjection ? (IrTypeProjection)irTypeArgument : null;
            if (object == null || (object = object.getType()) == null) continue;
            this.checkVisibilitiesInType((IrType)object, element2);
        }
    }

    private final void checkVisibilitiesInType(IrType $this$checkVisibilitiesInType, IrElement element2) {
        if ($this$checkVisibilitiesInType instanceof IrSimpleType) {
            this.checkVisibility(((IrSimpleType)$this$checkVisibilitiesInType).getClassifier(), element2);
            this.checkVisibilities(((IrSimpleType)$this$checkVisibilitiesInType).getArguments(), element2);
        }
    }

    @Override
    public <Type extends IrType> Type transformType(@NotNull IrElement container, Type type2) {
        Type Type2;
        block0: {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Type it = Type2 = type2;
            boolean bl = false;
            Type Type3 = it;
            if (Type3 == null) break block0;
            this.checkVisibilitiesInType(Type3, container);
        }
        return Type2;
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.checkVisibility(expression2.getSymbol(), expression2);
        super.visitDeclarationReference(expression2);
    }

    private static final boolean checkVisibility$isPublishedApi(IrAnnotationContainer $this$checkVisibility_u24isPublishedApi) {
        return IrUtilsKt.hasAnnotation($this$checkVisibility_u24isPublishedApi, StandardClassIds.Annotations.INSTANCE.getPublishedApi());
    }
}

