/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.api.components.KaTypeInfoProvider;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import ksp.org.jetbrains.kotlin.analysis.api.fir.types.KaFirType;
import ksp.org.jetbrains.kotlin.analysis.api.fir.types.PublicTypeApproximator;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.api.types.KaType;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KaFirTypeInfoProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/components/KaTypeInfoProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "isFunctionalInterfaceType", "", "type", "Lksp/org/jetbrains/kotlin/analysis/api/types/KaType;", "getFunctionClassKind", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "canBeNull", "isDenotable", "isArrayOrPrimitiveArray", "isNestedArray", "fullyExpandedType", "analysis-api-fir"})
public final class KaFirTypeInfoProvider
extends KaTypeInfoProvider
implements KaFirSessionComponent {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;

    public KaFirTypeInfoProvider(@NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KaFirSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KaLifetimeToken getToken() {
        return this.token;
    }

    @Override
    public boolean isFunctionalInterfaceType(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KaFirType)((Object)type2)).getConeType();
        FirSession firSession = this.getAnalysisSession().getUseSiteSession$analysis_api_fir();
        FirSamResolver samResolver = new FirSamResolver(firSession, this.getAnalysisSession().getScopeSessionFor(firSession), null, 4, null);
        return samResolver.isSamType(coneType);
    }

    @Override
    @Nullable
    public FunctionTypeKind getFunctionClassKind(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return FunctionalTypeUtilsKt.functionTypeKind(((KaFirType)((Object)type2)).getConeType(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    @Override
    public boolean canBeNull(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return TypeUtilsKt.canBeNull(((KaFirType)((Object)type2)).getConeType(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
    }

    @Override
    public boolean isDenotable(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneType = ((KaFirType)((Object)type2)).getConeType();
        return TypeComponentsKt.getTypeApproximator(this.getAnalysisSession().getUseSiteSession$analysis_api_fir()).approximateToSuperType(coneType, (TypeApproximatorConfiguration)new PublicTypeApproximator.PublicApproximatorConfiguration(false)) == null;
    }

    @Override
    public boolean isArrayOrPrimitiveArray(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof KaFirType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ArrayUtilsKt.isArrayOrPrimitiveArray(((KaFirType)((Object)type2)).getConeType());
    }

    @Override
    public boolean isNestedArray(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!this.isArrayOrPrimitiveArray(type2)) {
            return false;
        }
        if (!(type2 instanceof KaFirType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default(((KaFirType)((Object)type2)).getConeType(), false, 1, null);
        return coneKotlinType != null ? ArrayUtilsKt.isArrayOrPrimitiveArray(coneKotlinType) : false;
    }

    @Override
    @NotNull
    public KaType fullyExpandedType(@NotNull KaType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return this.asKtType(TypeExpansionUtilsKt.fullyExpandedType$default(this.getConeType(type2), this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), null, 2, null));
    }
}

