/*
 * Decompiled with CFR 0.152.
 */
package ksp.javaslang.control;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ksp.javaslang.Value;
import ksp.javaslang.collection.Iterator;
import ksp.javaslang.collection.LinearSeq;
import ksp.javaslang.collection.List;
import ksp.javaslang.collection.Seq;
import ksp.javaslang.control.Either;

public interface Try<T>
extends Value<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Try<T> of(CheckedSupplier<? extends T> supplier) {
        try {
            return new Success(supplier.get());
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    public static Try<Void> run(CheckedRunnable runnable) {
        try {
            runnable.run();
            return new Success<Void>(null);
        }
        catch (Throwable t) {
            return new Failure<Void>(t);
        }
    }

    public static <T> Try<Seq<T>> sequence(Iterable<? extends Try<? extends T>> values2) {
        Objects.requireNonNull(values2, "values is null");
        LinearSeq list = List.empty();
        for (Try<T> value2 : values2) {
            if (value2.isFailure()) {
                return Try.failure(value2.getCause());
            }
            list = list.prepend((Object)value2.get());
        }
        return Try.success(list.reverse());
    }

    public static <T> Try<T> success(T value2) {
        return new Success(value2);
    }

    public static <T> Try<T> failure(Throwable exception) {
        return new Failure(exception);
    }

    public static <T> Try<T> narrow(Try<? extends T> t) {
        return t;
    }

    default public Try<T> andThen(Consumer<? super T> consumer2) {
        Objects.requireNonNull(consumer2, "consumer is null");
        return this.andThenTry(consumer2::accept);
    }

    default public Try<T> andThenTry(CheckedConsumer<? super T> consumer2) {
        Objects.requireNonNull(consumer2, "consumer is null");
        if (this.isFailure()) {
            return this;
        }
        try {
            consumer2.accept(this.get());
            return this;
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public Try<T> andThen(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable is null");
        return this.andThenTry(runnable::run);
    }

    default public Try<T> andThenTry(CheckedRunnable runnable) {
        Objects.requireNonNull(runnable, "runnable is null");
        if (this.isFailure()) {
            return this;
        }
        try {
            runnable.run();
            return this;
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public Try<Throwable> failed() {
        if (this.isFailure()) {
            return new Success<Throwable>(this.getCause());
        }
        return new Failure<Throwable>(new NoSuchElementException("Success.failed()"));
    }

    default public Try<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.filterTry(predicate::test);
    }

    default public Try<T> filterTry(CheckedPredicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isFailure()) {
            return this;
        }
        try {
            if (predicate.test(this.get())) {
                return this;
            }
            return new Failure(new NoSuchElementException("Predicate does not hold for " + this.get()));
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public <U> Try<U> flatMap(Function<? super T, ? extends Try<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.flatMapTry(mapper::apply);
    }

    default public <U> Try<U> flatMapTry(CheckedFunction<? super T, ? extends Try<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isFailure()) {
            return (Failure)this;
        }
        try {
            return mapper.apply(this.get());
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    @Override
    public T get();

    public Throwable getCause();

    @Override
    public boolean isEmpty();

    public boolean isFailure();

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    public boolean isSuccess();

    @Override
    default public Iterator<T> iterator() {
        return this.isSuccess() ? Iterator.of(this.get()) : Iterator.empty();
    }

    @Override
    default public <U> Try<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.mapTry(mapper::apply);
    }

    default public <U> Try<U> mapTry(CheckedFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isFailure()) {
            return (Failure)this;
        }
        try {
            return new Success(mapper.apply(this.get()));
        }
        catch (Throwable t) {
            return new Failure(t);
        }
    }

    default public Try<T> onFailure(Consumer<? super Throwable> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isFailure()) {
            action.accept(this.getCause());
        }
        return this;
    }

    default public Try<T> onSuccess(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isSuccess()) {
            action.accept(this.get());
        }
        return this;
    }

    default public Try<T> orElse(Try<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.isSuccess() ? this : other;
    }

    default public Try<T> orElse(Supplier<? extends Try<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return this.isSuccess() ? this : supplier.get();
    }

    default public T getOrElseGet(Function<? super Throwable, ? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        if (this.isFailure()) {
            return other.apply(this.getCause());
        }
        return this.get();
    }

    default public void orElseRun(Consumer<? super Throwable> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isFailure()) {
            action.accept(this.getCause());
        }
    }

    default public <X extends Throwable> T getOrElseThrow(Function<? super Throwable, X> exceptionProvider) throws X {
        Objects.requireNonNull(exceptionProvider, "exceptionProvider is null");
        if (this.isFailure()) {
            throw (Throwable)exceptionProvider.apply(this.getCause());
        }
        return this.get();
    }

    @Override
    default public Try<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (this.isSuccess()) {
            action.accept(this.get());
        }
        return this;
    }

    default public Try<T> recover(Function<? super Throwable, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isFailure()) {
            return Try.of(() -> f.apply(this.getCause()));
        }
        return this;
    }

    default public Try<T> recoverWith(Function<? super Throwable, ? extends Try<? extends T>> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isFailure()) {
            try {
                return f.apply(this.getCause());
            }
            catch (Throwable t) {
                return new Failure(t);
            }
        }
        return this;
    }

    default public Either<Throwable, T> toEither() {
        if (this.isFailure()) {
            return Either.left(this.getCause());
        }
        return Either.right(this.get());
    }

    default public <U> U transform(Function<? super Try<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    @Override
    public String toString();

    public static final class NonFatalException
    extends RuntimeException
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NonFatalException(Throwable exception) {
            super(exception);
        }

        static NonFatalException of(Throwable exception) {
            boolean isFatal;
            Objects.requireNonNull(exception, "exception is null");
            if (exception instanceof NonFatalException) {
                return (NonFatalException)exception;
            }
            if (exception instanceof FatalException) {
                throw (FatalException)exception;
            }
            boolean bl = isFatal = exception instanceof InterruptedException || exception instanceof LinkageError || exception instanceof ThreadDeath || exception instanceof VirtualMachineError;
            if (isFatal) {
                throw new FatalException(exception);
            }
            return new NonFatalException(exception);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof NonFatalException && Arrays.deepEquals(this.getCause().getStackTrace(), ((NonFatalException)o).getCause().getStackTrace());
        }

        public int hashCode() {
            return Objects.hashCode(this.getCause());
        }

        @Override
        public String toString() {
            return "NonFatal(" + this.getCause() + ")";
        }
    }

    public static final class FatalException
    extends RuntimeException
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private FatalException(Throwable exception) {
            super(exception);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FatalException && Arrays.deepEquals(this.getCause().getStackTrace(), ((FatalException)o).getCause().getStackTrace());
        }

        public int hashCode() {
            return Objects.hashCode(this.getCause());
        }

        @Override
        public String toString() {
            return "Fatal(" + this.getCause() + ")";
        }
    }

    public static final class Failure<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final NonFatalException cause;

        private Failure(Throwable exception) {
            Objects.requireNonNull(exception, "exception is null");
            this.cause = NonFatalException.of(exception);
        }

        @Override
        public T get() throws NonFatalException {
            throw this.cause;
        }

        @Override
        public Throwable getCause() {
            return this.cause.getCause();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Failure && Objects.equals(this.cause, ((Failure)obj).cause);
        }

        @Override
        public String stringPrefix() {
            return "Failure";
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.cause.getCause());
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "(" + this.cause.getCause() + ")";
        }
    }

    public static final class Success<T>
    implements Try<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T value;

        private Success(T value2) {
            this.value = value2;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Throwable getCause() {
            throw new UnsupportedOperationException("getCause on Success");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Success && Objects.equals(this.value, ((Success)obj).value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String stringPrefix() {
            return "Success";
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "(" + this.value + ")";
        }
    }

    @FunctionalInterface
    public static interface CheckedSupplier<R> {
        public R get() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedPredicate<T> {
        public boolean test(T var1) throws Throwable;

        default public CheckedPredicate<T> negate() {
            return t -> !this.test(t);
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

