/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.text.StringUtilRt;
import ksp.com.intellij.util.ThreeState;
import ksp.com.intellij.util.lang.UrlUtilRt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JRT_PROTOCOL = "jrt";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern URL_WITH_PARENS_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;()]*[-A-Za-z0-9+$&@#/%=~_|()]");
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\b(file:///)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");

    private URLUtil() {
    }

    public static boolean canContainUrl(@NotNull String line) {
        if (line == null) {
            URLUtil.$$$reportNull$$$0(0);
        }
        return line.contains("mailto:") || line.contains(SCHEME_SEPARATOR) || line.contains("www.");
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(1);
        }
        if (!(protocol = url.getProtocol()).equals(JAR_PROTOCOL)) {
            InputStream inputStream = url.openStream();
            if (inputStream == null) {
                URLUtil.$$$reportNull$$$0(2);
            }
            return inputStream;
        }
        Pair<String, String> paths2 = URLUtil.splitJarUrl(url.getFile());
        if (paths2 == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile((String)paths2.first);
        ZipEntry zipEntry = zipFile.getEntry((String)paths2.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths2.second + " not found in " + (String)paths2.first);
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(3);
        }
        try {
            return URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file2 = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file2 = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file2 = url.getFile().substring(pos + 1);
            }
            if (file2 != null && file2.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file2)) != null) {
                InputStream inputStream = resourceStream;
                if (inputStream == null) {
                    URLUtil.$$$reportNull$$$0(4);
                }
                return inputStream;
            }
            throw ex;
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static ThreeState resourceExists(@NotNull URL url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(5);
        }
        if (url.getProtocol().equals(FILE_PROTOCOL)) {
            ThreeState threeState = ThreeState.fromBoolean(URLUtil.urlToFile(url).exists());
            if (threeState == null) {
                URLUtil.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        if (url.getProtocol().equals(JAR_PROTOCOL)) {
            Pair<String, String> paths2 = URLUtil.splitJarUrl(url.getFile());
            if (paths2 == null) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    URLUtil.$$$reportNull$$$0(7);
                }
                return threeState;
            }
            if (!new File((String)paths2.first).isFile()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    URLUtil.$$$reportNull$$$0(8);
                }
                return threeState;
            }
            ZipFile file2 = new ZipFile((String)paths2.first);
            ThreeState threeState = ThreeState.fromBoolean(file2.getEntry((String)paths2.second) != null);
            file2.close();
            ThreeState threeState2 = threeState;
            if (threeState2 == null) {
                URLUtil.$$$reportNull$$$0(9);
            }
            return threeState2;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            file2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        ThreeState threeState3 = ThreeState.NO;
                        if (threeState3 == null) {
                            URLUtil.$$$reportNull$$$0(10);
                        }
                        return threeState3;
                    }
                }
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            URLUtil.$$$reportNull$$$0(11);
        }
        return threeState;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block7: {
            int pivot;
            if (url == null) {
                URLUtil.$$$reportNull$$$0(12);
            }
            if ((pivot = url.indexOf(JAR_SEPARATOR)) < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (jarPath.startsWith("jar:")) {
                jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
            }
            if (jarPath.startsWith(FILE_PROTOCOL)) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring(FILE_PROTOCOL.length());
                    if (jarPath.startsWith(SCHEME_SEPARATOR)) {
                        jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
                    }
                    if (jarPath.length() == 0 || jarPath.charAt(0) != ':') break block7;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return new Pair<String, String>(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(13);
        }
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url + "'", e);
        }
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(14);
        }
        String string2 = URLUtil.unescapePercentSequences(s, 0, s.length()).toString();
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from2, int end) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(16);
        }
        CharSequence charSequence = UrlUtilRt.unescapePercentSequences(s, from2, end);
        if (charSequence == null) {
            URLUtil.$$$reportNull$$$0(17);
        }
        return charSequence;
    }

    public static boolean containsScheme(@NotNull String url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(18);
        }
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(@NotNull String value2) {
        if (value2 == null) {
            URLUtil.$$$reportNull$$$0(19);
        }
        return !value2.isEmpty() && value2.startsWith("data:", value2.charAt(0) == '\"' || value2.charAt(0) == '\'' ? 1 : 0);
    }

    public static byte @Nullable [] getBytesFromDataUri(@NotNull String dataUrl) {
        Matcher matcher;
        if (dataUrl == null) {
            URLUtil.$$$reportNull$$$0(20);
        }
        if ((matcher = DATA_URI_PATTERN.matcher(StringUtilRt.unquoteString(dataUrl))).matches()) {
            try {
                String content = matcher.group(4);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64.getDecoder().decode(content) : URLUtil.decode(content).getBytes(StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static String decode(@NotNull String string2) {
        String string3;
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(21);
        }
        try {
            string3 = URLDecoder.decode(string2, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ignore) {
            String string4 = URLDecoder.decode(string2);
            if (string4 == null) {
                URLUtil.$$$reportNull$$$0(23);
            }
            return string4;
        }
        if (string3 == null) {
            URLUtil.$$$reportNull$$$0(22);
        }
        return string3;
    }

    @NotNull
    public static String parseHostFromSshUrl(@NotNull String sshUrl) {
        String host;
        int at;
        if (sshUrl == null) {
            URLUtil.$$$reportNull$$$0(24);
        }
        if ((at = (host = sshUrl).lastIndexOf(64)) > 0) {
            host = host.substring(at + 1);
        } else {
            int firstColon = host.indexOf(SCHEME_SEPARATOR);
            if (firstColon > 0) {
                host = host.substring(firstColon + 3);
            }
        }
        int colon = host.indexOf(58);
        if (colon > 0) {
            host = host.substring(0, colon);
        } else {
            int slash = host.indexOf(47);
            if (slash > 0) {
                host = host.substring(0, slash);
            }
        }
        String string2 = host;
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(25);
        }
        return string2;
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file2, @NotNull String pathInJar) throws MalformedURLException {
        int index;
        if (file2 == null) {
            URLUtil.$$$reportNull$$$0(26);
        }
        if (pathInJar == null) {
            URLUtil.$$$reportNull$$$0(27);
        }
        String fileURL = file2.toURI().toASCIIString().replace("!", "%21");
        for (index = 0; index < pathInJar.length() && pathInJar.charAt(index) == '/'; ++index) {
        }
        return new URL("jar:" + fileURL + JAR_SEPARATOR + pathInJar.substring(index));
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String s) {
        String string2;
        if (s == null) {
            URLUtil.$$$reportNull$$$0(28);
        }
        try {
            string2 = URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            String string3 = s;
            if (string3 == null) {
                URLUtil.$$$reportNull$$$0(30);
            }
            return string3;
        }
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(29);
        }
        return string2;
    }

    @Nullable
    public static TextRange findUrl(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (text == null) {
            URLUtil.$$$reportNull$$$0(31);
        }
        Matcher m = URL_WITH_PARENS_PATTERN.matcher(text);
        m.region(startOffset, endOffset);
        if (!m.find()) {
            return null;
        }
        int start = m.start();
        int end = m.end();
        int unmatchedPos = 0;
        int unmatchedCount = 0;
        for (int i = m.end(1); i < end; ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                if (unmatchedCount++ != 0) continue;
                unmatchedPos = i;
                continue;
            }
            if (c != ')' || unmatchedCount-- != 0) continue;
            return new TextRange(start, i);
        }
        if (unmatchedCount > 0) {
            return new TextRange(start, unmatchedPos);
        }
        return new TextRange(start, end);
    }

    @Nullable
    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(32);
        }
        return UrlUtilRt.internProtocol(url);
    }

    @NotNull
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        return url == null ? "" : URLUtil.extractPath(url);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        int index;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(33);
        }
        String string2 = (index = url.indexOf(SCHEME_SEPARATOR)) >= 0 ? url.substring(index + SCHEME_SEPARATOR.length()) : url;
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(34);
        }
        return string2;
    }

    public static String encodePath(String path) {
        try {
            return new URI(null, null, path, null, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            return path;
        }
    }

    public static String encodeQuery(String query) {
        try {
            return new URI(null, null, null, query, null).toASCIIString().substring(1);
        }
        catch (URISyntaxException e) {
            return query;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 18: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/URLUtil";
                break;
            }
            case 14: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshUrl";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_PROTOCOL;
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/URLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openResourceStream";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceExists";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePercentSequences";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHostFromSshUrl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeURIComponent";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canContainUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openResourceStream";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resourceExists";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "unescapePercentSequences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDataUri";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBytesFromDataUri";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseHostFromSshUrl";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getJarEntryURL";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "encodeURIComponent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

