/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaCodeFragment;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiThisExpression;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.impl.source.Constants;
import ksp.com.intellij.psi.impl.source.PsiClassReferenceType;
import ksp.com.intellij.psi.impl.source.PsiImmediateClassType;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiThisExpressionImpl
extends ExpressionPsiElement
implements PsiThisExpression,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiThisExpressionImpl.class);

    public PsiThisExpressionImpl() {
        super(THIS_EXPRESSION);
    }

    @Override
    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier2 = this.getQualifier();
        if (qualifier2 != null) {
            PsiElement qualifierResolve = qualifier2.resolve();
            if (qualifierResolve instanceof PsiClass) {
                return new PsiImmediateClassType((PsiClass)qualifierResolve, PsiSubstitutor.EMPTY);
            }
            return new PsiClassReferenceType(qualifier2, null);
        }
        for (PsiElement scope = this.getContext(); scope != null; scope = scope.getContext()) {
            PsiType fragmentThisType;
            if (scope instanceof PsiClass) {
                PsiClass aClass = (PsiClass)scope;
                return new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
            }
            if (scope instanceof PsiExpressionList && scope.getParent() instanceof PsiAnonymousClass) {
                scope = scope.getParent();
                continue;
            }
            if (!(scope instanceof JavaCodeFragment) || (fragmentThisType = ((JavaCodeFragment)scope).getThisType()) == null) continue;
            return fragmentThisType;
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                if (this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 95: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiThisExpressionImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == THIS_KEYWORD) {
            return 95;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiThisExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitThisExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiThisExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiThisExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

