/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtAnnotationEntry;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/PublishedApiUsageChecker;", "", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class PublishedApiUsageChecker {
    @NotNull
    public static final PublishedApiUsageChecker INSTANCE = new PublishedApiUsageChecker();

    private PublishedApiUsageChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility) || Intrinsics.areEqual((Object)((DeclarationDescriptorWithVisibility)descriptor2).getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        for (KtAnnotationEntry entry : declaration2.getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor;
            if ((AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry) == null || !Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)StandardNames.FqNames.publishedApi)) continue;
            trace.report(Errors.NON_INTERNAL_PUBLISHED_API.on((KtAnnotationEntry)((PsiElement)entry)));
        }
    }
}

