/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DelegationResolver;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.OverridingUtil;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/DelegationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDescriptor", "classDeclaration", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "delegatedDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "delegatedToDescriptor", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDelegationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DelegationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n774#3:77\n865#3,2:78\n774#3:80\n865#3,2:81\n*S KotlinDebug\n*F\n+ 1 DelegationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DelegationChecker\n*L\n58#1:77\n58#1:78,2\n61#1:80\n61#1:81,2\n*E\n"})
public final class DelegationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry specifier : ((KtClassOrObject)declaration2).getSuperTypeListEntries()) {
            ClassDescriptor superTypeDescriptor;
            Object superType;
            ClassifierDescriptor classifierDescriptor;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Object object = ((KtDelegatedSuperTypeEntry)specifier).getTypeReference();
            if (object == null) continue;
            KtTypeReference it = object;
            boolean bl = false;
            KotlinType kotlinType = (KotlinType)context2.getTrace().get(BindingContext.TYPE, it);
            object = kotlinType;
            if (kotlinType == null || ((classifierDescriptor = ((KotlinType)(superType = object)).getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null) == null) continue;
            superTypeDescriptor = superTypeDescriptor;
            for (Map.Entry entry : DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, (ClassDescriptor)descriptor2, superTypeDescriptor, null, 4, null).entrySet()) {
                CallableMemberDescriptor delegated = (CallableMemberDescriptor)entry.getKey();
                CallableMemberDescriptor delegatedTo = (CallableMemberDescriptor)entry.getValue();
                this.checkDescriptor((KtClassOrObject)declaration2, delegated, delegatedTo, context2.getTrace());
            }
        }
    }

    private final void checkDescriptor(KtClassOrObject classDeclaration, CallableMemberDescriptor delegatedDescriptor, CallableMemberDescriptor delegatedToDescriptor, DiagnosticSink diagnosticHolder) {
        CallableMemberDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatedDescriptor);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllOverriddenDescriptors(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.getKind().isReal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set set2 = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue(set2, (String)"filterOutOverridden(...)");
        Set reachableFromDelegated = SetsKt.minus(set2, (Object)DescriptorUtils.unwrapFakeOverride(delegatedToDescriptor).getOriginal());
        $this$filter$iv = reachableFromDelegated;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.OPEN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonAbstractReachable = (List)destination$iv$iv;
        if (!((Collection)nonAbstractReachable).isEmpty()) {
            diagnosticHolder.report(Errors.DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE.on((KtClassOrObject)((PsiElement)classDeclaration), delegatedDescriptor, nonAbstractReachable));
        }
    }
}

