/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeRefinement;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import ksp.org.jetbrains.kotlin.types.checker.NewCapturedTypeConstructor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/inference/CapturedTypeConstructorImpl;", "Lksp/org/jetbrains/kotlin/resolve/calls/inference/CapturedTypeConstructor;", "projection", "Lksp/org/jetbrains/kotlin/types/TypeProjection;", "<init>", "(Lorg/jetbrains/kotlin/types/TypeProjection;)V", "getProjection", "()Lorg/jetbrains/kotlin/types/TypeProjection;", "newTypeConstructor", "Lksp/org/jetbrains/kotlin/types/checker/NewCapturedTypeConstructor;", "getNewTypeConstructor", "()Lorg/jetbrains/kotlin/types/checker/NewCapturedTypeConstructor;", "setNewTypeConstructor", "(Lorg/jetbrains/kotlin/types/checker/NewCapturedTypeConstructor;)V", "getParameters", "", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "isFinal", "", "isDenotable", "getDeclarationDescriptor", "", "toString", "", "getBuiltIns", "Lksp/org/jetbrains/kotlin/builtins/KotlinBuiltIns;", "refine", "kotlinTypeRefiner", "Lksp/org/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "descriptors"})
public final class CapturedTypeConstructorImpl
implements CapturedTypeConstructor {
    @NotNull
    private final TypeProjection projection;
    @Nullable
    private NewCapturedTypeConstructor newTypeConstructor;

    public CapturedTypeConstructorImpl(@NotNull TypeProjection projection) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        this.projection = projection;
        boolean bl2 = bl = this.getProjection().getProjectionKind() != Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Only nontrivial projections can be captured, not: " + this.getProjection();
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    @NotNull
    public TypeProjection getProjection() {
        return this.projection;
    }

    @Nullable
    public final NewCapturedTypeConstructor getNewTypeConstructor() {
        return this.newTypeConstructor;
    }

    public final void setNewTypeConstructor(@Nullable NewCapturedTypeConstructor newCapturedTypeConstructor) {
        this.newTypeConstructor = newCapturedTypeConstructor;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        KotlinType kotlinType = this.getProjection().getProjectionKind() == Variance.OUT_VARIANCE ? this.getProjection().getType() : (KotlinType)this.getBuiltIns().getNullableAnyType();
        Intrinsics.checkNotNull((Object)kotlinType);
        KotlinType superType = kotlinType;
        return CollectionsKt.listOf((Object)superType);
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    @NotNull
    public String toString() {
        return "CapturedTypeConstructor(" + this.getProjection() + ')';
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = this.getProjection().getType().getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"getBuiltIns(...)");
        return kotlinBuiltIns;
    }

    @Override
    @TypeRefinement
    @NotNull
    public CapturedTypeConstructorImpl refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        TypeProjection typeProjection = this.getProjection().refine(kotlinTypeRefiner);
        Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"refine(...)");
        return new CapturedTypeConstructorImpl(typeProjection);
    }
}

