/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.Named;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/ResultTypeWithNullableOperatorsChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ResultTypeWithNullableOperatorsChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResult)) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        Name name2 = ((Named)resolvedCall2.getResultingDescriptor()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        ASTNode operationNode = resolvedCall2.getCall().getCallOperationNode();
        ASTNode aSTNode = operationNode;
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.SAFE_ACCESS)) {
            Object obj = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
            Object resultingDescriptor = obj;
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null && (receiverParameterDescriptor = resultingDescriptor.getDispatchReceiverParameter()) == null) {
                return;
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (ResultClassInReturnTypeCheckerKt.isResultType(kotlinType)) {
                BindingTrace bindingTrace = context2.getTrace();
                ASTNode aSTNode2 = operationNode;
                Intrinsics.checkNotNull((Object)aSTNode2);
                bindingTrace.report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(aSTNode2.getPsi(), "?."));
            }
        } else if (Intrinsics.areEqual((Object)name3, (Object)ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL.getSpecialFunctionName())) {
            KotlinType kotlinType = resolvedCall2.getResultingDescriptor().getReturnType();
            boolean bl = kotlinType != null ? ResultClassInReturnTypeCheckerKt.isResultType(kotlinType) : false;
            if (bl) {
                context2.getTrace().report(Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "!!"));
            }
        } else if (Intrinsics.areEqual((Object)name3, (Object)ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName())) {
            KtElement ktElement = resolvedCall2.getCall().getCallElement();
            KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
            KtExpression ktExpression = elvisBinaryExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            KtExpression left = ktExpression;
            KotlinType kotlinType = context2.getTrace().getType(left);
            if (kotlinType == null) {
                return;
            }
            KotlinType leftType = kotlinType;
            if (ResultClassInReturnTypeCheckerKt.isResultType(leftType)) {
                BindingTrace bindingTrace = context2.getTrace();
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            }
            if (left instanceof KtBinaryExpression) {
                KtExpression ktExpression2 = ((KtBinaryExpression)left).getRight();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression lastExpression = ktExpression2;
                KotlinType kotlinType2 = context2.getTrace().getType(lastExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType lastExpressionType = kotlinType2;
                if (ResultClassInReturnTypeCheckerKt.isResultType(lastExpressionType)) {
                    BindingTrace bindingTrace = context2.getTrace();
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.RESULT_CLASS_WITH_NULLABLE_OPERATOR.on(reportOn, "?:");
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"on(...)");
                    DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
                }
            }
        }
    }
}

