/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom;

import ksp.org.jdom.Content;
import ksp.org.jdom.Element;
import ksp.org.jdom.IllegalDataException;
import ksp.org.jdom.IllegalNameException;
import ksp.org.jdom.Parent;
import ksp.org.jdom.Verifier;

public class EntityRef
extends Content {
    private static final long serialVersionUID = 200L;
    protected String name;
    protected String publicID;
    protected String systemID;

    protected EntityRef() {
        super(Content.CType.EntityRef);
    }

    public EntityRef(String name2) {
        this(name2, null, null);
    }

    public EntityRef(String name2, String systemID) {
        this(name2, null, systemID);
    }

    public EntityRef(String name2, String publicID, String systemID) {
        super(Content.CType.EntityRef);
        this.setName(name2);
        this.setPublicID(publicID);
        this.setSystemID(systemID);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return "";
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public EntityRef setName(String name2) {
        String reason = Verifier.checkXMLName(name2);
        if (reason != null) {
            throw new IllegalNameException(name2, "EntityRef", reason);
        }
        this.name = name2;
        return this;
    }

    public EntityRef setPublicID(String publicID) {
        String reason = Verifier.checkPublicID(publicID);
        if (reason != null) {
            throw new IllegalDataException(publicID, "EntityRef", reason);
        }
        this.publicID = publicID;
        return this;
    }

    public EntityRef setSystemID(String systemID) {
        String reason = Verifier.checkSystemLiteral(systemID);
        if (reason != null) {
            throw new IllegalDataException(systemID, "EntityRef", reason);
        }
        this.systemID = systemID;
        return this;
    }

    public String toString() {
        return "[EntityRef: " + "&" + this.name + ";" + "]";
    }

    @Override
    public EntityRef detach() {
        return (EntityRef)super.detach();
    }

    @Override
    protected EntityRef setParent(Parent parent2) {
        return (EntityRef)super.setParent(parent2);
    }

    @Override
    public Element getParent() {
        return (Element)super.getParent();
    }

    @Override
    public EntityRef clone() {
        return (EntityRef)super.clone();
    }
}

