/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.util.Chunk;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.graph.CachingSemiGraph;
import ksp.com.intellij.util.graph.DFSTBuilder;
import ksp.com.intellij.util.graph.Graph;
import ksp.com.intellij.util.graph.GraphAlgorithms;
import ksp.com.intellij.util.graph.GraphGenerator;
import ksp.com.intellij.util.graph.InboundSemiGraph;
import ksp.com.intellij.util.graph.impl.Bfs;
import ksp.com.intellij.util.graph.impl.CycleFinder;
import ksp.com.intellij.util.graph.impl.Dfs;
import ksp.com.intellij.util.graph.impl.KShortestPathsFinder;
import ksp.com.intellij.util.graph.impl.ShortestPathFinder;
import ksp.com.intellij.util.graph.impl.SimpleCyclesIterator;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class GraphAlgorithmsImpl
extends GraphAlgorithms {
    @Override
    @NotNull
    public <Node> Collection<Node> findNodesWhichBelongToAnyPathBetweenTwoNodes(@NotNull Graph<Node> graph2, @NotNull Node start, @NotNull Node finish) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(0);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(2);
        }
        HashSet reachableFromStart = new HashSet();
        HashSet leadToFinish = new HashSet();
        Dfs.performDfs(graph2, start, reachableFromStart::add);
        Dfs.performDfs(this.invertEdgeDirections(graph2), finish, leadToFinish::add);
        Collection collection = ContainerUtil.intersection(reachableFromStart, leadToFinish);
        if (collection == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public <Node> Collection<Node> findNodeNeighbourhood(@NotNull Graph<Node> graph2, @NotNull Node node, int levelBound) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(4);
        }
        if (node == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(5);
        }
        HashSet neighbourhood = new HashSet();
        Bfs.performBfs(graph2, node, (neighbour, level) -> {
            if (level <= levelBound) {
                neighbourhood.add(neighbour);
            }
        });
        HashSet hashSet = neighbourhood;
        if (hashSet == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    @Nullable
    public <Node> List<Node> findShortestPath(@NotNull InboundSemiGraph<Node> graph2, @NotNull Node start, @NotNull Node finish) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(7);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(8);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(9);
        }
        return new ShortestPathFinder<Node>(graph2).findPath(start, finish);
    }

    @Override
    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph2, @NotNull Node start, @NotNull Node finish, int k, @NotNull ProgressIndicator progressIndicator) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(10);
        }
        if (start == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(11);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(12);
        }
        if (progressIndicator == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(13);
        }
        List<List<Node>> list = new KShortestPathsFinder<Node>(graph2, start, finish, progressIndicator).findShortestPaths(k);
        if (list == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph2, @NotNull Node node) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(15);
        }
        if (node == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(16);
        }
        Set<List<Node>> set = new CycleFinder<Node>(graph2).getNodeCycles(node);
        if (set == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Override
    public <Node> void iterateOverAllSimpleCycles(@NotNull Graph<Node> graph2, @NotNull Consumer<? super List<Node>> cycleConsumer) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(18);
        }
        if (cycleConsumer == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(19);
        }
        new SimpleCyclesIterator<Node>(graph2).iterateSimpleCycles(cycleConsumer);
    }

    @Override
    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(20);
        }
        return new Graph<Node>(){

            @Override
            @NotNull
            public Collection<Node> getNodes() {
                Collection collection = graph2.getNodes();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @Override
            @NotNull
            public Iterator<Node> getIn(Node n) {
                Iterator iterator2 = graph2.getOut(n);
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            @Override
            @NotNull
            public Iterator<Node> getOut(Node n) {
                Iterator iterator2 = graph2.getIn(n);
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "ksp/com/intellij/util/graph/impl/GraphAlgorithmsImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(21);
        }
        DFSTBuilder<Node> builder2 = new DFSTBuilder<Node>(graph2);
        Collection<Collection<Node>> components = builder2.getComponents();
        final ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(components.size());
        final LinkedHashMap<Node, Chunk<Node>> nodeToChunkMap = new LinkedHashMap<Node, Chunk<Node>>();
        for (Collection<Node> component : components) {
            Set<Node> chunkNodes = component.size() == 1 ? Collections.singleton(component.iterator().next()) : new LinkedHashSet<Node>(component);
            Chunk<Node> chunk = new Chunk<Node>(chunkNodes);
            chunks.add(chunk);
            for (Node node : component) {
                nodeToChunkMap.put(node, chunk);
            }
        }
        Graph<Chunk<Node>> graph3 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Chunk<Node>>(){

            @Override
            @NotNull
            public Collection<Chunk<Node>> getNodes() {
                List list = chunks;
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @NotNull
            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet<Chunk> ins = new LinkedHashSet<Chunk>();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph2.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add((Chunk)nodeToChunkMap.get(in));
                    }
                }
                Iterator iterator2 = ins.iterator();
                if (iterator2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "ksp/com/intellij/util/graph/impl/GraphAlgorithmsImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph3 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(22);
        }
        return graph3;
    }

    @Override
    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph2, Node start, Set<? super Node> set) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(23);
        }
        if (!set.add(start)) {
            return;
        }
        ArrayList<Node> stack = new ArrayList<Node>();
        stack.add(start);
        while (!stack.isEmpty()) {
            Object currentNode = stack.remove(stack.size() - 1);
            Iterator<Node> successorIterator = graph2.getOut(currentNode);
            while (successorIterator.hasNext()) {
                Node successor = successorIterator.next();
                if (!set.add(successor)) continue;
                stack.add(successor);
            }
        }
    }

    @Override
    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(24);
        }
        Collection<Chunk<Node>> collection = this.computeSCCGraph(graph2).getNodes();
        if (collection == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Override
    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<? extends List<Node>> paths2) {
        if (paths2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(26);
        }
        ArrayList<List<Node>> result2 = new ArrayList<List<Node>>();
        for (List<Node> path : paths2) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result2.add(path);
        }
        ArrayList<List<Node>> arrayList = result2;
        if (arrayList == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 27: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cycleConsumer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findNodesWhichBelongToAnyPathBetweenTwoNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findNodeNeighbourhood";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findKShortestPaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSCCGraph";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStronglyConnectedComponents";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "removePathsWithCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findNodesWhichBelongToAnyPathBetweenTwoNodes";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 27: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findNodeNeighbourhood";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findShortestPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findKShortestPaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCycles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverAllSimpleCycles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invertEdgeDirections";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeSCCGraph";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectOutsRecursively";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "computeStronglyConnectedComponents";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removePathsWithCycles";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

