/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import ksp.com.intellij.openapi.util.text.StringUtilRt;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.util.containers.HashingStrategy;

final class CharSequenceHashingStrategy
implements HashingStrategy<CharSequence> {
    private final boolean myCaseSensitive;
    static final CharSequenceHashingStrategy CASE_SENSITIVE_INSTANCE = new CharSequenceHashingStrategy(true);
    static final CharSequenceHashingStrategy CASE_INSENSITIVE_INSTANCE = new CharSequenceHashingStrategy(false);

    CharSequenceHashingStrategy(boolean sensitive) {
        this.myCaseSensitive = sensitive;
    }

    @Override
    public int hashCode(CharSequence object) {
        return this.myCaseSensitive ? Strings.stringHashCode(object) : Strings.stringHashCodeInsensitive(object);
    }

    @Override
    public boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal(s1, s2, this.myCaseSensitive);
    }
}

