/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import ksp.com.intellij.psi.stubs.Hash;

final class StrippedIntOpenHashMap {
    private transient int[] key;
    private transient int[] value;
    private transient int mask;
    private transient boolean containsNull;
    private transient int nullValue;
    private transient int n;
    private transient int maxFill;
    private final transient int minN;
    private int size;
    private final float f;

    private StrippedIntOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = Hash.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = Hash.maxFill(this.n, f);
        this.key = new int[this.n + 1];
        this.value = new int[this.n + 1];
    }

    StrippedIntOpenHashMap() {
        this(16, 0.75f);
    }

    private int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    public void put(int k, int v) {
        assert (v != 0);
        int[] key = this.key;
        if (k == 0) {
            this.nullValue = v;
            this.containsNull = true;
        } else {
            int pos = Hash.mix(k) & this.mask;
            int curr = key[pos];
            if (curr != 0) {
                if (curr == k) {
                    this.value[pos] = v;
                    return;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (curr != k) continue;
                    this.value[pos] = v;
                    return;
                }
            }
            key[pos] = k;
            this.value[pos] = v;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(Hash.arraySize(this.size + 1, this.f));
        }
        assert (this.get(k, -1) == v && this.get(k, 0) == v);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void rehash(int newN) {
        int[] key = this.key;
        int[] value2 = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int[] newValue = new int[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0) {
            }
            int pos = Hash.mix(key[i]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value2[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = Hash.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        for (i = 0; i < key.length; ++i) {
            int k = key[i];
            int v = value2[i];
            assert (k == 0 || this.get(k, -1) == v);
        }
    }

    public int get(int k, int absentValue) {
        if (k == 0) {
            return this.containsNull ? this.nullValue : absentValue;
        }
        int[] key = this.key;
        int pos = Hash.mix(k) & this.mask;
        int curr = this.value[pos];
        if (curr == 0) {
            return absentValue;
        }
        if (k == key[pos]) {
            return curr;
        }
        do {
            if ((curr = this.value[pos = pos + 1 & this.mask]) != 0) continue;
            return absentValue;
        } while (k != key[pos]);
        return curr;
    }
}

