/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.stubs;

import java.io.IOException;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.LanguageFileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.stubs.BinaryFileStubBuilder;
import ksp.com.intellij.psi.stubs.BinaryFileStubBuilders;
import ksp.com.intellij.psi.stubs.ObjectStubTree;
import ksp.com.intellij.psi.stubs.PsiFileStub;
import ksp.com.intellij.psi.stubs.Stub;
import ksp.com.intellij.psi.stubs.StubTree;
import ksp.com.intellij.psi.stubs.StubTreeBuilder;
import ksp.com.intellij.psi.stubs.StubTreeLoader;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.com.intellij.psi.tree.IStubFileElementType;
import ksp.com.intellij.util.indexing.FileContent;
import ksp.com.intellij.util.indexing.FileContentImpl;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class CoreStubTreeLoader
extends StubTreeLoader {
    @Override
    public ObjectStubTree<?> readOrBuild(@NotNull Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (project == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(1);
        }
        if (!this.canHaveStub(vFile)) {
            return null;
        }
        return this.build(project, vFile, psiFile);
    }

    @Override
    @Nullable
    public ObjectStubTree<?> build(@Nullable Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(2);
        }
        try {
            FileContent fc = FileContentImpl.createByFile(vFile, project);
            Stub element2 = StubTreeBuilder.buildStubTree(fc);
            if (element2 instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public ObjectStubTree<?> readFromVFile(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
    }

    @Override
    public boolean canHaveStub(VirtualFile file2) {
        FileType fileType = file2.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            return elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file2);
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder2 != null && builder2.acceptsFile(file2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/stubs/CoreStubTreeLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readOrBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromVFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

