/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.org.objectweb.asm.tree;

import java.util.List;
import ksp.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import ksp.org.jetbrains.org.objectweb.asm.Attribute;
import ksp.org.jetbrains.org.objectweb.asm.ClassVisitor;
import ksp.org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import ksp.org.jetbrains.org.objectweb.asm.TypePath;
import ksp.org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.TypeAnnotationNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.UnsupportedClassVersionException;
import ksp.org.jetbrains.org.objectweb.asm.tree.Util;

public class RecordComponentNode
extends RecordComponentVisitor {
    public String name;
    public String descriptor;
    public String signature;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;

    public RecordComponentNode(String name2, String descriptor2, String signature) {
        this(589824, name2, descriptor2, signature);
        if (this.getClass() != RecordComponentNode.class) {
            throw new IllegalStateException();
        }
    }

    public RecordComponentNode(int api, String name2, String descriptor2, String signature) {
        super(api);
        this.name = name2;
        this.descriptor = descriptor2;
        this.signature = signature;
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationNode annotation2 = new AnnotationNode(descriptor2);
        if (visible) {
            this.visibleAnnotations = Util.add(this.visibleAnnotations, annotation2);
        } else {
            this.invisibleAnnotations = Util.add(this.invisibleAnnotations, annotation2);
        }
        return annotation2;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, typePath, descriptor2);
        if (visible) {
            this.visibleTypeAnnotations = Util.add(this.visibleTypeAnnotations, typeAnnotation);
        } else {
            this.invisibleTypeAnnotations = Util.add(this.invisibleTypeAnnotations, typeAnnotation);
        }
        return typeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        this.attrs = Util.add(this.attrs, attribute);
    }

    public void visitEnd() {
    }

    public void check(int api) {
        if (api < 524288) {
            throw new UnsupportedClassVersionException();
        }
    }

    public void accept(ClassVisitor classVisitor2) {
        TypeAnnotationNode typeAnnotation;
        AnnotationNode annotation2;
        int i;
        int n;
        RecordComponentVisitor recordComponentVisitor = classVisitor2.visitRecordComponent(this.name, this.descriptor, this.signature);
        if (recordComponentVisitor == null) {
            return;
        }
        if (this.visibleAnnotations != null) {
            n = this.visibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                annotation2 = this.visibleAnnotations.get(i);
                annotation2.accept(recordComponentVisitor.visitAnnotation(annotation2.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n = this.invisibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                annotation2 = this.invisibleAnnotations.get(i);
                annotation2.accept(recordComponentVisitor.visitAnnotation(annotation2.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i = 0; i < n; ++i) {
                typeAnnotation = this.visibleTypeAnnotations.get(i);
                typeAnnotation.accept(recordComponentVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i = 0; i < n; ++i) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i);
                typeAnnotation.accept(recordComponentVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
        if (this.attrs != null) {
            n = this.attrs.size();
            for (i = 0; i < n; ++i) {
                recordComponentVisitor.visitAttribute(this.attrs.get(i));
            }
        }
        recordComponentVisitor.visitEnd();
    }
}

