/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JvmStaticChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "supportJvmStaticInInterface", "", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkForInterface", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\ndeclarationCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 declarationCheckers.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class JvmStaticChecker
implements DeclarationChecker {
    private final boolean supportJvmStaticInInterface;

    public JvmStaticChecker(@NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.supportJvmStaticInInterface = languageVersionSettings2.supportsFeature(LanguageFeature.JvmStaticInInterface);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2) && (declaration2 instanceof KtNamedFunction || declaration2 instanceof KtProperty || declaration2 instanceof KtPropertyAccessor || declaration2 instanceof KtParameter)) {
            this.checkDeclaration(declaration2, descriptor2, context2.getTrace());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        container = descriptor.getContainingDeclaration();
        insideObject = DescriptorUtils.isObject(container);
        if (!DescriptorUtils.isCompanionObject(container)) ** GOTO lbl-1000
        v0 = container;
        Intrinsics.checkNotNull((Object)v0);
        if (DescriptorUtils.isInterface(v0.getContainingDeclaration())) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = insideCompanionObjectInInterface = false;
        }
        if (!insideObject || insideCompanionObjectInInterface) {
            if (insideCompanionObjectInInterface && this.supportJvmStaticInInterface && descriptor instanceof DeclarationDescriptorWithVisibility) {
                this.checkForInterface((DeclarationDescriptorWithVisibility)descriptor, diagnosticHolder, declaration);
            } else {
                diagnosticHolder.report((this.supportJvmStaticInInterface != false ? ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_COMPANION : ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT_OR_CLASS_COMPANION).on((KtDeclaration)((PsiElement)declaration)));
            }
        }
        if (declaration instanceof KtPropertyAccessor) {
            v2 = declaration.getParent();
            Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            v3 = (KtProperty)v2;
        } else {
            v3 = checkDeclaration = declaration;
        }
        if (DescriptorUtils.isNonCompanionObject(container)) {
            v4 = checkDeclaration.getModifierList();
            v5 = v4 != null ? v4.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false;
            if (v5) {
                diagnosticHolder.report(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((KtDeclaration)((PsiElement)declaration)));
            }
        }
        if (descriptor instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor).isConst() || JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor))) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_CONST_OR_JVM_FIELD.on((KtDeclaration)((PsiElement)declaration)));
        }
    }

    private final void checkForInterface(DeclarationDescriptorWithVisibility descriptor2, DiagnosticSink diagnosticHolder, KtDeclaration declaration2) {
        block3: {
            PropertyAccessorDescriptor it;
            block4: {
                block2: {
                    if (Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PUBLIC)) break block2;
                    diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_NON_PUBLIC_MEMBER.on((KtDeclaration)((PsiElement)declaration2)));
                    break block3;
                }
                if (!(descriptor2 instanceof MemberDescriptor) || !((MemberDescriptor)descriptor2).isExternal()) break block4;
                diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_EXTERNAL_IN_INTERFACE.on((KtDeclaration)((PsiElement)declaration2)));
                break block3;
            }
            if (!(descriptor2 instanceof PropertyDescriptor)) break block3;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
            if (propertyGetterDescriptor != null) {
                it = propertyGetterDescriptor;
                boolean bl = false;
                this.checkForInterface(it, diagnosticHolder, declaration2);
            }
            PropertySetterDescriptor propertySetterDescriptor = ((PropertyDescriptor)descriptor2).getSetter();
            if (propertySetterDescriptor != null) {
                it = propertySetterDescriptor;
                boolean bl = false;
                this.checkForInterface(it, diagnosticHolder, declaration2);
            }
        }
    }
}

