/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J.\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JavaTypeAccessibilityChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "findInaccessibleJavaClasses", "", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "findInaccessibleJavaClassesRec", "scopeOwner", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "inaccessibleClasses", "", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
public final class JavaTypeAccessibilityChecker
implements AdditionalTypeChecker {
    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType2, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Collection<ClassDescriptor> inaccessibleClassesWithSmartCast;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType2, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.isDebuggerContext) {
            return;
        }
        Collection<ClassDescriptor> inaccessibleClasses = this.findInaccessibleJavaClasses(expressionType2, c);
        if (!inaccessibleClasses.isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression2), expressionType2, inaccessibleClasses));
            return;
        }
        if (!Intrinsics.areEqual((Object)expressionTypeWithSmartCast, (Object)expressionType2) && !(inaccessibleClassesWithSmartCast = this.findInaccessibleJavaClasses(expressionTypeWithSmartCast, c)).isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression2), expressionType2, inaccessibleClassesWithSmartCast));
        }
    }

    private final Collection<ClassDescriptor> findInaccessibleJavaClasses(KotlinType type2, ResolutionContext<?> c) {
        DeclarationDescriptor scopeOwner = c.scope.getOwnerDescriptor();
        LinkedHashSet inaccessibleJavaClasses = new LinkedHashSet();
        Collection collection = inaccessibleJavaClasses;
        LanguageVersionSettings languageVersionSettings2 = c.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.findInaccessibleJavaClassesRec(type2, scopeOwner, collection, languageVersionSettings2);
        return inaccessibleJavaClasses;
    }

    private final void findInaccessibleJavaClassesRec(KotlinType type2, DeclarationDescriptor scopeOwner, Collection<ClassDescriptor> inaccessibleClasses, LanguageVersionSettings languageVersionSettings2) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof JavaClassDescriptor && !DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((Object)declarationDescriptor), scopeOwner, languageVersionSettings2)) {
            inaccessibleClasses.add((ClassDescriptor)declarationDescriptor);
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection()) continue;
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            this.findInaccessibleJavaClassesRec(kotlinType, scopeOwner, inaccessibleClasses, languageVersionSettings2);
        }
    }
}

