/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import ksp.org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import ksp.org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsDataFlowExtras;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import ksp.org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsTypeChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
public final class RuntimeAssertionsTypeChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final RuntimeAssertionsTypeChecker INSTANCE = new RuntimeAssertionsTypeChecker();

    private RuntimeAssertionsTypeChecker() {
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType2, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType2, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (TypeUtils.noExpectedType(c.expectedType) || c.expectedType instanceof StubTypeForBuilderInference) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        RuntimeAssertionInfo assertionInfo = RuntimeAssertionInfo.Companion.create(kotlinType, expressionType2, new RuntimeAssertionsDataFlowExtras(c, expressionType2, expression2));
        if (assertionInfo != null) {
            c.trace.record(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2, assertionInfo);
        }
    }
}

