/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValue;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import ksp.org.jetbrains.kotlin.resolve.jvm.ConstantsChecker;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"getCompileTimeConstant", "Lksp/org/jetbrains/kotlin/resolve/constants/ConstantValue;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "takeUpConstValsAsConst", "", "shouldInlineConstVals", "frontend.java"})
public final class JvmConstantsKt {
    @Nullable
    public static final ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext, boolean takeUpConstValsAsConst, boolean shouldInlineConstVals) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        if (compileTimeValue == null || compileTimeValue.getUsesNonConstValAsConstant()) {
            return null;
        }
        if (!shouldInlineConstVals && !takeUpConstValsAsConst && compileTimeValue.getUsesVariableAsConstant()) {
            ConstantsChecker constantChecker = new ConstantsChecker(bindingContext);
            expression2.accept(constantChecker);
            if (constantChecker.getContainsKotlinConstVals()) {
                return null;
            }
        }
        KotlinType kotlinType = bindingContext.getType(expression2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType expectedType = kotlinType;
        return compileTimeValue.toConstantValue(expectedType);
    }
}

