/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/ResultClassInReturnTypeChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isForbiddenReturnType", "", "returnType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "declarationDescriptor", "frontend"})
public final class ResultClassInReturnTypeChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LanguageVersionSettings languageVersionSettings2 = context2.getLanguageVersionSettings();
        if ((languageVersionSettings2.getFeatureSupport(LanguageFeature.InlineClasses) == LanguageFeature.State.ENABLED || languageVersionSettings2.supportsFeature(LanguageFeature.JvmInlineValueClasses)) && languageVersionSettings2.supportsFeature(LanguageFeature.AllowResultInReturnType)) {
            return;
        }
        if (languageVersionSettings2.supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        if (!(declaration2 instanceof KtCallableDeclaration) || !(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        if (this.isForbiddenReturnType(returnType2, declaration2, descriptor2)) {
            PsiElement psiElement;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration2).getTypeReference();
            if (ktTypeReference != null) {
                psiElement = ktTypeReference;
            } else {
                psiElement = ((KtCallableDeclaration)declaration2).getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
            }
            PsiElement typeReferenceOrDeclarationName = psiElement;
            BindingTrace bindingTrace = context2.getTrace();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.RESULT_CLASS_IN_RETURN_TYPE.on(typeReferenceOrDeclarationName);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private final boolean isForbiddenReturnType(KotlinType returnType2, KtDeclaration declaration2, DeclarationDescriptor declarationDescriptor) {
        if (!ResultClassInReturnTypeCheckerKt.isResultType(returnType2)) {
            return false;
        }
        if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof PropertyGetterDescriptor) {
            if (declaration2 instanceof KtProperty) {
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration2).getGetter();
                boolean bl = ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
                if (bl) {
                    return true;
                }
            }
            DescriptorVisibility descriptorVisibility = ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"getVisibility(...)");
            DescriptorVisibility visibility2 = descriptorVisibility;
            return !DescriptorVisibilities.isPrivate(visibility2) && !Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.LOCAL);
        }
        return true;
    }
}

