/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.AnalysisFlags;
import ksp.org.jetbrains.kotlin.config.ExplicitApiMode;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.descriptors.Visibility;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtCodeFragment;
import ksp.org.jetbrains.kotlin.psi.KtConstructor;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtFunctionLiteral;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/ExplicitApiDeclarationChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkExplicitReturnType", "state", "Lksp/org/jetbrains/kotlin/config/ExplicitApiMode;", "checkVisibilityModifier", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "Companion", "frontend"})
public final class ExplicitApiDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ExplicitApiMode state = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (state == ExplicitApiMode.DISABLED) {
            return;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithVisibility)) {
            return;
        }
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
            return;
        }
        if (!DescriptorUtilsKt.isEffectivelyPublicApi((DeclarationDescriptorWithVisibility)descriptor2) && !DescriptorUtilsKt.isPublishedApi(descriptor2)) {
            return;
        }
        this.checkVisibilityModifier(state, declaration2, (DeclarationDescriptorWithVisibility)descriptor2, context2);
        this.checkExplicitReturnType(state, declaration2, descriptor2, context2);
    }

    private final void checkVisibilityModifier(ExplicitApiMode state, KtDeclaration declaration2, DeclarationDescriptorWithVisibility descriptor2, DeclarationCheckerContext context2) {
        PsiElement modifier = KtPsiUtilKt.visibilityModifier(declaration2);
        if (modifier != null) {
            return;
        }
        if (Companion.explicitVisibilityIsNotRequired(descriptor2)) {
            return;
        }
        DiagnosticFactory0<KtDeclaration> diagnostic = state == ExplicitApiMode.STRICT ? Errors.NO_EXPLICIT_VISIBILITY_IN_API_MODE : Errors.NO_EXPLICIT_VISIBILITY_IN_API_MODE_WARNING;
        BindingTrace bindingTrace = context2.getTrace();
        SimpleDiagnostic<KtDeclaration> simpleDiagnostic = diagnostic.on((KtDeclaration)((PsiElement)declaration2));
        Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
        DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
    }

    private final void checkExplicitReturnType(ExplicitApiMode state, KtDeclaration declaration2, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2) {
        if (!(declaration2 instanceof KtCallableDeclaration)) {
            return;
        }
        if (!Companion.returnTypeCheckIsApplicable((KtCallableDeclaration)declaration2)) {
            return;
        }
        boolean shouldReport = Companion.returnTypeRequired((KtCallableDeclaration)declaration2, descriptor2, true, false, false);
        if (shouldReport) {
            DiagnosticFactory0<KtNamedDeclaration> diagnostic = state == ExplicitApiMode.STRICT ? Errors.NO_EXPLICIT_RETURN_TYPE_IN_API_MODE : Errors.NO_EXPLICIT_RETURN_TYPE_IN_API_MODE_WARNING;
            BindingTrace bindingTrace = context2.getTrace();
            SimpleDiagnostic<KtNamedDeclaration> simpleDiagnostic = diagnostic.on((KtNamedDeclaration)declaration2);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ0\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/ExplicitApiDeclarationChecker$Companion;", "", "()V", "explicitVisibilityIsNotRequired", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "publicReturnTypeShouldBePresentInApiMode", "element", "Lksp/org/jetbrains/kotlin/psi/KtCallableDeclaration;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "returnTypeCheckIsApplicable", "returnTypeRequired", "checkForPublicApi", "checkForInternal", "checkForPrivate", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean explicitVisibilityIsNotRequired(@NotNull DeclarationDescriptor descriptor2) {
            Object object;
            DeclarationDescriptor declarationDescriptor;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            ClassConstructorDescriptor classConstructorDescriptor = descriptor2 instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)descriptor2 : null;
            boolean bl = classConstructorDescriptor != null ? classConstructorDescriptor.isPrimary() : false;
            if (bl) {
                return true;
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                boolean bl2 = classDescriptor2 != null ? classDescriptor2.isData() : false;
                if (bl2) {
                    return true;
                }
            }
            boolean bl3 = (object = descriptor2 instanceof CallableDescriptor ? (CallableDescriptor)descriptor2 : null) != null && (object = object.getOverriddenDescriptors()) != null ? !object.isEmpty() : false;
            if (bl3) {
                return true;
            }
            if (descriptor2 instanceof PropertyAccessorDescriptor) {
                return true;
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                declarationDescriptor = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
                ClassDescriptor classDescriptor3 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                if ((classDescriptor3 != null ? classDescriptor3.getKind() : null) == ClassKind.ANNOTATION_CLASS) {
                    return true;
                }
            }
            return false;
        }

        public final boolean returnTypeRequired(@NotNull KtCallableDeclaration element2, @Nullable DeclarationDescriptor descriptor2, boolean checkForPublicApi, boolean checkForInternal, boolean checkForPrivate) {
            Visibility visibility2;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element2);
            boolean bl = ktClassOrObject != null ? ktClassOrObject.isLocal() : false;
            if (bl) {
                return false;
            }
            if (element2 instanceof KtFunction && ((KtFunction)element2).isLocal()) {
                return false;
            }
            if (element2 instanceof KtProperty && ((KtProperty)element2).isLocal()) {
                return false;
            }
            CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor2 : null;
            Object object = callableMemberDescriptor;
            Visibility visibility3 = visibility2 = object != null && (object = EffectiveVisibilityUtilsKt.effectiveVisibility$default((DeclarationDescriptorWithVisibility)object, null, false, 3, null)) != null ? ((EffectiveVisibility)object).toVisibility() : null;
            boolean isPublicApi = (visibility3 != null ? visibility3.isPublicAPI() : false) || Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE) && DescriptorUtilsKt.isPublishedApi(callableMemberDescriptor);
            return checkForPublicApi && isPublicApi || checkForInternal && Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE) || checkForPrivate && Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE);
        }

        public final boolean returnTypeCheckIsApplicable(@NotNull KtCallableDeclaration element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (element2.getContainingFile() instanceof KtCodeFragment) {
                return false;
            }
            if (element2 instanceof KtFunctionLiteral) {
                return false;
            }
            if (element2 instanceof KtConstructor) {
                return false;
            }
            if (element2.getTypeReference() != null) {
                return false;
            }
            return !(element2 instanceof KtNamedFunction) || !((KtNamedFunction)element2).hasBlockBody();
        }

        public final boolean publicReturnTypeShouldBePresentInApiMode(@NotNull KtCallableDeclaration element2, @NotNull LanguageVersionSettings languageVersionSettings2, @Nullable DeclarationDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
            boolean isInApiMode = languageVersionSettings2.getFlag(AnalysisFlags.getExplicitApiMode()) != ExplicitApiMode.DISABLED;
            return isInApiMode && this.returnTypeRequired(element2, descriptor2, true, false, false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

