/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.FunctionTypesKt;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import ksp.org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtPsiUtil;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import ksp.org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import ksp.org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import ksp.org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import ksp.org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import ksp.org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import ksp.org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import ksp.org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSupport;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import ksp.org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import ksp.org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import ksp.org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import ksp.org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import ksp.org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeConstructor;
import ksp.org.jetbrains.kotlin.types.TypeIntersector;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitution;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import ksp.org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ@\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018H\u0002JJ\u0010\u0019\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J6\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010%\u001a\u00020\u001dH\u0002J<\u0010&\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010)\u001a\u00020*H\u0002J\u001c\u0010+\u001a\u00020\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0018\u0010,\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u001dH\u0002J(\u0010.\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020(H\u0002J\u001e\u00104\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018J.\u00105\u001a\n 6*\u0004\u0018\u00010\u001d0\u001d2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u00107\u001a\u00020\u001d2\b\u00108\u001a\u0004\u0018\u00010\u001dH\u0002J:\u00109\u001a\u0004\u0018\u00010\u001d\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u00182\u0006\u0010%\u001a\u00020\u001dH\u0002J:\u0010:\u001a\u0004\u0018\u00010\u001d\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u00182\u0006\u0010;\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010<\u001a\u00020=\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018J*\u0010>\u001a\u0004\u0018\u00010\u001d2\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030?H\u0002J\f\u0010@\u001a\u00020(*\u00020\u0016H\u0002J \u0010A\u001a\u0004\u0018\u00010\u001d*\u00020\u00162\u0006\u0010B\u001a\u00020C2\b\u0010-\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "", "argumentTypeResolver", "Lksp/org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "builderInferenceSupport", "Lksp/org/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lksp/org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "addConstraintForCallableReference", "", "D", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "callableReference", "Lksp/org/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "valueArgument", "Lksp/org/jetbrains/kotlin/psi/ValueArgument;", "valueParameterDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "constraintSystem", "Lksp/org/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "addConstraintForFunctionLiteralArgument", "functionLiteral", "Lksp/org/jetbrains/kotlin/psi/KtFunction;", "argumentOwnerReturnType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "addConstraintForNestedCall", "", "argumentExpression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "constraintPosition", "Lksp/org/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "builder", "effectiveExpectedType", "addConstraintForValueArgument", "substitutor", "Lksp/org/jetbrains/kotlin/types/TypeSubstitutor;", "resolveFunctionArgumentBodies", "Lksp/org/jetbrains/kotlin/resolve/calls/util/ResolveArgumentsMode;", "addExpectedTypeForExplicitCast", "addValidityConstraintsForConstituentTypes", "type", "addValidityConstraintsForTypeArgument", "substitutedArgument", "Lksp/org/jetbrains/kotlin/types/TypeProjection;", "typeParameter", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "boundsSubstitutor", "completeTypeInferenceDependentOnFunctionArgumentsForCall", "estimateLiteralReturnType", "kotlin.jvm.PlatformType", "literalExpectedType", "ownerReturnType", "getExpectedTypeForCallableReference", "getResolvedTypeForCallableReference", "expectedType", "inferTypeArguments", "Lksp/org/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "updateResultTypeForSmartCasts", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "compositeSubstitutor", "typeInSystem", "call", "Lksp/org/jetbrains/kotlin/psi/Call;", "frontend"})
@SourceDebugExtension(value={"SMAP\nGenericCandidateResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericCandidateResolver.kt\norg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,534:1\n1872#2,3:535\n1755#2,3:538\n1611#2,9:541\n1863#2:550\n1864#2:552\n1620#2:553\n1#3:551\n*S KotlinDebug\n*F\n+ 1 GenericCandidateResolver.kt\norg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver\n*L\n159#1:535,3\n259#1:538,3\n264#1:541,9\n264#1:550\n264#1:552\n264#1:553\n264#1:551\n*E\n"})
public final class GenericCandidateResolver {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final BuilderInferenceSupport builderInferenceSupport;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public GenericCandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull BuilderInferenceSupport builderInferenceSupport, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter((Object)argumentTypeResolver, (String)"argumentTypeResolver");
        Intrinsics.checkNotNullParameter((Object)builderInferenceSupport, (String)"builderInferenceSupport");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.argumentTypeResolver = argumentTypeResolver;
        this.builderInferenceSupport = builderInferenceSupport;
        this.languageVersionSettings = languageVersionSettings2;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(@NotNull CallCandidateResolutionContext<D> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        MutableResolvedCall mutableResolvedCall = context2.candidateCall;
        Intrinsics.checkNotNullExpressionValue(mutableResolvedCall, (String)"candidateCall");
        MutableResolvedCall candidateCall = mutableResolvedCall;
        Object d = candidateCall.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, (String)"getCandidateDescriptor(...)");
        Object candidate2 = d;
        ConstraintSystemBuilderImpl builder2 = new ConstraintSystemBuilderImpl(null, 1, null);
        ConstraintSystem.Builder builder3 = builder2;
        Call call2 = candidateCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        CallHandle callHandle = TypeVariableKt.toHandle(call2);
        List<TypeParameterDescriptor> list2 = candidate2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
        ConstraintSystem.Builder.registerTypeVariables$default(builder3, callHandle, list2, false, 4, null);
        List<TypeParameterDescriptor> list3 = candidate2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeParameters(...)");
        Collection collection = list3;
        SimpleType simpleType2 = TypeUtils.DONT_CARE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"DONT_CARE");
        TypeSubstitutor substituteDontCare = GenericCandidateResolverKt.makeConstantSubstitutor(collection, simpleType2);
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = candidateCall.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor candidateParameter = entry.getKey();
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidate2.getValueParameters().get(candidateParameter.getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                Intrinsics.checkNotNull((Object)valueArgument);
                Intrinsics.checkNotNull((Object)valueParameterDescriptor);
                this.addConstraintForValueArgument(valueArgument, valueParameterDescriptor, substituteDontCare, builder2, context2, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            }
        }
        if (candidate2 instanceof TypeAliasConstructorDescriptor) {
            KotlinType kotlinType = this.compositeSubstitutor(builder2).safeSubstitute(((TypeAliasConstructorDescriptor)candidate2).getReturnType(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"safeSubstitute(...)");
            KotlinType substitutedReturnType = kotlinType;
            this.addValidityConstraintsForConstituentTypes(builder2, substitutedReturnType);
        }
        ReceiverValue receiverArgument = candidateCall.getExtensionReceiver();
        ReceiverParameterDescriptor receiverParameter = candidate2.getExtensionReceiverParameter();
        if (receiverArgument != null && receiverParameter != null) {
            KotlinType receiverType2;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType receiverArgumentType = kotlinType;
            Call call3 = context2.candidateCall.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)call3, (String)"getCall(...)");
            KotlinType kotlinType2 = receiverType2 = CallUtilKt.isSafeCall(call3) ? TypeUtils.makeNotNullable(receiverArgumentType) : receiverArgumentType;
            if (receiverArgument instanceof ExpressionReceiver) {
                receiverType2 = this.updateResultTypeForSmartCasts(receiverType2, ((ExpressionReceiver)receiverArgument).getExpression(), (ResolutionContext)context2);
            }
            builder2.addSubtypeConstraint(receiverType2, this.compositeSubstitutor(builder2).substitute(receiverParameter.getType(), Variance.INVARIANT), ConstraintPositionKind.RECEIVER_POSITION.position());
        }
        ConstraintSystem constraintSystem = builder2.build();
        candidateCall.setConstraintSystem(constraintSystem);
        boolean hasContradiction = constraintSystem.getStatus().hasContradiction();
        if (!hasContradiction) {
            this.addExpectedTypeForExplicitCast(context2, builder2);
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        return ResolutionStatus.OTHER_ERROR;
    }

    private final KotlinType typeInSystem(ConstraintSystem.Builder $this$typeInSystem, Call call2, KotlinType type2) {
        KotlinType kotlinType;
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            TypeSubstitutor typeSubstitutor2 = $this$typeInSystem.getTypeVariableSubstitutors().get(TypeVariableKt.toHandle(call2));
            kotlinType = typeSubstitutor2 != null ? typeSubstitutor2.substitute(it, Variance.INVARIANT) : null;
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    private final void addExpectedTypeForExplicitCast(CallCandidateResolutionContext<?> context2, ConstraintSystem.Builder builder2) {
        KotlinType expectedType;
        IElementType iElementType;
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ExpectedTypeFromCast)) {
            return;
        }
        if (context2.candidateCall instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object d = context2.candidateCall.getCandidateDescriptor();
        FunctionDescriptor functionDescriptor = d instanceof FunctionDescriptor ? (FunctionDescriptor)d : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor candidateDescriptor = functionDescriptor;
        KtExpression ktExpression = context2.call.getCalleeExpression();
        if (ktExpression == null || (ktExpression = KtPsiUtilKt.getBinaryWithTypeParent(ktExpression)) == null) {
            return;
        }
        KtExpression binaryParent = ktExpression;
        IElementType it = iElementType = ((KtBinaryExpressionWithTypeRHS)binaryParent).getOperationReference().getReferencedNameElementType();
        boolean bl = false;
        IElementType iElementType2 = Intrinsics.areEqual((Object)it, (Object)KtTokens.AS_KEYWORD) || Intrinsics.areEqual((Object)it, (Object)KtTokens.AS_SAFE) ? iElementType : null;
        if (iElementType2 == null) {
            return;
        }
        IElementType operationType = iElementType2;
        KtTypeReference ktTypeReference = ((KtBinaryExpressionWithTypeRHS)binaryParent).getRight();
        if (ktTypeReference == null) {
            return;
        }
        KotlinType kotlinType = (KotlinType)context2.trace.get(BindingContext.TYPE, ktTypeReference);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftType = kotlinType;
        KotlinType kotlinType2 = expectedType = Intrinsics.areEqual((Object)operationType, (Object)KtTokens.AS_SAFE) ? TypeUtilsKt.makeNullable(leftType) : leftType;
        if (context2.candidateCall.getCall().getTypeArgumentList() != null || !KtDescriptorUtilKt.isFunctionForExpectTypeFromCastFeature(candidateDescriptor)) {
            return;
        }
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        KotlinType kotlinType3 = candidateDescriptor.getReturnType();
        if (kotlinType3 == null) {
            return;
        }
        KotlinType kotlinType4 = this.typeInSystem(builder2, call2, kotlinType3);
        if (kotlinType4 == null) {
            return;
        }
        KotlinType typeInSystem = kotlinType4;
        context2.trace.record(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, binaryParent);
        builder2.addSubtypeConstraint(typeInSystem, expectedType, ConstraintPositionKind.SPECIAL.position());
    }

    /*
     * WARNING - void declaration
     */
    private final void addValidityConstraintsForConstituentTypes(ConstraintSystem.Builder builder2, KotlinType type2) {
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (typeConstructor2.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return;
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
        TypeSubstitutor boundsSubstitutor = typeSubstitutor2;
        Iterable $this$forEachIndexed$iv = type2.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeProjection;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv;
            int i = n;
            boolean bl = false;
            if (typeProjection.isStarProjection()) continue;
            TypeParameterDescriptor typeParameter = typeConstructor2.getParameters().get(i);
            Intrinsics.checkNotNull((Object)typeParameter);
            this.addValidityConstraintsForTypeArgument(builder2, (TypeProjection)typeProjection, typeParameter, boundsSubstitutor);
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            this.addValidityConstraintsForConstituentTypes(builder2, kotlinType);
        }
    }

    private final void addValidityConstraintsForTypeArgument(ConstraintSystem.Builder builder2, TypeProjection substitutedArgument, TypeParameterDescriptor typeParameter, TypeSubstitutor boundsSubstitutor) {
        KotlinType kotlinType = substitutedArgument.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType substitutedType = kotlinType;
        for (KotlinType upperBound : typeParameter.getUpperBounds()) {
            KotlinType kotlinType2 = boundsSubstitutor.safeSubstitute(upperBound, Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"safeSubstitute(...)");
            SimpleType substitutedUpperBound = FlexibleTypesKt.upperIfFlexible(kotlinType2);
            ValidityConstraintForConstituentType constraintPosition = new ValidityConstraintForConstituentType(substitutedType, typeParameter, substitutedUpperBound);
            if (KotlinBuiltIns.isNullableAny(substitutedUpperBound)) continue;
            builder2.addSubtypeConstraint(substitutedType, substitutedUpperBound, constraintPosition);
        }
    }

    private final TypeSubstitutor compositeSubstitutor(ConstraintSystem.Builder $this$compositeSubstitutor) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeSubstitution($this$compositeSubstitutor){
            final /* synthetic */ ConstraintSystem.Builder $this_compositeSubstitutor;
            {
                this.$this_compositeSubstitutor = $receiver;
            }

            public TypeProjection get(KotlinType key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return (TypeProjection)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.reversed((Iterable)this.$this_compositeSubstitutor.getTypeVariableSubstitutors().values())), (Function1)((Function1)new Function1<TypeSubstitutor, TypeProjection>(key){
                    final /* synthetic */ KotlinType $key;
                    {
                        this.$key = $key;
                        super(1);
                    }

                    public final TypeProjection invoke(TypeSubstitutor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.getSubstitution().get(this.$key);
                    }
                })));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
        return typeSubstitutor2;
    }

    private final void addConstraintForValueArgument(ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, TypeSubstitutor substitutor2, ConstraintSystem.Builder builder2, CallCandidateResolutionContext<?> context2, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context2);
        KtExpression argumentExpression = valueArgument.getArgumentExpression();
        KotlinType expectedType = substitutor2.substitute(effectiveExpectedType, Variance.INVARIANT);
        DataFlowInfo dataFlowInfo = context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"getInfo(...)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        Object Context2 = ((CallCandidateResolutionContext)context2.replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceDataFlowInfo(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        KotlinType kotlinType = expectedType;
        KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies, kotlinType != null ? FunctionTypesKt.isSuspendFunctionType(kotlinType) : false);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getArgumentTypeInfo(...)");
        KotlinTypeInfo typeInfoForCall = kotlinTypeInfo;
        context2.candidateCall.getDataFlowInfoForArguments().updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        ConstraintPosition constraintPosition = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (this.addConstraintForNestedCall(argumentExpression, constraintPosition, builder2, newContext, effectiveExpectedType)) {
            return;
        }
        KotlinType kotlinType2 = typeInfoForCall.getType();
        Object Context3 = context2.replaceDataFlowInfo(dataFlowInfoForArgument);
        Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceDataFlowInfo(...)");
        KotlinType type2 = this.updateResultTypeForSmartCasts(kotlinType2, argumentExpression, (ResolutionContext<?>)Context3);
        if (argumentExpression instanceof KtCallableReferenceExpression && type2 == null) {
            return;
        }
        builder2.addSubtypeConstraint(type2, this.compositeSubstitutor(builder2).substitute(effectiveExpectedType, Variance.INVARIANT), constraintPosition);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addConstraintForNestedCall(KtExpression argumentExpression, ConstraintPosition constraintPosition, ConstraintSystem.Builder builder2, CallCandidateResolutionContext<?> context2, KotlinType effectiveExpectedType) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        KotlinType returnType2;
        Object candidateDescriptor;
        ResolvedCall nestedCall;
        block9: {
            OverloadResolutionResultsImpl<?> resolutionResults;
            ResolutionResultsCache.CachedData cachedData = GenericCandidateResolverKt.getResolutionResultsCachedData(argumentExpression, (ResolutionContext)context2);
            OverloadResolutionResultsImpl<Object> overloadResolutionResultsImpl = resolutionResults = cachedData != null ? cachedData.getResolutionResults() : null;
            if (resolutionResults == null || !resolutionResults.isSingleResult()) {
                return false;
            }
            ResolvedCall resolvedCall2 = resolutionResults.getResultingCall();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"getResultingCall(...)");
            nestedCall = resolvedCall2;
            if (nestedCall.isCompleted()) {
                return false;
            }
            ConstraintSystem constraintSystem = nestedCall.getConstraintSystem();
            if (constraintSystem == null) {
                return false;
            }
            ConstraintSystem nestedConstraintSystem = constraintSystem;
            candidateDescriptor = nestedCall.getCandidateDescriptor();
            KotlinType kotlinType = candidateDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            returnType2 = kotlinType;
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(nestedConstraintSystem, returnType2);
            Iterable $this$any$iv = nestedTypeVariables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !nestedConstraintSystem.getTypeBounds(it).getBounds().isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidateDescriptor);
        List<TypeParameterDescriptor> list2 = candidateDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypeParameters(...)");
        Iterable iterable = list2;
        List<TypeParameterDescriptor> list3 = candidateWithFreshVariables.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getTypeParameters(...)");
        Map conversion = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable, (Iterable)list3));
        Iterable $this$mapNotNull$iv = ConstraintSystemUtilsKt.getNestedTypeParameters(returnType2);
        boolean $i$f$mapNotNull = false;
        Iterable bl2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl5 = false;
            if ((TypeParameterDescriptor)conversion.get(it) == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List freshVariables = (List)destination$iv$iv;
        Call call2 = nestedCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
        builder2.registerTypeVariables(TypeVariableKt.toHandle(call2), freshVariables, true);
        KotlinType argumentExpressionType = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(nestedCall, candidateWithFreshVariables.getReturnType(), (CallResolutionContext)context2);
        builder2.addSubtypeConstraint(argumentExpressionType, this.compositeSubstitutor(builder2).substitute(effectiveExpectedType, Variance.INVARIANT), constraintPosition);
        return true;
    }

    private final KotlinType updateResultTypeForSmartCasts(KotlinType type2, KtExpression argumentExpression, ResolutionContext<?> context2) {
        KtExpression deparenthesizedArgument = KtPsiUtil.getLastElementDeparenthesized(argumentExpression, context2.statementFilter);
        if (deparenthesizedArgument == null || type2 == null) {
            return type2;
        }
        DataFlowValue dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(deparenthesizedArgument, type2, context2);
        if (!dataFlowValue2.isStable()) {
            return type2;
        }
        DataFlowInfo dataFlowInfo = context2.dataFlowInfo;
        LanguageVersionSettings languageVersionSettings2 = context2.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Set<KotlinType> possibleTypes2 = dataFlowInfo.getCollectedTypes(dataFlowValue2, languageVersionSettings2);
        if (possibleTypes2.isEmpty()) {
            return type2;
        }
        return TypeIntersector.intersectTypes(SetsKt.plus(possibleTypes2, (Object)type2));
    }

    public final <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionArgumentsForCall(@NotNull CallCandidateResolutionContext<D> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        MutableResolvedCall mutableResolvedCall = context2.candidateCall;
        Intrinsics.checkNotNullExpressionValue(mutableResolvedCall, (String)"candidateCall");
        MutableResolvedCall resolvedCall2 = mutableResolvedCall;
        Object object = resolvedCall2.getConstraintSystem();
        if (object == null || (object = ConstraintSystem.toBuilder$default((ConstraintSystem)object, null, 1, null)) == null) {
            return;
        }
        Object constraintSystem = object;
        CallCandidateResolutionContext newContext = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? CallCandidateResolutionContext.create(resolvedCall2, context2, context2.trace, context2.tracing, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall().getCall(), context2.candidateResolveMode) : context2;
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor valueParameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtCallableReferenceExpression callableReference2;
                CallCandidateResolutionContext temporaryContextForCall;
                CallCandidateResolutionContext callCandidateResolutionContext;
                KtExpression argumentExpression;
                if (valueArgument.getArgumentExpression() == null) continue;
                boolean bl = false;
                if (ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(argumentExpression, newContext) != null) {
                    KtFunction functionLiteral;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)functionLiteral);
                    Intrinsics.checkNotNull((Object)valueArgument);
                    Intrinsics.checkNotNull((Object)valueParameterDescriptor);
                    Intrinsics.checkNotNull(newContext);
                    this.addConstraintForFunctionLiteralArgument(functionLiteral, valueArgument, valueParameterDescriptor, (ConstraintSystem.Builder)constraintSystem, newContext, resolvedCall2.getCandidateDescriptor().getReturnType());
                }
                if (GenericCandidateResolverKt.getSPECIAL_FUNCTION_NAMES().contains(resolvedCall2.getCandidateDescriptor().getName())) {
                    callCandidateResolutionContext = newContext;
                } else {
                    TemporaryBindingTrace temporaryBindingTrace;
                    Intrinsics.checkNotNullExpressionValue((Object)TemporaryBindingTrace.create(newContext.trace, "Trace to complete argument for call that might be not resulting call"), (String)"create(...)");
                    callCandidateResolutionContext = temporaryContextForCall = (CallCandidateResolutionContext)newContext.replaceBindingTrace(temporaryBindingTrace);
                }
                if (ArgumentTypeResolver.getCallableReferenceExpressionIfAny(argumentExpression, newContext) == null) continue;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)callableReference2);
                Intrinsics.checkNotNull((Object)valueArgument);
                Intrinsics.checkNotNull((Object)valueParameterDescriptor);
                Intrinsics.checkNotNull((Object)temporaryContextForCall);
                this.addConstraintForCallableReference(callableReference2, valueArgument, valueParameterDescriptor, (ConstraintSystem.Builder)constraintSystem, temporaryContextForCall);
            }
        }
        ConstraintSystem resultingSystem = constraintSystem.build();
        resolvedCall2.setConstraintSystem(resultingSystem);
        boolean isNewInferenceEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        TypeSubstitutor typeSubstitutor2 = isNewInferenceEnabled ? resultingSystem.getResultingSubstitutor().replaceWithContravariantApproximatingSubstitution() : resultingSystem.getResultingSubstitutor();
        Intrinsics.checkNotNull((Object)typeSubstitutor2);
        TypeSubstitutor resultingSubstitutor2 = typeSubstitutor2;
        resolvedCall2.setSubstitutor(resultingSubstitutor2);
    }

    private final KotlinType estimateLiteralReturnType(CallCandidateResolutionContext<?> context2, KotlinType literalExpectedType, KotlinType ownerReturnType) {
        return !TypeUtils.noExpectedType(context2.expectedType) && ownerReturnType != null && TypeUtils.isTypeParameter(ownerReturnType) && FunctionTypesKt.isFunctionTypeOrSubtype(literalExpectedType) && Intrinsics.areEqual((Object)CallResolverUtilKt.getReturnTypeForCallable(literalExpectedType), (Object)ownerReturnType) ? context2.expectedType : (KotlinType)TypeUtils.DONT_CARE;
    }

    private final <D extends CallableDescriptor> void addConstraintForFunctionLiteralArgument(KtFunction functionLiteral, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context2, KotlinType argumentOwnerReturnType) {
        TypeSubstitutor currentSubstitutor2;
        TypeSubstitution typeSubstitution;
        DelegatedTypeSubstitution newSubstitution2;
        KotlinType expectedType;
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context2);
        if (BuilderInferenceUtilKt.isBuilderInferenceCall(valueParameterDescriptor, valueArgument, this.languageVersionSettings)) {
            this.builderInferenceSupport.analyzeBuilderInferenceCall(functionLiteral, valueArgument, constraintSystem, context2, effectiveExpectedType);
        }
        if ((expectedType = (newSubstitution2 = new DelegatedTypeSubstitution(typeSubstitution = (currentSubstitutor2 = constraintSystem.build().getCurrentSubstitutor()).getSubstitution()){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        }).buildSubstitutor().substitute(effectiveExpectedType, Variance.IN_VARIANCE)) == null || TypeUtils.isDontCarePlaceholder(expectedType)) {
            KotlinType kotlinType = expectedType;
            expectedType = this.argumentTypeResolver.getShapeTypeOfFunctionLiteral(functionLiteral, context2.scope, context2.trace, false, kotlinType != null ? FunctionTypesKt.isSuspendFunctionType(kotlinType) : false);
        }
        if (expectedType == null || !FunctionTypesKt.isBuiltinFunctionalType(expectedType) || CallResolverUtilKt.hasUnknownFunctionParameter(expectedType)) {
            return;
        }
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context2.candidateCall.getDataFlowInfoForArguments();
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataFlowInfoForArguments, (String)"getDataFlowInfoForArguments(...)");
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = mutableDataFlowInfoForArguments;
        DataFlowInfo dataFlowInfo = dataFlowInfoForArguments.getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"getInfo(...)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
        KotlinType effectiveExpectedTypeInSystem = typeSubstitutor2 != null ? typeSubstitutor2.substitute(effectiveExpectedType, Variance.INVARIANT) : null;
        boolean hasExpectedReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType);
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        if (hasExpectedReturnType) {
            TemporaryTraceAndCache temporaryToResolveFunctionLiteral = TemporaryTraceAndCache.create(context2, "trace to resolve function literal with expected return type", argumentExpression);
            KtExpression ktExpression2 = KtPsiUtil.getExpressionOrLastStatementInBlock(functionLiteral.getBodyExpression());
            if (ktExpression2 == null) {
                return;
            }
            KtExpression statementExpression = ktExpression2;
            boolean[] mismatch = new boolean[1];
            ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryToResolveFunctionLiteral.trace, statementExpression, mismatch);
            Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceBindingTrace(errorInterceptingTrace)).replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceResolutionResultsCache(temporaryToResolveFunctionLiteral.cache)).replaceContextDependency(ContextDependency.INDEPENDENT);
            Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceContextDependency(...)");
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
            KotlinType type2 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, FunctionTypesKt.isSuspendFunctionType(expectedType)).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type2, effectiveExpectedTypeInSystem, position);
                temporaryToResolveFunctionLiteral.commit();
                return;
            }
        }
        KotlinType estimatedReturnType = this.estimateLiteralReturnType(context2, effectiveExpectedType, argumentOwnerReturnType);
        Intrinsics.checkNotNull((Object)estimatedReturnType);
        KotlinType expectedTypeWithEstimatedReturnType = CallResolverUtilKt.replaceReturnTypeForCallable(expectedType, estimatedReturnType);
        Object Context3 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(expectedTypeWithEstimatedReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context3, (String)"replaceContextDependency(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context3;
        KotlinType type3 = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, FunctionTypesKt.isSuspendFunctionType(expectedType)).getType();
        constraintSystem.addSubtypeConstraint(type3, effectiveExpectedTypeInSystem, position);
    }

    private final <D extends CallableDescriptor> void addConstraintForCallableReference(KtCallableReferenceExpression callableReference2, ValueArgument valueArgument, ValueParameterDescriptor valueParameterDescriptor, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context2) {
        KotlinType effectiveExpectedType = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument, (ResolutionContext)context2);
        KotlinType kotlinType = this.getExpectedTypeForCallableReference(callableReference2, constraintSystem, context2, effectiveExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType expectedType = kotlinType;
        if (!GenericCandidateResolverKt.access$isApplicableExpectedTypeForCallableReference(expectedType)) {
            return;
        }
        KotlinType kotlinType2 = this.getResolvedTypeForCallableReference(callableReference2, context2, expectedType, valueArgument);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType resolvedType = kotlinType2;
        ConstraintPosition position = ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex());
        Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
        Call call2 = context2.call;
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
        TypeSubstitutor typeSubstitutor2 = map.get(TypeVariableKt.toHandle(call2));
        constraintSystem.addSubtypeConstraint(resolvedType, typeSubstitutor2 != null ? typeSubstitutor2.substitute(effectiveExpectedType, Variance.INVARIANT) : null, position);
    }

    private final <D extends CallableDescriptor> KotlinType getExpectedTypeForCallableReference(KtCallableReferenceExpression callableReference2, ConstraintSystem.Builder constraintSystem, CallCandidateResolutionContext<D> context2, KotlinType effectiveExpectedType) {
        KotlinType substitutedType = constraintSystem.build().getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (substitutedType != null && !TypeUtils.isDontCarePlaceholder(substitutedType)) {
            return substitutedType;
        }
        KotlinType shapeType = this.argumentTypeResolver.getShapeTypeOfCallableReference(callableReference2, (CallResolutionContext)context2, false);
        if (shapeType != null && FunctionTypesKt.isFunctionTypeOrSubtype(shapeType) && !CallResolverUtilKt.hasUnknownFunctionParameter(shapeType)) {
            return shapeType;
        }
        return null;
    }

    private final <D extends CallableDescriptor> KotlinType getResolvedTypeForCallableReference(KtCallableReferenceExpression callableReference2, CallCandidateResolutionContext<D> context2, KotlinType expectedType, ValueArgument valueArgument) {
        DataFlowInfo dataFlowInfo = context2.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"getInfo(...)");
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfo;
        KotlinType expectedTypeWithoutReturnType = !CallResolverUtilKt.hasUnknownReturnType(expectedType) ? CallResolverUtilKt.replaceReturnTypeByUnknown(expectedType) : expectedType;
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)context2.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceContextDependency(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        return this.argumentTypeResolver.getCallableReferenceTypeInfo(callableReference2, callableReference2, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
    }
}

