/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DeclarationsChecker;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/resolve/LateinitModifierApplicabilityChecker;", "", "()V", "checkLateinitModifierApplicability", "", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "ktDeclaration", "Lksp/org/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/VariableDescriptor;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "hasUnderlyingTypeForbiddenForLateinit", "", "type", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "frontend"})
public final class LateinitModifierApplicabilityChecker {
    @NotNull
    public static final LateinitModifierApplicabilityChecker INSTANCE = new LateinitModifierApplicabilityChecker();

    private LateinitModifierApplicabilityChecker() {
    }

    public final void checkLateinitModifierApplicability(@NotNull BindingTrace trace, @NotNull KtCallableDeclaration ktDeclaration, @NotNull VariableDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        if (!ktDeclaration.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            return;
        }
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor instanceof PropertyDescriptor) {
            string2 = "properties";
        } else if (variableDescriptor instanceof LocalVariableDescriptor) {
            string2 = "local variables";
        } else {
            throw new AssertionError((Object)("Should be a property or a local variable: " + descriptor2));
        }
        String variables2 = string2;
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        if (!descriptor2.isVar()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is allowed only on mutable " + variables2));
        }
        if (InlineClassesUtilsKt.isInlineClassType(type2)) {
            if (TypeUtilsKt.isUnsignedNumberType(type2)) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of unsigned types"));
            } else if (!languageVersionSettings2.supportsFeature(LanguageFeature.InlineLateinit)) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of inline class types"));
            } else if (this.hasUnderlyingTypeForbiddenForLateinit(type2)) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of inline type with underlying type not suitable for lateinit declaration"));
            }
        }
        if (type2.isMarkedNullable()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of nullable types"));
        } else if (TypeUtils.isNullableType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of a type with nullable upper bound"));
        }
        if (KotlinBuiltIns.isPrimitiveType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of primitive types"));
        }
        if (ktDeclaration instanceof KtProperty) {
            if (((KtProperty)ktDeclaration).hasDelegateExpression()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on delegated properties"));
            } else if (((KtProperty)ktDeclaration).hasInitializer()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " with initializer"));
            }
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            boolean isAbstract2 = ((PropertyDescriptor)descriptor2).getModality() == Modality.ABSTRACT;
            boolean hasDelegateExpressionOrInitializer = ktDeclaration instanceof KtProperty && ((KtProperty)ktDeclaration).hasDelegateExpressionOrInitializer();
            boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAnyAccessorImplementation((PropertyDescriptor)descriptor2);
            Boolean bl = (Boolean)trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2);
            if (bl == null) {
                bl = false;
            }
            boolean hasBackingField2 = bl;
            if (ktDeclaration instanceof KtParameter) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on primary constructor parameters"));
            }
            if (isAbstract2) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on abstract properties"));
            }
            if (!hasDelegateExpressionOrInitializer) {
                if (hasAccessorImplementation) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on properties with a custom getter or setter"));
                } else if (!isAbstract2 && !hasBackingField2) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on properties without backing field"));
                }
            }
            if (((PropertyDescriptor)descriptor2).getExtensionReceiverParameter() != null) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on extension properties"));
            }
        }
    }

    private final boolean hasUnderlyingTypeForbiddenForLateinit(KotlinType type2) {
        if (InlineClassesUtilsKt.isRecursiveInlineOrValueClassType(type2)) {
            return false;
        }
        return LateinitModifierApplicabilityChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenForLateinit(LateinitModifierApplicabilityChecker.hasUnderlyingTypeForbiddenForLateinit$getUnderlyingType(type2));
    }

    private static final KotlinType hasUnderlyingTypeForbiddenForLateinit$getUnderlyingType(KotlinType type2) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull((Object)classifierDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        InlineClassRepresentation<SimpleType> inlineClassRepresentation = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)classifierDescriptor);
        Intrinsics.checkNotNull(inlineClassRepresentation);
        return inlineClassRepresentation.getUnderlyingType();
    }

    private static final boolean hasUnderlyingTypeForbiddenForLateinit$isForbiddenForLateinit(KotlinType type2) {
        if (type2.isMarkedNullable() || TypeUtils.isNullableType(type2)) {
            return true;
        }
        if (KotlinBuiltIns.isPrimitiveType(type2)) {
            return true;
        }
        if (InlineClassesUtilsKt.isInlineClassType(type2)) {
            return LateinitModifierApplicabilityChecker.hasUnderlyingTypeForbiddenForLateinit$isForbiddenForLateinit(LateinitModifierApplicabilityChecker.hasUnderlyingTypeForbiddenForLateinit$getUnderlyingType(type2));
        }
        return false;
    }
}

