/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import ksp.org.jetbrains.kotlin.ir.interpreter.Instruction;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import ksp.org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import ksp.org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.State;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import ksp.org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/intrinsics/ArrayConstructor;", "Lksp/org/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lksp/org/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getListOfAcceptableFunctions", "", "", "unwind", "Lksp/org/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class ArrayConstructor
extends IntrinsicBase {
    @NotNull
    public static final ArrayConstructor INSTANCE = new ArrayConstructor();

    private ArrayConstructor() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        Object[] objectArray = new String[]{"kotlin.Array.<init>", "kotlin.ByteArray.<init>", "kotlin.CharArray.<init>", "kotlin.ShortArray.<init>", "kotlin.IntArray.<init>", "kotlin.LongArray.<init>", "kotlin.FloatArray.<init>", "kotlin.DoubleArray.<init>", "kotlin.BooleanArray.<init>"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (irFunction.getValueParameters().size() == 1) {
            return super.unwind(irFunction, environment);
        }
        CallStack callStack = environment.getCallStack$ir_interpreter();
        List instructions = CollectionsKt.toMutableList((Collection)super.unwind(irFunction, environment));
        IrValueParameterSymbol sizeSymbol = irFunction.getValueParameters().get(0).getSymbol();
        int size = StateKt.asInt(callStack.loadState(sizeSymbol));
        IrValueParameterSymbol initSymbol = irFunction.getValueParameters().get(1).getSymbol();
        State it = callStack.loadState(initSymbol);
        boolean bl = false;
        KFunctionState kFunctionState = it instanceof KFunctionState ? (KFunctionState)it : null;
        if (kFunctionState == null) {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState");
            kFunctionState = ((KPropertyState)it).convertGetterToKFunctionState(environment);
        }
        KFunctionState state = kFunctionState;
        callStack.rewriteState(initSymbol, state);
        for (int i = size - 1; -1 < i; --i) {
            IrFunction irFunction2 = state.getInvokeSymbol().getOwner();
            Intrinsics.checkNotNull((Object)irFunction2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            IrCall call2 = IrTreeBuildUtilsKt.createCall$default((IrSimpleFunction)irFunction2, null, 1, null);
            call2.setDispatchReceiver(IrTreeBuildUtilsKt.createGetValue(initSymbol.getOwner()));
            call2.putValueArgument(0, IrUtilsKt.toIrConst$default(i, environment.getIrBuiltIns().getIntType(), 0, 0, 6, null));
            ((Collection)instructions).add(new CompoundInstruction(call2));
        }
        return instructions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        List<Object> list2;
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrValueParameterSymbol sizeDescriptor = irFunction.getValueParameters().get(0).getSymbol();
        int size = StateKt.asInt(environment.getCallStack$ir_interpreter().loadState(sizeDescriptor));
        ArrayList<Character> arrayList = new ArrayList<Character>(size);
        for (int i = 0; i < size; ++i) {
            int n;
            int n2 = n = i;
            list2 = arrayList;
            boolean bl = false;
            ((ArrayList)list2).add(IrTypePredicatesKt.isCharArray(irFunction.getReturnType()) ? Character.valueOf('\u0000') : (IrTypePredicatesKt.isBooleanArray(irFunction.getReturnType()) ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)));
        }
        List arrayValue = arrayList;
        if (irFunction.getValueParameters().size() == 2) {
            for (int i = size - 1; -1 < i; --i) {
                void it;
                State state = environment.getCallStack$ir_interpreter().popState();
                int n = i;
                list2 = arrayValue;
                boolean bl = false;
                void var10_12 = it;
                Object object = var10_12 instanceof Wrapper ? ((Wrapper)it).getValue() : (var10_12 instanceof Primitive ? (IrTypePredicatesKt.isArray(((Primitive)it).getType()) || UtilsKt.isPrimitiveArray(((Primitive)it).getType()) ? it : ((Primitive)it).getValue()) : it);
                list2.set(n, object);
            }
        }
        State state = environment.getCallStack$ir_interpreter().loadState(irFunction.getSymbol());
        Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
        IrType type2 = ((KTypeState)state).getIrType();
        environment.getCallStack$ir_interpreter().pushState(UtilsKt.toPrimitiveStateArray(arrayValue, type2));
    }
}

