/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.incremental.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.util.io.KeyDescriptor;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import ksp.org.jetbrains.kotlin.incremental.storage.StringExternalizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/incremental/storage/FileDescriptor;", "Lksp/com/intellij/util/io/KeyDescriptor;", "Ljava/io/File;", "pathConverter", "Lksp/org/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "getHashCode", "", "file", "isEqual", "", "file1", "file2", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "kotlin-build-common"})
final class FileDescriptor
implements KeyDescriptor<File> {
    @NotNull
    private final FileToPathConverter pathConverter;

    public FileDescriptor(@NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        this.pathConverter = pathConverter;
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        StringExternalizer.INSTANCE.save(output, this.pathConverter.toPath(file2));
    }

    @Override
    @NotNull
    public File read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.pathConverter.toFile(StringExternalizer.INSTANCE.read(input));
    }

    @Override
    public int getHashCode(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.pathConverter.toPath(file2).hashCode();
    }

    @Override
    public boolean isEqual(@NotNull File file1, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        return Intrinsics.areEqual((Object)file1, (Object)file2);
    }
}

