/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import ksp.org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import ksp.org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H$J\b\u0010\u0016\u001a\u00020\u0017H&J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00122\u001c\u0010\u001a\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00190\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "Lksp/org/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "klass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "useSiteSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "scopeOwnerLookupNames", "", "", "getScopeOwnerLookupNames", "()Ljava/util/List;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getCallableNames", "", "Lksp/org/jetbrains/kotlin/name/Name;", "getNestedClassSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "name", "isEmpty", "", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lksp/org/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirNestedClassifierScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNestedClassifierScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n54#2:108\n1187#3,2:109\n1261#3,4:111\n*S KotlinDebug\n*F\n+ 1 FirNestedClassifierScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope\n*L\n53#1:108\n40#1:109,2\n40#1:111,4\n*E\n"})
public abstract class FirNestedClassifierScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirClass klass;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirNestedClassifierScope(@NotNull FirClass klass, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        this.klass = klass;
        this.useSiteSession = useSiteSession;
        FirClassLikeDeclaration $this$isLocal$iv = this.klass;
        boolean $i$f$isLocal = false;
        this.scopeOwnerLookupNames = $this$isLocal$iv.getSymbol().getClassId().isLocal() ? CollectionsKt.emptyList() : (List)new SmartList<String>(FirDeclarationUtilKt.getClassId(this.klass).asFqNameString());
    }

    @NotNull
    public final FirClass getKlass() {
        return this.klass;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @Nullable
    protected abstract FirClassLikeSymbol<?> getNestedClassSymbol(@NotNull Name var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        ConeSubstitutor coneSubstitutor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getNestedClassSymbol(name2);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> matchedClass = firClassLikeSymbol;
        if (this.klass.getTypeParameters().isEmpty()) {
            coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = this.klass.getTypeParameters();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getSymbol(), (Object)FirNestedClassifierScopeKt.toConeType(it));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map substitution = destination$iv$iv;
            coneSubstitutor = ConeSubstitutorByMap.Companion.create$default(ConeSubstitutorByMap.Companion, substitution, this.useSiteSession, false, 4, null);
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        processor2.invoke(matchedClass, (Object)substitutor2);
    }

    public abstract boolean isEmpty();

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }
}

